/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import java.util.Arrays;
import javax.annotation.Nonnull;
import org.lwjgl.system.MemoryUtil;
import yslelf.cloudpick.render.core.Canvas;
import yslelf.cloudpick.render.core.Font;
import yslelf.cloudpick.render.core.Glyph;
import yslelf.cloudpick.render.core.GlyphRun;
import yslelf.cloudpick.render.core.GlyphRunList;
import yslelf.cloudpick.render.core.Matrix;
import yslelf.cloudpick.render.core.Matrixc;
import yslelf.cloudpick.render.core.Paint;
import yslelf.cloudpick.render.core.Rect2f;
import yslelf.cloudpick.render.core.Rect2fc;
import yslelf.cloudpick.render.core.Strike;
import yslelf.cloudpick.render.core.StrikeCache;
import yslelf.cloudpick.render.core.StrikeDesc;
import yslelf.cloudpick.render.engine.RecordingContext;
import yslelf.cloudpick.render.granite.BakedGlyph;
import yslelf.cloudpick.render.granite.GlyphVector;
import yslelf.cloudpick.render.granite.GraniteDevice;
import yslelf.cloudpick.render.granite.MeshDrawWriter;

public class SubRunContainer {
    private final Matrix mInitialPositionMatrix;
    private SubRun mHead;
    private SubRun mTail;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Rect2f prepare_for_direct_mask_drawing(Strike strike, Matrixc creationMatrix, Buffers buffers) {
        int acceptedSize = 0;
        int rejectedSize = 0;
        Rect2f runBounds = new Rect2f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        Rect2f bounds = new Rect2f();
        float[] mappedPos = new float[2];
        strike.lock();
        try {
            int i = buffers.mSourceGlyphOffset;
            int j = buffers.mSourcePositionOffset;
            int e = buffers.mSourceGlyphOffset + buffers.mSourceGlyphCount;
            while (i < e) {
                float posX = buffers.mSourcePositions[j];
                float posY = buffers.mSourcePositions[j + 1];
                if (Float.isFinite(posX) && Float.isFinite(posY)) {
                    int glyphID = buffers.mSourceGlyphs[i];
                    Glyph glyph = strike.digestFor(0, glyphID);
                    switch (glyph.actionFor(0)) {
                        case 1: {
                            creationMatrix.mapPoints(buffers.mSourcePositions, j, mappedPos, 0, 1);
                            float roundedPosX = (float)Math.floor(mappedPos[0] + 0.5f);
                            float roundedPosY = (float)Math.floor(mappedPos[1] + 0.5f);
                            glyph.getBounds(bounds);
                            bounds.offset(roundedPosX, roundedPosY);
                            runBounds.joinNoCheck(bounds);
                            buffers.mAcceptedGlyphs[acceptedSize] = glyphID;
                            buffers.mAcceptedPositions[acceptedSize << 1] = bounds.x();
                            buffers.mAcceptedPositions[acceptedSize << 1 | 1] = bounds.y();
                            buffers.mAcceptedFormats[acceptedSize] = glyph.getMaskFormat();
                            ++acceptedSize;
                            break;
                        }
                        case 2: {
                            buffers.mRejectedGlyphs[rejectedSize] = glyphID;
                            buffers.mRejectedPositions[rejectedSize << 1] = posX;
                            buffers.mRejectedPositions[rejectedSize << 1 | 1] = posY;
                            ++rejectedSize;
                            break;
                        }
                    }
                }
                ++i;
                j += 2;
            }
        }
        finally {
            strike.unlock();
        }
        buffers.mAcceptedGlyphCount = acceptedSize;
        buffers.mRejectedGlyphCount = rejectedSize;
        return runBounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Rect2f prepare_for_transformed_mask_drawing(Strike strike, Matrixc creationMatrix, Buffers buffers) {
        int acceptedSize = 0;
        int rejectedSize = 0;
        Rect2f runBounds = new Rect2f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        Rect2f bounds = new Rect2f();
        float[] mappedPos = new float[2];
        strike.lock();
        try {
            int i = buffers.mSourceGlyphOffset;
            int j = buffers.mSourcePositionOffset;
            int e = buffers.mSourceGlyphOffset + buffers.mSourceGlyphCount;
            while (i < e) {
                float posX = buffers.mSourcePositions[j];
                float posY = buffers.mSourcePositions[j + 1];
                if (Float.isFinite(posX) && Float.isFinite(posY)) {
                    int glyphID = buffers.mSourceGlyphs[i];
                    Glyph glyph = strike.digestFor(2, glyphID);
                    switch (glyph.actionFor(2)) {
                        case 1: {
                            creationMatrix.mapPoints(buffers.mSourcePositions, j, mappedPos, 0, 1);
                            glyph.getBounds(bounds);
                            bounds.offset(mappedPos[0], mappedPos[1]);
                            runBounds.joinNoCheck(bounds);
                            buffers.mAcceptedGlyphs[acceptedSize] = glyphID;
                            buffers.mAcceptedPositions[acceptedSize << 1] = bounds.x();
                            buffers.mAcceptedPositions[acceptedSize << 1 | 1] = bounds.y();
                            buffers.mAcceptedFormats[acceptedSize] = glyph.getMaskFormat();
                            ++acceptedSize;
                            break;
                        }
                        case 2: {
                            buffers.mRejectedGlyphs[rejectedSize] = glyphID;
                            buffers.mRejectedPositions[rejectedSize << 1] = posX;
                            buffers.mRejectedPositions[rejectedSize << 1 | 1] = posY;
                            ++rejectedSize;
                            break;
                        }
                    }
                }
                ++i;
                j += 2;
            }
        }
        finally {
            strike.unlock();
        }
        buffers.mAcceptedGlyphCount = acceptedSize;
        buffers.mRejectedGlyphCount = rejectedSize;
        return runBounds;
    }

    static void add_multi_mask_format(SubRunContainer container, StrikeDesc strikeDesc, Matrixc creationMatrix, Rect2fc creationBounds, AtlasSubRunFactory factory, Buffers buffers) {
        assert (buffers.mAcceptedGlyphCount > 0);
        byte[] masks = buffers.mAcceptedFormats;
        int prevFormat = BakedGlyph.chooseMaskFormat(masks[0]);
        int prevIndex = 0;
        for (int index = 1; index < buffers.mAcceptedGlyphCount; ++index) {
            int format = BakedGlyph.chooseMaskFormat(masks[index]);
            if (prevFormat == format) continue;
            container.append(factory.create(strikeDesc, creationMatrix, creationBounds, prevFormat, buffers.mAcceptedGlyphs, prevIndex, buffers.mAcceptedPositions, prevIndex * 2, index - prevIndex));
            prevFormat = format;
            prevIndex = index;
        }
        container.append(factory.create(strikeDesc, creationMatrix, creationBounds, prevFormat, buffers.mAcceptedGlyphs, prevIndex, buffers.mAcceptedPositions, prevIndex * 2, buffers.mAcceptedGlyphCount - prevIndex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static float find_max_glyph_dimension(Strike strike, int[] glyphs, int glyphOffset, int glyphCount) {
        strike.lock();
        try {
            float maxDimension = 0.0f;
            int e = glyphOffset + glyphCount;
            for (int i = glyphOffset; i < e; ++i) {
                Glyph glyph = strike.digestFor(2, glyphs[i]);
                maxDimension = Math.max(maxDimension, (float)glyph.getMaxDimension());
            }
            float f2 = maxDimension;
            return f2;
        }
        finally {
            strike.unlock();
        }
    }

    @Nonnull
    public static SubRunContainer make(@Nonnull GlyphRunList glyphRunList, @Nonnull Matrixc positionMatrix, @Nonnull Paint runPaint, @Nonnull StrikeCache strikeCache) {
        SubRunContainer container = new SubRunContainer(positionMatrix);
        int maxMaskSize = 256;
        Buffers buffers = new Buffers(glyphRunList.maxGlyphRunSize());
        float glyphRunListX = glyphRunList.getSourceBounds().centerX();
        float glyphRunListY = glyphRunList.getSourceBounds().centerY();
        StrikeDesc strikeDesc = new StrikeDesc();
        for (int i = 0; i < glyphRunList.mGlyphRunCount; ++i) {
            Matrix creationMatrix;
            GlyphRun glyphRun = glyphRunList.mGlyphRuns[i];
            Font runFont = glyphRun.font();
            float approximateDeviceFontSize = runFont.approximateTransformedFontSize(positionMatrix, glyphRunListX, glyphRunListY);
            if (approximateDeviceFontSize <= 0.0f || !Float.isFinite(approximateDeviceFontSize)) continue;
            buffers.setSource(glyphRun);
            if ((runPaint.getStyle() != 1 || runPaint.getStrokeWidth() != 0.0f) && approximateDeviceFontSize < (float)maxMaskSize && buffers.mSourceGlyphCount > 0 && !positionMatrix.hasPerspective()) {
                creationMatrix = new Matrix(positionMatrix);
                creationMatrix.setTranslateX(0.0f);
                creationMatrix.setTranslateY(0.0f);
                strikeDesc.updateForMask(runFont, runPaint, creationMatrix);
                Strike strike = strikeDesc.findOrCreateStrike(strikeCache);
                Rect2f creationBounds = SubRunContainer.prepare_for_direct_mask_drawing(strike, creationMatrix, buffers);
                buffers.setSourceToRejected();
                if (buffers.mAcceptedGlyphCount > 0) {
                    SubRunContainer.add_multi_mask_format(container, strikeDesc, creationMatrix, creationBounds, DirectMaskSubRun::new, buffers);
                }
            }
            if (buffers.mSourceGlyphCount <= 0 || !(approximateDeviceFontSize > 2.4414062E-4f)) continue;
            creationMatrix = new Matrix(positionMatrix);
            if (creationMatrix.hasPerspective()) {
                float maxAreaScale = creationMatrix.differentialAreaScale(glyphRunListX, glyphRunListY);
                float perspectiveFactor = 1.0f;
                if (Float.isFinite(maxAreaScale) && maxAreaScale > 2.4414062E-4f) {
                    perspectiveFactor = (float)Math.sqrt(maxAreaScale);
                }
                creationMatrix.setScale(perspectiveFactor, perspectiveFactor);
            }
            int maxIter = 2;
            while (maxIter-- != 0) {
                strikeDesc.updateForMask(runFont, runPaint, creationMatrix);
                Strike gaugingStrike = strikeDesc.findOrCreateStrike(strikeCache);
                float maxDimension = SubRunContainer.find_max_glyph_dimension(gaugingStrike, buffers.mSourceGlyphs, buffers.mSourceGlyphOffset, buffers.mSourceGlyphCount);
                if (maxDimension <= 254.0f) break;
                float reductionFactor = 254.0f / maxDimension;
                creationMatrix.postScale(reductionFactor, reductionFactor);
            }
            strikeDesc.updateForMask(runFont, runPaint, creationMatrix);
            Strike strike = strikeDesc.findOrCreateStrike(strikeCache);
            Rect2f creationBounds = SubRunContainer.prepare_for_transformed_mask_drawing(strike, creationMatrix, buffers);
            buffers.setSourceToRejected();
            if (buffers.mAcceptedGlyphCount <= 0) continue;
            SubRunContainer.add_multi_mask_format(container, strikeDesc, creationMatrix, creationBounds, TransformedMaskSubRun::new, buffers);
        }
        return container;
    }

    public SubRunContainer(Matrixc initialPositionMatrix) {
        this.mInitialPositionMatrix = new Matrix(initialPositionMatrix);
    }

    public void draw(Canvas canvas, float originX, float originY, Paint paint, GraniteDevice device) {
        SubRun subRun = this.mHead;
        while (subRun != null) {
            subRun.draw(canvas, originX, originY, paint, device);
            subRun = subRun.mNext;
        }
    }

    public Matrixc initialPosition() {
        return this.mInitialPositionMatrix;
    }

    public boolean isEmpty() {
        return this.mHead == null;
    }

    public long getMemorySize() {
        long size = 96L;
        SubRun subRun = this.mHead;
        while (subRun != null) {
            size += subRun.getMemorySize();
            subRun = subRun.mNext;
        }
        return size;
    }

    void append(SubRun entry) {
        SubRun tail = this.mTail;
        this.mTail = entry;
        if (tail == null) {
            this.mHead = entry;
        } else {
            tail.mNext = entry;
        }
    }

    static class Buffers {
        int[] mSourceGlyphs;
        int mSourceGlyphOffset;
        float[] mSourcePositions;
        int mSourcePositionOffset;
        int mSourceGlyphCount;
        final int[] mAcceptedGlyphs;
        final float[] mAcceptedPositions;
        final byte[] mAcceptedFormats;
        int mAcceptedGlyphCount;
        final int[] mRejectedGlyphs;
        final float[] mRejectedPositions;
        int mRejectedGlyphCount;

        Buffers(int maxGlyphRunSize) {
            this.mAcceptedGlyphs = new int[maxGlyphRunSize];
            this.mAcceptedPositions = new float[maxGlyphRunSize * 2];
            this.mAcceptedFormats = new byte[maxGlyphRunSize];
            this.mRejectedGlyphs = new int[maxGlyphRunSize];
            this.mRejectedPositions = new float[maxGlyphRunSize * 2];
        }

        void setSource(@Nonnull GlyphRun glyphRun) {
            this.mSourceGlyphs = glyphRun.mGlyphs;
            this.mSourceGlyphOffset = glyphRun.mGlyphOffset;
            this.mSourcePositions = glyphRun.mPositions;
            this.mSourcePositionOffset = glyphRun.mPositionOffset;
            this.mSourceGlyphCount = glyphRun.mGlyphCount;
        }

        void setSourceToRejected() {
            this.mSourceGlyphs = this.mRejectedGlyphs;
            this.mSourceGlyphOffset = 0;
            this.mSourcePositions = this.mRejectedPositions;
            this.mSourcePositionOffset = 0;
            this.mSourceGlyphCount = this.mRejectedGlyphCount;
        }
    }

    static interface AtlasSubRunFactory {
        public AtlasSubRun create(StrikeDesc var1, Matrixc var2, Rect2fc var3, int var4, int[] var5, int var6, float[] var7, int var8, int var9);
    }

    public static abstract class AtlasSubRun
    extends SubRun {
        final GlyphVector mGlyphs;
        final int mMaskFormat;
        final boolean mCanDrawDirect;
        final Matrix mCreationMatrix;
        final Rect2f mCreationBounds;
        final float[] mPositions;

        AtlasSubRun(StrikeDesc strikeDesc, Matrixc creationMatrix, Rect2fc creationBounds, int maskFormat, int[] acceptedGlyphs, int acceptedGlyphOffset, float[] acceptedPositions, int acceptedPositionOffset, int acceptedGlyphCount, boolean canDrawDirect) {
            assert (!creationMatrix.hasPerspective());
            this.mGlyphs = new GlyphVector(strikeDesc.copy(), Arrays.copyOfRange(acceptedGlyphs, acceptedGlyphOffset, acceptedGlyphOffset + acceptedGlyphCount));
            this.mMaskFormat = maskFormat;
            this.mCanDrawDirect = canDrawDirect;
            this.mCreationMatrix = new Matrix(creationMatrix);
            this.mCreationBounds = new Rect2f(creationBounds);
            this.mPositions = Arrays.copyOfRange(acceptedPositions, acceptedPositionOffset, acceptedPositionOffset + acceptedGlyphCount * 2);
        }

        @Override
        public void draw(Canvas canvas, float originX, float originY, Paint paint, GraniteDevice device) {
            device.drawAtlasSubRun(this, originX, originY, paint);
        }

        public int getGlyphCount() {
            return this.mGlyphs.getGlyphCount();
        }

        public int getMaskFormat() {
            return this.mMaskFormat;
        }

        public int prepareGlyphs(int start, int end, RecordingContext context) {
            return this.mGlyphs.prepareGlyphs(start, end, this.mMaskFormat, context);
        }

        public void fillInstanceData(MeshDrawWriter writer, int offset, int count, float depth) {
            writer.beginInstances(null, null, 4);
            long instanceData = writer.append(count);
            BakedGlyph[] glyphs = this.mGlyphs.getGlyphs();
            float[] positions = this.mPositions;
            int i = offset;
            int j = offset << 1;
            int e = offset + count;
            while (i < e) {
                BakedGlyph glyph = glyphs[i];
                MemoryUtil.memPutFloat((long)instanceData, (float)positions[j]);
                MemoryUtil.memPutFloat((long)(instanceData + 4L), (float)positions[j | 1]);
                MemoryUtil.memPutShort((long)(instanceData + 8L), (short)glyph.u1);
                MemoryUtil.memPutShort((long)(instanceData + 10L), (short)glyph.v1);
                MemoryUtil.memPutShort((long)(instanceData + 12L), (short)glyph.width());
                MemoryUtil.memPutShort((long)(instanceData + 14L), (short)glyph.height());
                MemoryUtil.memPutFloat((long)(instanceData + 16L), (float)depth);
                instanceData += 20L;
                ++i;
                j += 2;
            }
            writer.endAppender();
        }

        public void fillInstanceData(MeshDrawWriter writer, int offset, int count, float offsetX, float offsetY, float depth) {
            writer.beginInstances(null, null, 4);
            long instanceData = writer.append(count);
            BakedGlyph[] glyphs = this.mGlyphs.getGlyphs();
            float[] positions = this.mPositions;
            int i = offset;
            int j = offset << 1;
            int e = offset + count;
            while (i < e) {
                BakedGlyph glyph = glyphs[i];
                MemoryUtil.memPutFloat((long)instanceData, (float)(positions[j] + offsetX));
                MemoryUtil.memPutFloat((long)(instanceData + 4L), (float)(positions[j | 1] + offsetY));
                MemoryUtil.memPutShort((long)(instanceData + 8L), (short)glyph.u1);
                MemoryUtil.memPutShort((long)(instanceData + 10L), (short)glyph.v1);
                MemoryUtil.memPutShort((long)(instanceData + 12L), (short)glyph.width());
                MemoryUtil.memPutShort((long)(instanceData + 14L), (short)glyph.height());
                MemoryUtil.memPutFloat((long)(instanceData + 16L), (float)depth);
                instanceData += 20L;
                ++i;
                j += 2;
            }
            writer.endAppender();
        }

        public Rect2fc getBounds() {
            return this.mCreationBounds;
        }

        public int getMatrixAndFilter(Matrixc localToDevice, float originX, float originY, Matrix outSubRunToLocal, Matrix outSubRunToDevice) {
            boolean compatible;
            if (this.mCreationMatrix.invert(outSubRunToLocal)) {
                outSubRunToLocal.postTranslate(originX, originY);
                assert (!outSubRunToLocal.hasPerspective());
            } else {
                outSubRunToLocal.setIdentity();
            }
            boolean bl = compatible = !localToDevice.hasPerspective() && localToDevice.m11() == this.mCreationMatrix.m11() && localToDevice.m12() == this.mCreationMatrix.m12() && localToDevice.m21() == this.mCreationMatrix.m21() && localToDevice.m22() == this.mCreationMatrix.m22();
            if (compatible) {
                float mappedOriginX = localToDevice.m11() * originX + localToDevice.m21() * originY + localToDevice.m41();
                float mappedOriginY = localToDevice.m12() * originX + localToDevice.m22() * originY + localToDevice.m42();
                float offsetX = mappedOriginX - this.mCreationMatrix.getTranslateX();
                float offsetY = mappedOriginY - this.mCreationMatrix.getTranslateY();
                outSubRunToDevice.setTranslate(offsetX, offsetY);
                if (this.mCanDrawDirect && offsetX == (float)Math.floor(offsetX) && offsetY == (float)Math.floor(offsetY)) {
                    return 0;
                }
            } else {
                outSubRunToDevice.set(localToDevice);
                outSubRunToDevice.preConcat(outSubRunToLocal);
            }
            return 1;
        }

        @Override
        public long getMemorySize() {
            long size = 32L;
            size += 8L + this.mGlyphs.getMemorySize();
            size += 64L;
            size += 40L;
            return size += 16L + (long)this.mPositions.length * 4L + 8L;
        }
    }

    public static abstract class SubRun {
        SubRun mNext;

        public abstract void draw(Canvas var1, float var2, float var3, Paint var4, GraniteDevice var5);

        public abstract long getMemorySize();
    }

    public static final class TransformedMaskSubRun
    extends AtlasSubRun {
        public TransformedMaskSubRun(StrikeDesc strikeDesc, Matrixc creationMatrix, Rect2fc creationBounds, int maskFormat, int[] acceptedGlyphs, int acceptedGlyphOffset, float[] acceptedPositions, int acceptedPositionOffset, int acceptedGlyphCount) {
            super(strikeDesc, creationMatrix, creationBounds, maskFormat, acceptedGlyphs, acceptedGlyphOffset, acceptedPositions, acceptedPositionOffset, acceptedGlyphCount, false);
        }
    }

    public static final class DirectMaskSubRun
    extends AtlasSubRun {
        public DirectMaskSubRun(StrikeDesc strikeDesc, Matrixc creationMatrix, Rect2fc creationBounds, int maskFormat, int[] acceptedGlyphs, int acceptedGlyphOffset, float[] acceptedPositions, int acceptedPositionOffset, int acceptedGlyphCount) {
            super(strikeDesc, creationMatrix, creationBounds, maskFormat, acceptedGlyphs, acceptedGlyphOffset, acceptedPositions, acceptedPositionOffset, acceptedGlyphCount, true);
        }
    }
}

