/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import yslelf.cloudpick.render.core.ColorSpace;
import yslelf.cloudpick.render.core.ImageInfo;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.engine.Caps;
import yslelf.cloudpick.render.engine.ImageProxyView;
import yslelf.cloudpick.render.engine.RecordingContext;
import yslelf.cloudpick.render.engine.RenderTaskManager;

public class SurfaceContext
implements AutoCloseable {
    protected final RecordingContext mContext;
    protected final ImageProxyView mReadView;
    private final ImageInfo mImageInfo;

    public SurfaceContext(@RawPtr RecordingContext context, @RawPtr ImageProxyView readView, int colorType, int alphaType, ColorSpace colorSpace) {
        assert (!context.isDiscarded());
        this.mContext = context;
        this.mReadView = readView;
        this.mImageInfo = new ImageInfo(this.getWidth(), this.getHeight(), colorType, alphaType, colorSpace);
    }

    @RawPtr
    public final RecordingContext getContext() {
        return this.mContext;
    }

    @RawPtr
    public final ImageProxyView getReadView() {
        return this.mReadView;
    }

    public final ImageInfo getImageInfo() {
        return this.mImageInfo;
    }

    public final int getColorType() {
        return this.mImageInfo.colorType();
    }

    public final int getAlphaType() {
        return this.mImageInfo.alphaType();
    }

    public final int getWidth() {
        return this.mReadView.getWidth();
    }

    public final int getHeight() {
        return this.mReadView.getHeight();
    }

    public final boolean isMipmapped() {
        return this.mReadView.isMipmapped();
    }

    public final int getOrigin() {
        return this.mReadView.getOrigin();
    }

    public final short getReadSwizzle() {
        return this.mReadView.getSwizzle();
    }

    public final Caps getCaps() {
        return this.mContext.getCaps();
    }

    protected final RenderTaskManager getDrawingManager() {
        return this.mContext.getRenderTaskManager();
    }

    @Override
    public void close() {
        this.mReadView.close();
    }
}

