/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.core.GlyphRunList;
import yslelf.cloudpick.render.core.Matrixc;
import yslelf.cloudpick.render.core.Paint;
import yslelf.cloudpick.render.core.StrikeDesc;
import yslelf.cloudpick.render.core.TextBlob;
import yslelf.cloudpick.render.granite.BakedTextBlob;

public final class TextBlobCache {
    private final Object mLock = new Object();
    private final HashMap<Object, Bucket> mMap = new HashMap();
    private final ReferenceQueue<TextBlob> mQueue = new ReferenceQueue();
    private BakedTextBlob mHead;
    private BakedTextBlob mTail;
    private long mSizeBudget = 0x400000L;
    private long mCurrentSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BakedTextBlob find(@Nonnull TextBlob blob, @Nonnull FeatureKey key) {
        Object object = this.mLock;
        synchronized (object) {
            Bucket bucket = this.mMap.get(blob);
            if (bucket == null) {
                return null;
            }
            BakedTextBlob entry = bucket.find(key);
            if (entry != null) {
                this.moveToHead(entry);
            }
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public BakedTextBlob insert(@Nonnull TextBlob blob, @Nonnull FeatureKey key, @Nonnull BakedTextBlob entry) {
        Object object = this.mLock;
        synchronized (object) {
            return this.internalInsert(blob, key, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@Nonnull BakedTextBlob entry) {
        Object object = this.mLock;
        synchronized (object) {
            this.internalRemove(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeStaleEntries() {
        Object object = this.mLock;
        synchronized (object) {
            this.internalPurgeStaleEntries();
        }
    }

    @Nonnull
    private BakedTextBlob internalInsert(@Nonnull TextBlob blob, @Nonnull FeatureKey key, @Nonnull BakedTextBlob entry) {
        BakedTextBlob existing;
        Bucket bucket = this.mMap.get(blob);
        if (bucket == null) {
            PrimaryKey primaryKey = new PrimaryKey(blob, this.mQueue);
            bucket = new Bucket(primaryKey);
            this.mMap.put(primaryKey, bucket);
            assert (this.mMap.get(blob) == bucket);
        }
        if ((existing = bucket.find(key)) != null) {
            entry = existing;
        } else {
            FeatureKey copiedKey = new FeatureKey(key);
            entry.mPrimaryKey = bucket.mPrimaryKey;
            entry.mFeatureKey = copiedKey;
            this.addToHead(entry);
            this.mCurrentSize += entry.getMemorySize();
            bucket.insertEntry(entry);
        }
        this.internalCheckPurge(entry);
        return entry;
    }

    private void internalRemove(@Nonnull BakedTextBlob entry) {
        BakedTextBlob old;
        Bucket bucket = this.mMap.get(entry.mPrimaryKey);
        if (bucket != null && entry == (old = bucket.find(entry.mFeatureKey))) {
            this.mCurrentSize -= entry.getMemorySize();
            this.unlink(entry);
            bucket.removeEntry(entry);
            if (bucket.isEmpty()) {
                this.mMap.remove(entry.mPrimaryKey);
            }
        }
    }

    private void internalCheckPurge(BakedTextBlob mru) {
        this.internalPurgeStaleEntries();
        if (this.mCurrentSize > this.mSizeBudget) {
            BakedTextBlob lru = this.mTail;
            while (lru != null && lru != mru && this.mCurrentSize > this.mSizeBudget) {
                this.internalRemove(lru);
                lru = lru.mPrev;
            }
        }
    }

    private void internalPurgeStaleEntries() {
        Reference<TextBlob> r;
        while ((r = this.mQueue.poll()) != null) {
            Bucket bucket = this.mMap.remove(r);
            if (bucket == null) continue;
            for (BakedTextBlob e : bucket.entries()) {
                this.mCurrentSize -= e.getMemorySize();
                this.unlink(e);
            }
        }
    }

    private void unlink(@Nonnull BakedTextBlob entry) {
        BakedTextBlob prev = entry.mPrev;
        BakedTextBlob next = entry.mNext;
        if (prev != null) {
            prev.mNext = next;
        } else {
            this.mHead = next;
        }
        if (next != null) {
            next.mPrev = prev;
        } else {
            this.mTail = prev;
        }
        entry.mPrev = null;
        entry.mNext = null;
    }

    private void addToHead(@Nonnull BakedTextBlob entry) {
        entry.mPrev = null;
        entry.mNext = this.mHead;
        if (this.mHead != null) {
            this.mHead.mPrev = entry;
        }
        this.mHead = entry;
        if (this.mTail == null) {
            this.mTail = entry;
        }
    }

    private void moveToHead(@Nonnull BakedTextBlob entry) {
        assert (this.mHead != null && this.mTail != null);
        if (this.mHead == entry) {
            return;
        }
        BakedTextBlob prev = entry.mPrev;
        BakedTextBlob next = entry.mNext;
        if (prev != null) {
            prev.mNext = next;
        } else {
            this.mHead = next;
        }
        if (next != null) {
            next.mPrev = prev;
        } else {
            this.mTail = prev;
        }
        entry.mPrev = null;
        entry.mNext = this.mHead;
        if (this.mHead != null) {
            this.mHead.mPrev = entry;
        }
        this.mHead = entry;
        if (this.mTail == null) {
            this.mTail = entry;
        }
    }

    private static class Bucket {
        final PrimaryKey mPrimaryKey;
        private ObjectArrayList<BakedTextBlob> mList = new ObjectArrayList(8);
        private HashMap<FeatureKey, BakedTextBlob> mMap;

        Bucket(PrimaryKey primaryKey) {
            this.mPrimaryKey = primaryKey;
        }

        @Nullable
        BakedTextBlob find(@Nonnull FeatureKey key) {
            if (this.mMap != null) {
                return this.mMap.get(key);
            }
            for (BakedTextBlob e : this.mList) {
                if (!key.equals(e.mFeatureKey)) continue;
                return e;
            }
            return null;
        }

        void insertEntry(@Nonnull BakedTextBlob entry) {
            if (this.mMap != null) {
                this.mMap.put(entry.mFeatureKey, entry);
            } else if (this.mList.size() >= 8) {
                this.mMap = new HashMap();
                for (BakedTextBlob e : this.mList) {
                    this.mMap.put(e.mFeatureKey, e);
                }
                this.mList = null;
                this.mMap.put(entry.mFeatureKey, entry);
            } else {
                this.mList.add((Object)entry);
            }
        }

        void removeEntry(@Nonnull BakedTextBlob entry) {
            if (this.mMap != null) {
                BakedTextBlob old = this.mMap.remove(entry.mFeatureKey);
                assert (old == entry);
            } else {
                for (int i = 0; i < this.mList.size(); ++i) {
                    if (!entry.mFeatureKey.equals(((BakedTextBlob)this.mList.get((int)i)).mFeatureKey)) continue;
                    this.mList.remove(i);
                    return;
                }
            }
        }

        boolean isEmpty() {
            if (this.mMap != null) {
                return this.mMap.isEmpty();
            }
            return this.mList.isEmpty();
        }

        Collection<BakedTextBlob> entries() {
            if (this.mMap != null) {
                return this.mMap.values();
            }
            return this.mList;
        }
    }

    public static final class FeatureKey {
        private float mScaleX;
        private float mScaleY;
        private float mShearX;
        private float mShearY;
        private float mFrameWidth;
        private float mMiterLimit;
        private boolean mHasDirectSubRuns;
        private byte mStyle;
        private byte mStrokeJoin;

        public FeatureKey() {
        }

        public FeatureKey(FeatureKey other) {
            this.mScaleX = other.mScaleX;
            this.mScaleY = other.mScaleY;
            this.mShearX = other.mShearX;
            this.mShearY = other.mShearY;
            this.mFrameWidth = other.mFrameWidth;
            this.mMiterLimit = other.mMiterLimit;
            this.mHasDirectSubRuns = other.mHasDirectSubRuns;
            this.mStyle = other.mStyle;
            this.mStrokeJoin = other.mStrokeJoin;
        }

        public void update(GlyphRunList glyphRunList, Paint paint, Matrixc positionMatrix) {
            this.mStyle = (byte)paint.getStyle();
            if (this.mStyle != 0) {
                this.mFrameWidth = paint.getStrokeWidth();
                this.mStrokeJoin = (byte)paint.getStrokeJoin();
                this.mMiterLimit = this.mStrokeJoin == 0 ? paint.getStrokeMiter() : 0.0f;
            } else {
                this.mFrameWidth = -1.0f;
                this.mStrokeJoin = 0;
                this.mMiterLimit = 0.0f;
            }
            boolean bl = this.mHasDirectSubRuns = !positionMatrix.hasPerspective();
            if (this.mHasDirectSubRuns) {
                int typeMask = positionMatrix.getType();
                if ((typeMask & 2) != 0) {
                    this.mScaleX = StrikeDesc.round_mat_elem(positionMatrix.getScaleX());
                    this.mScaleY = StrikeDesc.round_mat_elem(positionMatrix.getScaleY());
                } else {
                    this.mScaleY = 1.0f;
                    this.mScaleX = 1.0f;
                }
                if ((typeMask & 4) != 0) {
                    this.mShearX = StrikeDesc.round_mat_elem(positionMatrix.getShearX());
                    this.mShearY = StrikeDesc.round_mat_elem(positionMatrix.getShearY());
                } else {
                    this.mShearY = 0.0f;
                    this.mShearX = 0.0f;
                }
            } else {
                this.mScaleX = 1.0f;
                this.mScaleY = 1.0f;
                this.mShearX = 0.0f;
                this.mShearY = 0.0f;
            }
        }

        public int hashCode() {
            int h2 = Float.floatToIntBits(this.mScaleX);
            h2 = 31 * h2 + Float.floatToIntBits(this.mScaleY);
            h2 = 31 * h2 + Float.floatToIntBits(this.mShearX);
            h2 = 31 * h2 + Float.floatToIntBits(this.mShearY);
            h2 = 31 * h2 + Float.floatToIntBits(this.mFrameWidth);
            h2 = 31 * h2 + Float.floatToIntBits(this.mMiterLimit);
            h2 = 31 * h2 + (this.mHasDirectSubRuns ? 1 : 0);
            h2 = 31 * h2 + this.mStyle;
            h2 = 31 * h2 + this.mStrokeJoin;
            return h2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof FeatureKey) {
                FeatureKey that = (FeatureKey)o;
                return this.mHasDirectSubRuns == that.mHasDirectSubRuns && this.mScaleX == that.mScaleX && this.mScaleY == that.mScaleY && this.mShearX == that.mShearX && this.mShearY == that.mShearY && this.mFrameWidth == that.mFrameWidth && this.mMiterLimit == that.mMiterLimit && this.mStyle == that.mStyle && this.mStrokeJoin == that.mStrokeJoin;
            }
            return false;
        }
    }

    static final class PrimaryKey
    extends WeakReference<TextBlob> {
        private final int hash;

        PrimaryKey(TextBlob referent, ReferenceQueue<TextBlob> q) {
            super(referent, q);
            this.hash = referent.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Reference) {
                Reference r = (Reference)o;
                return this.get() == r.get();
            }
            return false;
        }
    }
}

