/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.function.Function;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.ImageViewProxy;
import yslelf.cloudpick.render.engine.SamplerDesc;

public class TextureDataGatherer
implements AutoCloseable {
    private final IdentityHashMap<ImageViewProxy, Integer> mTextureToIndex = new IdentityHashMap();
    private ObjectArrayList<@SharedPtr ImageViewProxy> mIndexToTexture = new ObjectArrayList();
    private final Function<ImageViewProxy, Integer> mTextureAccumulator = texture -> {
        int index = this.mIndexToTexture.size();
        this.mIndexToTexture.add((Object)RefCnt.create(texture));
        return index;
    };
    private final HashMap<SamplerDesc, Integer> mSamplerToIndex = new HashMap();
    private ObjectArrayList<SamplerDesc> mIndexToSampler = new ObjectArrayList();
    private final Function<SamplerDesc, Integer> mSamplerAccumulator = sampler -> {
        int index = this.mIndexToSampler.size();
        this.mIndexToSampler.add(sampler);
        return index;
    };
    final IntArrayList mTextureData = new IntArrayList();

    public void add(@SharedPtr ImageViewProxy textureView, SamplerDesc samplerDesc) {
        assert (samplerDesc != null);
        int textureIndex = this.mTextureToIndex.computeIfAbsent(textureView, this.mTextureAccumulator);
        RefCnt.move(textureView);
        int samplerIndex = this.mSamplerToIndex.computeIfAbsent(samplerDesc, this.mSamplerAccumulator);
        this.mTextureData.add(textureIndex);
        this.mTextureData.add(samplerIndex);
    }

    public void reset() {
        this.mTextureData.clear();
    }

    public int[] finish() {
        return this.mTextureData.toIntArray();
    }

    ObjectArrayList<@SharedPtr ImageViewProxy> detachTextures() {
        ObjectArrayList<ImageViewProxy> res = this.mIndexToTexture;
        this.mIndexToTexture = null;
        return res;
    }

    ObjectArrayList<SamplerDesc> detachSamplers() {
        ObjectArrayList<SamplerDesc> res = this.mIndexToSampler;
        this.mIndexToSampler = null;
        return res;
    }

    @Override
    public void close() {
        if (this.mIndexToTexture != null) {
            this.mIndexToTexture.forEach(RefCnt::unref);
        }
        this.mIndexToTexture = null;
    }
}

