/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.core.ColorInfo;
import yslelf.cloudpick.render.core.ImageInfo;
import yslelf.cloudpick.render.core.Pixmap;
import yslelf.cloudpick.render.core.Rect2i;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.Caps;
import yslelf.cloudpick.render.engine.ImageDesc;
import yslelf.cloudpick.render.engine.ImageViewProxy;
import yslelf.cloudpick.render.engine.RecordingContext;
import yslelf.cloudpick.render.engine.Swizzle;
import yslelf.cloudpick.render.engine.task.ImageUploadTask;
import yslelf.cloudpick.render.granite.GraniteImage;

public class TextureUtils {
    @Nullable
    public static ObjectIntPair<@SharedPtr ImageViewProxy> makePixmapViewProxy(RecordingContext context, Pixmap pixmap, boolean mipmapped, boolean budgeted, String label) {
        ImageViewProxy view;
        ImageDesc desc;
        int srcCT;
        if (!pixmap.getInfo().isValid()) {
            return null;
        }
        Caps caps = context.getCaps();
        int dstCT = srcCT = pixmap.getColorType();
        if (pixmap.getWidth() <= 1 && pixmap.getHeight() <= 1) {
            mipmapped = false;
        }
        if ((desc = caps.getDefaultColorImageDesc(1, dstCT, pixmap.getWidth(), pixmap.getHeight(), 1, 8 | (mipmapped ? 4 : 0))) == null) {
            return null;
        }
        assert (desc != null);
        short readSwizzle = caps.getReadSwizzle(desc, dstCT);
        if (ColorInfo.colorTypeIsAlphaOnly(dstCT)) {
            readSwizzle = Swizzle.concat(readSwizzle, (short)13107);
        }
        if ((view = ImageViewProxy.make(context, desc, 0, readSwizzle, budgeted, label)) == null) {
            return null;
        }
        ImageInfo imageInfo = pixmap.getInfo();
        ImageUploadTask task = ImageUploadTask.make(context, view, srcCT, imageInfo.alphaType(), imageInfo.colorSpace(), dstCT, imageInfo.alphaType(), imageInfo.colorSpace(), new ImageUploadTask.MipLevel[]{new ImageUploadTask.MipLevel(pixmap)}, new Rect2i(0, 0, pixmap.getWidth(), pixmap.getHeight()), ImageUploadTask.uploadOnce());
        if (task == null) {
            context.getLogger().error("ImageUtils.makePixmapViewProxy: Could not create ImageUploadTask");
            return null;
        }
        context.addTask(task);
        view.ref();
        return ObjectIntPair.of((Object)view, (int)dstCT);
    }

    @Nullable
    @SharedPtr
    public static GraniteImage makeFromPixmap(RecordingContext context, Pixmap pixmap, boolean mipmapped, boolean budgeted, String label) {
        ObjectIntPair<ImageViewProxy> result = TextureUtils.makePixmapViewProxy(context, pixmap, mipmapped, budgeted, label);
        if (result == null) {
            return null;
        }
        return new GraniteImage(context, (ImageViewProxy)result.first(), result.rightInt(), pixmap.getAlphaType(), pixmap.getColorSpace());
    }
}

