/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import java.nio.IntBuffer;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import yslelf.cloudpick.render.core.MathUtil;

public class UniformDataCache
implements AutoCloseable {
    private final HashMap<IntBuffer, IntBuffer> mPointers = new HashMap();
    Block mTail;

    @Nullable
    public IntBuffer insert(@Nullable IntBuffer block) {
        if (block == null || !block.hasRemaining()) {
            return null;
        }
        IntBuffer existing = this.mPointers.get(block);
        if (existing != null) {
            return existing;
        }
        IntBuffer copy = this.allocate(block);
        this.mPointers.put(copy, copy);
        return copy;
    }

    public int size() {
        return this.mPointers.size();
    }

    @Override
    public void close() {
        this.freeBlocks();
        this.mPointers.clear();
    }

    IntBuffer allocate(@Nonnull IntBuffer block) {
        int offset;
        int end;
        int size = block.remaining() << 2;
        if (this.mTail == null) {
            int initialCapacity = MathUtil.alignTo(Math.max(size, 1024), 256);
            this.mTail = new Block(null, initialCapacity);
        }
        if ((end = (offset = MathUtil.align8(this.mTail.mPosition)) + size) > this.mTail.mCapacity) {
            int newCapacity = MathUtil.alignTo(Math.max(size, this.mTail.mCapacity + (this.mTail.mCapacity >> 1)), 256);
            Block prev = this.mTail;
            this.mTail = new Block(prev, newCapacity);
            offset = 0;
            end = size;
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((IntBuffer)block), (long)(this.mTail.mStorage + (long)offset), (long)size);
        this.mTail.mPosition = end;
        return MemoryUtil.memIntBuffer((long)this.mTail.mStorage, (int)(this.mTail.mCapacity >> 2)).position(offset >> 2).limit(end >> 2);
    }

    void freeBlocks() {
        Block block = this.mTail;
        while (block != null) {
            block.free();
            block = block.mPrev;
        }
        this.mTail = null;
    }

    static class Block {
        final long mStorage;
        final int mCapacity;
        int mPosition = 0;
        final Block mPrev;

        Block(Block prev, int capacity) {
            this.mPrev = prev;
            this.mStorage = MemoryUtil.nmemAlloc((long)capacity);
            if (this.mStorage == 0L) {
                throw new OutOfMemoryError();
            }
            assert (MathUtil.isAlign8(this.mStorage));
            this.mCapacity = capacity;
        }

        void free() {
            MemoryUtil.nmemFree((long)this.mStorage);
        }
    }
}

