/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import java.nio.IntBuffer;
import org.lwjgl.system.MemoryUtil;
import yslelf.cloudpick.render.core.MathUtil;
import yslelf.cloudpick.render.core.Matrix3;
import yslelf.cloudpick.render.core.Matrix4c;
import yslelf.cloudpick.render.core.Matrixc;

public class UniformDataGatherer
implements AutoCloseable {
    public static final int Std140Layout = 0;
    public static final int Std430Layout = 1;
    private int mLayout;
    private int mRequiredAlignment = 0;
    private long mStorage;
    private int mCapacity;
    private int mPosition = 0;
    private boolean mWrotePaintColor = false;
    private IntBuffer mCachedView = null;

    public UniformDataGatherer(int layout) {
        this.mLayout = layout;
        this.mStorage = MemoryUtil.nmemAlloc((long)256L);
        if (this.mStorage == 0L) {
            throw new OutOfMemoryError();
        }
        this.mCapacity = 256;
    }

    @Override
    public void close() {
        if (this.mStorage != 0L) {
            MemoryUtil.nmemFree((long)this.mStorage);
        }
        this.mStorage = 0L;
    }

    public void reset() {
        this.reset(this.mLayout);
    }

    public void reset(int layout) {
        this.mLayout = layout;
        this.mRequiredAlignment = 0;
        this.mPosition = 0;
        this.mWrotePaintColor = false;
    }

    public IntBuffer finish() {
        if (this.mPosition == 0) {
            return null;
        }
        this.append(this.mRequiredAlignment, 0);
        if (this.mCachedView == null) {
            this.mCachedView = MemoryUtil.memIntBuffer((long)this.mStorage, (int)(this.mCapacity >> 2));
        }
        return this.mCachedView.limit(this.mPosition >> 2).rewind();
    }

    public void write1i(int v0) {
        long dst = this.append(4, 4);
        MemoryUtil.memPutInt((long)dst, (int)v0);
    }

    public void write1f(float v0) {
        long dst = this.append(4, 4);
        MemoryUtil.memPutFloat((long)dst, (float)v0);
    }

    public void write2i(int v0, int v1) {
        long dst = this.append(8, 8);
        MemoryUtil.memPutInt((long)dst, (int)v0);
        MemoryUtil.memPutInt((long)(dst + 4L), (int)v1);
    }

    public void write2f(float v0, float v1) {
        long dst = this.append(8, 8);
        MemoryUtil.memPutFloat((long)dst, (float)v0);
        MemoryUtil.memPutFloat((long)(dst + 4L), (float)v1);
    }

    public void write3f(float v0, float v1, float v2) {
        long dst = this.append(16, 12);
        MemoryUtil.memPutFloat((long)dst, (float)v0);
        MemoryUtil.memPutFloat((long)(dst + 4L), (float)v1);
        MemoryUtil.memPutFloat((long)(dst + 8L), (float)v2);
    }

    public void write4i(int v0, int v1, int v2, int v3) {
        long dst = this.append(16, 16);
        MemoryUtil.memPutInt((long)dst, (int)v0);
        MemoryUtil.memPutInt((long)(dst + 4L), (int)v1);
        MemoryUtil.memPutInt((long)(dst + 8L), (int)v2);
        MemoryUtil.memPutInt((long)(dst + 12L), (int)v3);
    }

    public void write4f(float v0, float v1, float v2, float v3) {
        long dst = this.append(16, 16);
        MemoryUtil.memPutFloat((long)dst, (float)v0);
        MemoryUtil.memPutFloat((long)(dst + 4L), (float)v1);
        MemoryUtil.memPutFloat((long)(dst + 8L), (float)v2);
        MemoryUtil.memPutFloat((long)(dst + 12L), (float)v3);
    }

    public void write4fv(int offset, int count, float[] value) {
        assert (count > 0);
        long dst = this.append(16, 16 * count);
        int e = count * 4;
        for (int i = 0; i < e; ++i) {
            MemoryUtil.memPutFloat((long)dst, (float)value[offset++]);
            dst += 4L;
        }
    }

    public void writeMatrix3f(Matrixc matrix) {
        long dst = this.append(16, 48);
        matrix.storeAligned(dst);
        MemoryUtil.memPutInt((long)(dst + 12L), (int)0);
        MemoryUtil.memPutInt((long)(dst + 28L), (int)0);
        MemoryUtil.memPutInt((long)(dst + 44L), (int)0);
    }

    public void writeMatrix3f(Matrix3 matrix) {
        long dst = this.append(16, 48);
        matrix.storeAligned(dst);
        MemoryUtil.memPutInt((long)(dst + 12L), (int)0);
        MemoryUtil.memPutInt((long)(dst + 28L), (int)0);
        MemoryUtil.memPutInt((long)(dst + 44L), (int)0);
    }

    public void writeMatrix3f(int offset, float[] value) {
        long dst = this.append(16, 48);
        MemoryUtil.memPutFloat((long)dst, (float)value[offset]);
        MemoryUtil.memPutFloat((long)(dst + 4L), (float)value[offset + 1]);
        MemoryUtil.memPutFloat((long)(dst + 8L), (float)value[offset + 2]);
        MemoryUtil.memPutInt((long)(dst + 12L), (int)0);
        MemoryUtil.memPutFloat((long)(dst + 16L), (float)value[offset + 3]);
        MemoryUtil.memPutFloat((long)(dst + 20L), (float)value[offset + 4]);
        MemoryUtil.memPutFloat((long)(dst + 24L), (float)value[offset + 5]);
        MemoryUtil.memPutInt((long)(dst + 28L), (int)0);
        MemoryUtil.memPutFloat((long)(dst + 32L), (float)value[offset + 6]);
        MemoryUtil.memPutFloat((long)(dst + 36L), (float)value[offset + 7]);
        MemoryUtil.memPutFloat((long)(dst + 40L), (float)value[offset + 8]);
        MemoryUtil.memPutInt((long)(dst + 44L), (int)0);
    }

    public void writeMatrix4f(Matrix4c matrix) {
        long dst = this.append(16, 64);
        matrix.store(dst);
    }

    public void writeMatrix4f(int offset, float[] value) {
        long dst = this.append(16, 64);
        for (int i = 0; i < 16; ++i) {
            MemoryUtil.memPutFloat((long)dst, (float)value[offset++]);
            dst += 4L;
        }
    }

    public void writePaintColor(float r, float g, float b, float a) {
        if (!this.mWrotePaintColor) {
            this.write4f(r, g, b, a);
            this.mWrotePaintColor = true;
        }
    }

    private long append(int alignment, int size) {
        int offset = this.mPosition;
        int padding = MathUtil.alignTo(offset, alignment) - offset;
        int count = size + padding;
        if (count == 0) {
            assert (size == 0);
            return 0L;
        }
        if (this.mCapacity - this.mPosition >= count) {
            this.mPosition += count;
        } else {
            int newSize = this.mPosition + count;
            int newCapacity = newSize + 4 + (newSize + 4 >> 2);
            newCapacity = MathUtil.alignTo(newCapacity, 16);
            assert (newCapacity > 0);
            this.mStorage = MemoryUtil.nmemRealloc((long)this.mStorage, (long)newCapacity);
            if (this.mStorage == 0L) {
                throw new OutOfMemoryError();
            }
            this.mCapacity = newCapacity;
            this.mPosition = newSize;
            this.mCachedView = null;
        }
        long dst = this.mStorage + (long)this.mPosition - (long)count;
        if (padding > 0) {
            MemoryUtil.memSet((long)dst, (int)0, (long)padding);
            dst += (long)padding;
        }
        assert (dst == this.mStorage + (long)this.mPosition - (long)size);
        this.mRequiredAlignment = Math.max(this.mRequiredAlignment, alignment);
        return dst;
    }
}

