/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.IntBuffer;
import java.util.IdentityHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import yslelf.cloudpick.render.engine.BufferViewInfo;
import yslelf.cloudpick.render.granite.DrawBufferManager;
import yslelf.cloudpick.render.granite.DrawCommandList;

public class UniformTracker {
    ObjectArrayList<UniformCache> mPerPipelineCaches = new ObjectArrayList();
    int mLastPipelineIndex = 4097;
    int mLastUniformIndex = 4097;

    public int trackUniforms(int pipelineIndex, @Nullable IntBuffer data) {
        if (data == null) {
            return 4097;
        }
        while (pipelineIndex >= this.mPerPipelineCaches.size()) {
            this.mPerPipelineCaches.add((Object)new UniformCache());
        }
        UniformCache cache = (UniformCache)this.mPerPipelineCaches.get(pipelineIndex);
        return cache.insert(data);
    }

    public boolean writeUniforms(DrawBufferManager bufferManager) {
        for (UniformCache cache : this.mPerPipelineCaches) {
            int numBlocks = cache.mIndexToData.size();
            if (numBlocks == 0) continue;
            ObjectArrayList<IntBuffer> blocks = cache.mIndexToData;
            int dataSize = ((IntBuffer)blocks.get(0)).remaining() << 2;
            int blockSize = bufferManager.alignUniformBlockSize(dataSize);
            long writer = bufferManager.getUniformPointer(blockSize * numBlocks, cache.mBufferInfo);
            if (writer == 0L) {
                return false;
            }
            cache.mBufferInfo.mSize = blockSize;
            for (int i = 0; i < numBlocks; ++i) {
                IntBuffer src = (IntBuffer)blocks.get(i);
                assert (src.remaining() << 2 == dataSize);
                MemoryUtil.memCopy((long)MemoryUtil.memAddress((IntBuffer)src), (long)writer, (long)dataSize);
                writer += (long)blockSize;
            }
        }
        return true;
    }

    public boolean setCurrentUniforms(int pipelineIndex, int uniformIndex) {
        if (uniformIndex == 4097) {
            return false;
        }
        assert (pipelineIndex != 4097);
        assert (pipelineIndex < this.mPerPipelineCaches.size() && uniformIndex < ((UniformCache)this.mPerPipelineCaches.get((int)pipelineIndex)).mIndexToData.size());
        if (pipelineIndex != this.mLastPipelineIndex || uniformIndex != this.mLastUniformIndex) {
            this.mLastPipelineIndex = pipelineIndex;
            this.mLastUniformIndex = uniformIndex;
            return true;
        }
        return false;
    }

    public void bindUniforms(int binding, DrawCommandList commandList) {
        assert (this.mLastUniformIndex != 4097);
        UniformCache cache = (UniformCache)this.mPerPipelineCaches.get(this.mLastPipelineIndex);
        BufferViewInfo bufferInfo = cache.mBufferInfo;
        commandList.bindUniformBuffer(binding, bufferInfo.mBuffer, bufferInfo.mOffset + (long)this.mLastUniformIndex * bufferInfo.mSize, bufferInfo.mSize);
    }

    static class UniformCache {
        final IdentityHashMap<IntBuffer, Integer> mDataToIndex = new IdentityHashMap();
        final ObjectArrayList<IntBuffer> mIndexToData = new ObjectArrayList();
        final Function<IntBuffer, Integer> mAccumulator = data -> {
            int index = this.mIndexToData.size();
            this.mIndexToData.add(data);
            return index;
        };
        final BufferViewInfo mBufferInfo = new BufferViewInfo();

        UniformCache() {
        }

        int insert(IntBuffer data) {
            return this.mDataToIndex.computeIfAbsent(data, this.mAccumulator);
        }
    }
}

