/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite.geom;

import java.util.Formatter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import yslelf.cloudpick.render.engine.KeyBuilder;
import yslelf.cloudpick.render.engine.ShaderCaps;
import yslelf.cloudpick.render.engine.VertexInputLayout;
import yslelf.cloudpick.render.granite.ArcShape;
import yslelf.cloudpick.render.granite.CommonDepthStencilSettings;
import yslelf.cloudpick.render.granite.Draw;
import yslelf.cloudpick.render.granite.GeometryStep;
import yslelf.cloudpick.render.granite.MeshDrawWriter;
import yslelf.cloudpick.render.granite.shading.VaryingHandler;

public class AnalyticArcStep
extends GeometryStep {
    public static final VertexInputLayout.Attribute LOCAL_ARC = new VertexInputLayout.Attribute("LocalArc", 3, 16);
    public static final VertexInputLayout.Attribute RADII = new VertexInputLayout.Attribute("Radii", 2, 15);
    public static final VertexInputLayout.Attribute RADII_ARC = new VertexInputLayout.Attribute("Radii", 3, 16);
    public static final VertexInputLayout.Attribute FLAGS_AND_DEPTH = new VertexInputLayout.Attribute("FlagsAndDepth", 23, 31);
    public static final VertexInputLayout.AttributeSet INSTANCE_ATTRIBS = VertexInputLayout.AttributeSet.makeImplicit(1, SOLID_COLOR, LOCAL_ARC, RADII, FLAGS_AND_DEPTH, MODEL_VIEW);
    public static final VertexInputLayout.AttributeSet INSTANCE_ATTRIBS_FOR_ARC = VertexInputLayout.AttributeSet.makeImplicit(1, SOLID_COLOR, LOCAL_ARC, RADII_ARC, FLAGS_AND_DEPTH, MODEL_VIEW);
    private final int mType;

    public AnalyticArcStep(int type) {
        super("AnalyticArcStep", switch (type) {
            case 0 -> "butt";
            case 1 -> "round";
            case 2 -> "square";
            case 3 -> "pie";
            case 4 -> "chord";
            default -> throw new AssertionError();
        }, null, ArcShape.isOpenArc(type) ? INSTANCE_ATTRIBS_FOR_ARC : INSTANCE_ATTRIBS, 170, (byte)4, CommonDepthStencilSettings.kDirectDepthGreaterPass);
        this.mType = type;
    }

    @Override
    public void appendToKey(@Nonnull KeyBuilder b) {
    }

    @Override
    @Nonnull
    public GeometryStep.ProgramImpl makeProgramImpl(ShaderCaps caps) {
        return null;
    }

    @Override
    public void emitVaryings(VaryingHandler varyingHandler, boolean usesFastSolidColor) {
        varyingHandler.addVarying("f_ArcEdge", (byte)14);
        varyingHandler.addVarying("f_Span", (byte)14, 1);
        if (ArcShape.isOpenArc(this.mType)) {
            varyingHandler.addVarying("f_Radii", (byte)16, 1);
        } else {
            varyingHandler.addVarying("f_Radii", (byte)15, 1);
        }
        if (usesFastSolidColor) {
            varyingHandler.addVarying("f_Color", (byte)16, 1);
        }
    }

    @Override
    public void emitVertexGeomCode(Formatter vs, @Nonnull String worldPosVar, @Nullable String localPosVar, boolean usesFastSolidColor) {
        vs.format("vec2 position = vec2(gl_VertexID >> 1, gl_VertexID & 1) * 2.0 - 1.0;\n", new Object[0]);
        vs.format("vec2 center = %1$s.xy;\nvec2 angle = %1$s.zw;\n", LOCAL_ARC.name());
        if (ArcShape.isOpenArc(this.mType)) {
            vs.format("const float kOutset = %f;\n", Float.valueOf(this.mType == 2 ? 1.4142135f : 1.0f));
            vs.format("int flags = int(%2$s);\nfloat join = float((flags >> 4) & 1);\nfloat dir = float((flags >> 2) & 3);\nfloat strokeRad = max(%1$s.y, 0.0);\nfloat strokeOffset = (step(join, 0.0) * dir - 1.0) * strokeRad;\nvec2 localEdge = (%1$s.x + %1$s.w * kOutset + strokeRad * dir + %1$s.z) * position;\nvec2 cs = vec2(cos(angle.x), sin(angle.x));\n%3$s = mat2(cs.x,-cs.y,cs.y,cs.x) * localEdge;\n%4$s = vec2(cos(angle.y), sin(angle.y));\n%5$s = vec4(%1$s.xy, strokeOffset, %1$s.w);\n", RADII_ARC.name(), FLAGS_AND_DEPTH.name(), "f_ArcEdge", "f_Span", "f_Radii");
        } else {
            vs.format("int flags = int(%2$s);\nfloat join = float((flags >> 4) & 1);\nfloat dir = float((flags >> 2) & 3);\nfloat strokeRad = max(%1$s.y, 0.0);\nfloat strokeOffset = (step(join, 0.0) * dir - 1.0) * strokeRad;\nvec2 localEdge = (%1$s.x + strokeRad * dir + %1$s.z) * position;\nvec2 cs = vec2(cos(angle.x), sin(angle.x));\n%3$s = mat2(cs.x,-cs.y,cs.y,cs.x) * localEdge;\n%4$s = vec2(cos(angle.y), sin(angle.y));\n%5$s = vec3(%1$s.xy, strokeOffset);\n", RADII.name(), FLAGS_AND_DEPTH.name(), "f_ArcEdge", "f_Span", "f_Radii");
        }
        if (usesFastSolidColor) {
            vs.format("%s = %s;\n", "f_Color", SOLID_COLOR.name());
        }
        vs.format("vec2 localPos = localEdge + center;\n", new Object[0]);
        vs.format("vec3 devicePos = %s * vec3(localPos, 1.0);\n", MODEL_VIEW.name());
        vs.format("vec4 %s = vec4(devicePos.xy, float(%s >> 16u) / 65535.0, devicePos.z);\n", worldPosVar, FLAGS_AND_DEPTH.name());
        if (localPosVar != null) {
            vs.format("%s = localPos;\n", localPosVar);
        }
    }

    @Override
    public void emitFragmentColorCode(Formatter fs, String outputColor) {
        fs.format("%s = %s;\n", outputColor, "f_Color");
    }

    @Override
    public void emitFragmentCoverageCode(Formatter fs, String outputCoverage) {
        fs.format("vec3 radii = %1$s.xyz;\nvec2 q = %2$s;\nvec2 cs = %3$s;\n", "f_Radii", "f_ArcEdge", "f_Span");
        if (ArcShape.isOpenArc(this.mType)) {
            fs.format("float thick = %1$s.w;\n", "f_Radii");
        }
        fs.format("q.x = abs(q.x);\n", new Object[0]);
        if (this.mType == 0) {
            fs.format("q = mat2(cs.x,cs.y,-cs.y,cs.x) * q;\nfloat dis = max( abs(length(q) - radii.x) - thick,\n                 length(vec2(q.x, max(0.0, abs(radii.x - q.y) - thick))) * sign(q.x) );\n", new Object[0]);
        } else if (this.mType == 1) {
            fs.format("float dis = mix( abs(length(q) - radii.x),\n                 length(q - cs.yx * radii.x),\n                 cs.x*q.x > cs.y*q.y) - thick;\n", new Object[0]);
        } else if (this.mType == 2) {
            fs.format("float l = length(q);\nq = mat2(-cs.x,cs.y,cs.y,cs.x) * q;\nq = vec2( mix(l * sign(-cs.x), q.x, any(bvec2(q.y>0.0, q.x>0.0))),\n          mix(l, q.y, q.x>0.0) );\nq = vec2( q.x - thick, abs(q.y - radii.x) - thick );\nfloat dis = min(max(q.x, q.y), 0.0) + length(max(q, 0.0));\n", new Object[0]);
        } else if (this.mType == 3) {
            fs.format("float l = length(q) - radii.x;\nfloat m = length(q - cs.yx * clamp(dot(q,cs.yx), 0.0, radii.x));\nfloat dis = max(l, m * sign(cs.x*q.x - cs.y*q.y));\n", new Object[0]);
        } else {
            assert (this.mType == 4);
            fs.format("float h = cs.x * radii.x;\nfloat w = sqrt(radii.x*radii.x - h*h);\nfloat s = max( q.x*q.x*(h-radii.x) + w*w*(h+radii.x-2.0*q.y), h*q.x-w*q.y );\nfloat dis = mix( mix( length(q-vec2(w,h)), h - q.y, q.x<w ), length(q) - radii.x, s<0.0 );\n", new Object[0]);
        }
        fs.format("dis = mix(dis, abs(dis - radii.z) - radii.y, radii.y >= 0.0);\n", new Object[0]);
        fs.format("float afwidth = fwidth(dis);\nfloat edgeAlpha = 1.0 - clamp(dis/afwidth+0.5, 0.0, 1.0);\n", new Object[0]);
        fs.format("%s = vec4(edgeAlpha);\n", outputCoverage);
    }

    @Override
    public void writeMesh(MeshDrawWriter writer, Draw draw, @Nullable float[] solidColor, boolean mayRequireLocalCoords) {
        writer.beginInstances(null, null, 4);
        long instanceData = writer.append(1);
        if (solidColor != null) {
            MemoryUtil.memPutFloat((long)instanceData, (float)solidColor[0]);
            MemoryUtil.memPutFloat((long)(instanceData + 4L), (float)solidColor[1]);
            MemoryUtil.memPutFloat((long)(instanceData + 8L), (float)solidColor[2]);
            MemoryUtil.memPutFloat((long)(instanceData + 12L), (float)solidColor[3]);
        } else {
            MemoryUtil.memPutLong((long)instanceData, (long)0L);
            MemoryUtil.memPutLong((long)(instanceData + 8L), (long)0L);
        }
        ArcShape shape = (ArcShape)draw.mGeometry;
        MemoryUtil.memPutFloat((long)(instanceData + 16L), (float)shape.mCenterX);
        MemoryUtil.memPutFloat((long)(instanceData + 20L), (float)shape.mCenterY);
        if (this.mType == 2) {
            MemoryUtil.memPutFloat((long)(instanceData + 24L), (float)((shape.mSweepAngle * 0.5f + shape.mStartAngle + 90.0f) * ((float)Math.PI / 180)));
            MemoryUtil.memPutFloat((long)(instanceData + 28L), (float)((180.0f - shape.mSweepAngle * 0.5f) * ((float)Math.PI / 180)));
        } else {
            MemoryUtil.memPutFloat((long)(instanceData + 24L), (float)((shape.mSweepAngle * 0.5f + shape.mStartAngle - 90.0f) * ((float)Math.PI / 180)));
            MemoryUtil.memPutFloat((long)(instanceData + 28L), (float)(shape.mSweepAngle * 0.5f * ((float)Math.PI / 180)));
        }
        MemoryUtil.memPutFloat((long)(instanceData + 32L), (float)shape.mRadius);
        MemoryUtil.memPutFloat((long)(instanceData + 36L), (float)draw.mHalfWidth);
        MemoryUtil.memPutFloat((long)(instanceData + 40L), (float)draw.mAARadius);
        if (ArcShape.isOpenArc(this.mType)) {
            MemoryUtil.memPutFloat((long)(instanceData + 44L), (float)shape.mHalfWidth);
            instanceData += 4L;
        }
        int dir = switch (draw.mStrokeAlign) {
            default -> 4;
            case 1 -> 0;
            case 2 -> 8;
        };
        int join = (this.mType == 0 || this.mType == 2) && draw.mJoinLimit >= 1.4142135f ? 16 : 0;
        MemoryUtil.memPutInt((long)(instanceData + 44L), (int)(draw.getDepth() << 16 | (join | dir)));
        draw.mTransform.store(instanceData + 48L);
        writer.endAppender();
    }
}

