/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite.geom;

import java.util.Formatter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import yslelf.cloudpick.render.engine.KeyBuilder;
import yslelf.cloudpick.render.engine.ShaderCaps;
import yslelf.cloudpick.render.engine.VertexInputLayout;
import yslelf.cloudpick.render.granite.CommonDepthStencilSettings;
import yslelf.cloudpick.render.granite.Draw;
import yslelf.cloudpick.render.granite.GeometryStep;
import yslelf.cloudpick.render.granite.MeshDrawWriter;
import yslelf.cloudpick.render.granite.SimpleShape;
import yslelf.cloudpick.render.granite.shading.UniformHandler;
import yslelf.cloudpick.render.granite.shading.VaryingHandler;

public class AnalyticSimpleBoxStep
extends GeometryStep {
    public static final VertexInputLayout.Attribute LOCAL_RECT = new VertexInputLayout.Attribute("LocalRect", 3, 16);
    public static final VertexInputLayout.Attribute RADII = new VertexInputLayout.Attribute("Radii", 2, 15);
    public static final VertexInputLayout.Attribute FLAGS_AND_DEPTH = new VertexInputLayout.Attribute("FlagsAndDepth", 23, 31);
    public static final VertexInputLayout.AttributeSet INSTANCE_ATTRIBS = VertexInputLayout.AttributeSet.makeImplicit(1, SOLID_COLOR, LOCAL_RECT, RADII, FLAGS_AND_DEPTH, MODEL_VIEW);
    private final boolean mAA;

    public AnalyticSimpleBoxStep(boolean aa) {
        super("AnalyticSimpleBoxStep", aa ? "aa" : "non-aa", null, INSTANCE_ATTRIBS, aa ? 170 : 130, (byte)4, CommonDepthStencilSettings.kDirectDepthGreaterPass);
        this.mAA = aa;
        assert (this.instanceStride() == 84);
    }

    @Override
    public void appendToKey(@Nonnull KeyBuilder b) {
    }

    @Override
    @Nonnull
    public GeometryStep.ProgramImpl makeProgramImpl(ShaderCaps caps) {
        return null;
    }

    @Override
    public void emitVaryings(VaryingHandler varyingHandler, boolean usesFastSolidColor) {
        varyingHandler.addVarying("f_RectEdge", (byte)14);
        varyingHandler.addVarying("f_Size", (byte)14, 1);
        varyingHandler.addVarying("f_Radii", (byte)15, 1);
        if (usesFastSolidColor) {
            varyingHandler.addVarying("f_Color", (byte)16, 1);
        }
    }

    @Override
    public void emitUniforms(UniformHandler uniformHandler, boolean mayRequireLocalCoords) {
    }

    @Override
    public void emitVertexGeomCode(Formatter vs, @Nonnull String worldPosVar, @Nullable String localPosVar, boolean usesFastSolidColor) {
        vs.format("vec2 position = vec2(gl_VertexID >> 1, gl_VertexID & 1) * 2.0 - 1.0;\n", new Object[0]);
        vs.format("vec2 scale = (%1$s.zw - %1$s.xy) * 0.5;\nvec2 translate = (%1$s.xy + %1$s.zw) * 0.5;\n", LOCAL_RECT.name());
        vs.format("int flags = int(%2$s);\nfloat join = float((flags >> 4) & 1);\nfloat dir = float((flags >> 2) & 3);\nint type = flags & 3;\nvec2 localEdge;\nfloat strokeRad = max(%1$s.y, 0.0);\nfloat strokeOffset = (step(join, 0.0) * dir - 1.0) * strokeRad;\nif (type >= 1) {\n    float len = length(scale);\n    vec2 size = vec2(len, %1$s.x);\n    localEdge = (size + strokeRad * dir + %1$s.z) * position;\n    %3$s = localEdge;\n    %4$s = size + join * dir * strokeRad;\n    %5$s = vec3(mix(%1$s.x, 0.0, type >= 2), %1$s.y, strokeOffset);\n    vec2 cs = scale / len;\n    localEdge = mat2(cs.x,cs.y,-cs.y,cs.x) * localEdge;\n} else {\n    localEdge = (scale + strokeRad * dir + %1$s.z) * position;\n    %3$s = localEdge;\n    %4$s = scale + join * dir * strokeRad;\n    %5$s = vec3(%1$s.xy, strokeOffset);\n}\n", RADII.name(), FLAGS_AND_DEPTH.name(), "f_RectEdge", "f_Size", "f_Radii");
        if (usesFastSolidColor) {
            vs.format("%s = %s;\n", "f_Color", SOLID_COLOR.name());
        }
        vs.format("vec2 localPos = localEdge + translate;\n", new Object[0]);
        vs.format("vec3 devicePos = %s * vec3(localPos, 1.0);\n", MODEL_VIEW.name());
        vs.format("vec4 %s = vec4(devicePos.xy, float(%s >> 16u) / 65535.0, devicePos.z);\n", worldPosVar, FLAGS_AND_DEPTH.name());
        if (localPosVar != null) {
            vs.format("%s = localPos;\n", localPosVar);
        }
    }

    @Override
    public void emitFragmentColorCode(Formatter fs, String outputColor) {
        fs.format("%s = %s;\n", outputColor, "f_Color");
    }

    @Override
    public void emitFragmentCoverageCode(Formatter fs, String outputCoverage) {
        fs.format("vec3 radii = %s;\nvec2 q = abs(%s) - %s + radii.x;\n", "f_Radii", "f_RectEdge", "f_Size");
        fs.format("float dis = min(max(q.x, q.y), 0.0) + length(max(q, 0.0)) - radii.x;\ndis = mix(dis, abs(dis - radii.z) - radii.y, radii.y >= 0.0);\n", new Object[0]);
        if (this.mAA) {
            fs.format("float afwidth = fwidth(dis);\nfloat edgeAlpha = 1.0 - clamp(dis/afwidth+0.5, 0.0, 1.0);\n", new Object[0]);
            assert (outputCoverage != null);
            fs.format("%s = vec4(edgeAlpha);\n", outputCoverage);
        } else {
            fs.format("float edgeAlpha = 1.0 - step(0.0, dis);\nif (edgeAlpha <= 0.0) discard;\n", new Object[0]);
            assert (outputCoverage == null);
        }
    }

    @Override
    public void writeMesh(MeshDrawWriter writer, Draw draw, @Nullable float[] solidColor, boolean mayRequireLocalCoords) {
        writer.beginInstances(null, null, 4);
        long instanceData = writer.append(1);
        if (solidColor != null) {
            MemoryUtil.memPutFloat((long)instanceData, (float)solidColor[0]);
            MemoryUtil.memPutFloat((long)(instanceData + 4L), (float)solidColor[1]);
            MemoryUtil.memPutFloat((long)(instanceData + 8L), (float)solidColor[2]);
            MemoryUtil.memPutFloat((long)(instanceData + 12L), (float)solidColor[3]);
        } else {
            MemoryUtil.memPutLong((long)instanceData, (long)0L);
            MemoryUtil.memPutLong((long)(instanceData + 8L), (long)0L);
        }
        SimpleShape shape = (SimpleShape)draw.mGeometry;
        MemoryUtil.memPutFloat((long)(instanceData + 16L), (float)shape.left());
        MemoryUtil.memPutFloat((long)(instanceData + 20L), (float)shape.top());
        MemoryUtil.memPutFloat((long)(instanceData + 24L), (float)shape.right());
        MemoryUtil.memPutFloat((long)(instanceData + 28L), (float)shape.bottom());
        MemoryUtil.memPutFloat((long)(instanceData + 32L), (float)shape.getSimpleRadiusX());
        MemoryUtil.memPutFloat((long)(instanceData + 36L), (float)draw.mHalfWidth);
        MemoryUtil.memPutFloat((long)(instanceData + 40L), (float)draw.mAARadius);
        int dir = switch (draw.mStrokeAlign) {
            default -> 4;
            case 1 -> 0;
            case 2 -> 8;
        };
        int type = switch (shape.getType()) {
            default -> 0;
            case 6 -> 2;
            case 7 -> 1;
        };
        int join = (type == 2 || shape.isRect()) && draw.mJoinLimit >= 1.4142135f ? 16 : 0;
        MemoryUtil.memPutInt((long)(instanceData + 44L), (int)(draw.getDepth() << 16 | (join | dir | type)));
        draw.mTransform.store(instanceData + 48L);
        writer.endAppender();
    }
}

