/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite.geom;

import javax.annotation.Nonnull;
import yslelf.cloudpick.render.engine.KeyBuilder;
import yslelf.cloudpick.render.engine.ShaderCaps;
import yslelf.cloudpick.render.engine.VertexInputLayout;
import yslelf.cloudpick.render.granite.GeometryStep;

public class CircleProcessor
extends GeometryStep {
    public static final VertexInputLayout.Attribute POSITION = new VertexInputLayout.Attribute("Position", 1, 14);
    public static final VertexInputLayout.Attribute CIRCLE_EDGE = new VertexInputLayout.Attribute("CircleEdge", 3, 16);
    public static final VertexInputLayout.Attribute COLOR = new VertexInputLayout.Attribute("Color", 3, 16);
    public static final VertexInputLayout.Attribute CLIP_PLANE = new VertexInputLayout.Attribute("ClipPlane", 2, 15);
    public static final VertexInputLayout.Attribute ISECT_PLANE = new VertexInputLayout.Attribute("IsectPlane", 2, 15);
    public static final VertexInputLayout.Attribute UNION_PLANE = new VertexInputLayout.Attribute("UnionPlane", 2, 15);
    public static final VertexInputLayout.Attribute ROUND_CAP_CENTERS = new VertexInputLayout.Attribute("RoundCapCenters", 3, 16);
    public static final VertexInputLayout.Attribute MODEL_VIEW = new VertexInputLayout.Attribute("ModelView", 2, 18);
    public static final VertexInputLayout.AttributeSet VERTEX_FORMAT = VertexInputLayout.AttributeSet.makeImplicit(0, POSITION, CIRCLE_EDGE);
    public static final VertexInputLayout.AttributeSet INSTANCE_FORMAT = VertexInputLayout.AttributeSet.makeImplicit(1, COLOR, CLIP_PLANE, ISECT_PLANE, UNION_PLANE, ROUND_CAP_CENTERS, MODEL_VIEW);
    private final int mFlags;

    public CircleProcessor(boolean stroke, boolean clipPlane, boolean isectPlane, boolean unionPlane, boolean roundCaps) {
        super("Circle_GeometryProcessor", "", VERTEX_FORMAT, INSTANCE_FORMAT, 0, (byte)3, null);
        assert (!roundCaps || stroke && clipPlane);
        int instanceMask = (clipPlane ? 2 : 0) | (isectPlane ? 4 : 0) | (unionPlane ? 8 : 0) | (roundCaps ? 16 : 0);
        this.mFlags = (stroke ? 1 : 0) | instanceMask;
    }

    @Override
    public void appendToKey(@Nonnull KeyBuilder b) {
        b.addBits(5, this.mFlags, "stroke|clipPlane|isectPlane|unionPlane|roundCaps");
    }

    @Override
    @Nonnull
    public GeometryStep.ProgramImpl makeProgramImpl(ShaderCaps caps) {
        return null;
    }
}

