/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite.geom;

import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import yslelf.cloudpick.render.core.Rect2f;
import yslelf.cloudpick.render.core.Rect2fc;
import yslelf.cloudpick.render.granite.geom.BoundsManager;

public final class FullBoundsManager
extends BoundsManager {
    private final FloatArrayList mRects;
    private final ShortArrayList mOrders;

    public FullBoundsManager() {
        this.mRects = new FloatArrayList();
        this.mOrders = new ShortArrayList();
    }

    public FullBoundsManager(int capacity) {
        this.mRects = new FloatArrayList(capacity * 4);
        this.mOrders = new ShortArrayList(capacity);
    }

    @Override
    public int getMostRecentDraw(Rect2fc bounds) {
        assert (this.mRects.size() == this.mOrders.size() * 4);
        assert (!bounds.isFinite() || bounds.left() <= bounds.right() && bounds.top() <= bounds.bottom());
        float al = bounds.left();
        float at = bounds.top();
        float ar = bounds.right();
        float ab = bounds.bottom();
        float[] r = this.mRects.elements();
        short[] orders = this.mOrders.elements();
        int limit = this.mOrders.size();
        int max = 0;
        int i = 0;
        for (int j = 0; j < limit; ++j) {
            if (ar > r[i] && ab > r[i | 1] && r[i | 2] > al && r[i | 3] > at) {
                max = Math.max(max, Short.toUnsignedInt(orders[j]));
            }
            i += 4;
        }
        return max;
    }

    @Override
    public void recordDraw(Rect2fc bounds, int order) {
        assert (!bounds.isFinite() || bounds.left() <= bounds.right() && bounds.top() <= bounds.bottom());
        FloatArrayList r = this.mRects;
        r.add(bounds.left());
        r.add(bounds.top());
        r.add(bounds.right());
        r.add(bounds.bottom());
        this.mOrders.add((short)order);
    }

    @Override
    public void clear() {
        this.mRects.clear();
        this.mOrders.clear();
    }

    public int count() {
        return this.mOrders.size();
    }

    public void transferTo(BoundsManager other) {
        Rect2f tmp = new Rect2f();
        float[] r = this.mRects.elements();
        short[] orders = this.mOrders.elements();
        int limit = this.mOrders.size();
        int i = 0;
        for (int j = 0; j < limit; ++j) {
            tmp.set(r[i], r[i | 1], r[i | 2], r[i | 3]);
            other.recordDraw(tmp, orders[j]);
            i += 4;
        }
        this.clear();
    }
}

