/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite.geom;

import java.util.Arrays;
import javax.annotation.Nonnull;
import yslelf.cloudpick.render.core.MathUtil;
import yslelf.cloudpick.render.core.Rect2fc;
import yslelf.cloudpick.render.granite.geom.BoundsManager;

public final class GridBoundsManager
extends BoundsManager {
    private final float mScaleX;
    private final float mScaleY;
    private final int mGridWidth;
    private final int mGridHeight;
    private final short[] mNodes;

    public GridBoundsManager(int deviceWidth, int deviceHeight, int gridWidth, int gridHeight) {
        assert (deviceWidth > 0 && deviceHeight > 0);
        assert (gridWidth >= 1 && gridHeight >= 1);
        this.mScaleX = (float)gridWidth / (float)deviceWidth;
        this.mScaleY = (float)gridHeight / (float)deviceHeight;
        this.mGridWidth = gridWidth;
        this.mGridHeight = gridHeight;
        this.mNodes = new short[gridWidth * gridHeight];
    }

    @Nonnull
    public static GridBoundsManager makeRes(int deviceWidth, int deviceHeight, int gridCellSize, int maxGridSize) {
        assert (deviceWidth > 0 && deviceHeight > 0);
        assert (gridCellSize >= 1);
        int gridWidth = (int)Math.ceil((double)deviceWidth / (double)gridCellSize);
        if (maxGridSize > 0 && gridWidth > maxGridSize) {
            gridWidth = maxGridSize;
        } else {
            deviceWidth = gridWidth * gridCellSize;
        }
        int gridHeight = (int)Math.ceil((double)deviceHeight / (double)gridCellSize);
        if (maxGridSize > 0 && gridHeight > maxGridSize) {
            gridHeight = maxGridSize;
        } else {
            deviceHeight = gridHeight * gridCellSize;
        }
        return new GridBoundsManager(deviceWidth, deviceHeight, gridWidth, gridHeight);
    }

    @Override
    public int getMostRecentDraw(Rect2fc bounds) {
        int l2 = MathUtil.clamp((int)(bounds.left() * this.mScaleX), 0, this.mGridWidth - 1);
        int t2 = MathUtil.clamp((int)(bounds.top() * this.mScaleY), 0, this.mGridHeight - 1);
        int r = MathUtil.clamp((int)(bounds.right() * this.mScaleX), 0, this.mGridWidth - 1);
        int b = MathUtil.clamp((int)(bounds.bottom() * this.mScaleY), 0, this.mGridHeight - 1);
        int p2 = t2 * this.mGridWidth + l2;
        int h2 = b - t2;
        int w = r - l2;
        int max = 0;
        for (int y = 0; y <= h2; ++y) {
            for (int x = 0; x <= w; ++x) {
                int v = this.mNodes[p2 + x] & 0xFFFF;
                if (v <= max) continue;
                max = v;
            }
            p2 += this.mGridWidth;
        }
        return max;
    }

    @Override
    public void recordDraw(Rect2fc bounds, int order) {
        int l2 = MathUtil.clamp((int)(bounds.left() * this.mScaleX), 0, this.mGridWidth - 1);
        int t2 = MathUtil.clamp((int)(bounds.top() * this.mScaleY), 0, this.mGridHeight - 1);
        int r = MathUtil.clamp((int)(bounds.right() * this.mScaleX), 0, this.mGridWidth - 1);
        int b = MathUtil.clamp((int)(bounds.bottom() * this.mScaleY), 0, this.mGridHeight - 1);
        int p2 = t2 * this.mGridWidth + l2;
        int h2 = b - t2;
        int w = r - l2;
        for (int y = 0; y <= h2; ++y) {
            for (int x = 0; x <= w; ++x) {
                int v = this.mNodes[p2 + x] & 0xFFFF;
                if (order <= v) continue;
                this.mNodes[p2 + x] = (short)order;
            }
            p2 += this.mGridWidth;
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.mNodes, (short)0);
    }
}

