/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite.geom;

import java.util.Formatter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.core.Matrix;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.engine.ImageViewProxy;
import yslelf.cloudpick.render.engine.KeyBuilder;
import yslelf.cloudpick.render.engine.RecordingContext;
import yslelf.cloudpick.render.engine.SamplerDesc;
import yslelf.cloudpick.render.engine.ShaderCaps;
import yslelf.cloudpick.render.engine.VertexInputLayout;
import yslelf.cloudpick.render.granite.CommonDepthStencilSettings;
import yslelf.cloudpick.render.granite.Draw;
import yslelf.cloudpick.render.granite.GeometryStep;
import yslelf.cloudpick.render.granite.MeshDrawWriter;
import yslelf.cloudpick.render.granite.SubRunData;
import yslelf.cloudpick.render.granite.TextureDataGatherer;
import yslelf.cloudpick.render.granite.UniformDataGatherer;
import yslelf.cloudpick.render.granite.shading.UniformHandler;
import yslelf.cloudpick.render.granite.shading.VaryingHandler;

public class RasterTextStep
extends GeometryStep {
    public static final VertexInputLayout.Attribute XY = new VertexInputLayout.Attribute("XY", 1, 14);
    public static final VertexInputLayout.Attribute UV = new VertexInputLayout.Attribute("UV", 20, 32);
    public static final VertexInputLayout.Attribute SIZE = new VertexInputLayout.Attribute("Size", 20, 32);
    public static final VertexInputLayout.AttributeSet INSTANCE_ATTRIBS = VertexInputLayout.AttributeSet.makeImplicit(1, XY, UV, SIZE, DEPTH);
    private final int mMaskFormat;

    public RasterTextStep(int maskFormat) {
        super("RasterTextStep", switch (maskFormat) {
            case 0 -> "gray";
            case 1 -> "lcd";
            case 2 -> "color";
            default -> throw new AssertionError();
        }, null, INSTANCE_ATTRIBS, switch (maskFormat) {
            case 0, 1 -> 14;
            case 2 -> 70;
            default -> throw new AssertionError();
        }, (byte)4, CommonDepthStencilSettings.kDirectDepthGEqualPass);
        this.mMaskFormat = maskFormat;
        assert (maskFormat != 1);
        assert (this.instanceStride() == 20);
    }

    @Override
    public void appendToKey(@Nonnull KeyBuilder b) {
    }

    @Override
    @Nonnull
    public GeometryStep.ProgramImpl makeProgramImpl(ShaderCaps caps) {
        return null;
    }

    @Override
    public void emitVaryings(VaryingHandler varyingHandler, boolean usesFastSolidColor) {
        assert (!usesFastSolidColor);
        varyingHandler.addVarying("f_TexCoords", (byte)14);
    }

    @Override
    public void emitUniforms(UniformHandler uniformHandler, boolean mayRequireLocalCoords) {
        uniformHandler.addUniform(1, (byte)18, "u_SubRunToDevice", -1);
        if (mayRequireLocalCoords) {
            uniformHandler.addUniform(1, (byte)18, "u_SubRunToLocal", -1);
        }
        uniformHandler.addUniform(1, (byte)14, "u_InvAtlasSize", -1);
    }

    @Override
    public void emitSamplers(UniformHandler uniformHandler) {
        uniformHandler.addSampler((byte)35, "u_GlyphAtlas", -1);
    }

    @Override
    public void emitVertexGeomCode(Formatter vs, @Nonnull String worldPosVar, @Nullable String localPosVar, boolean usesFastSolidColor) {
        assert (!usesFastSolidColor);
        vs.format("vec2 position = vec2(gl_VertexID >> 1, gl_VertexID & 1) * vec2(%s);\n", SIZE.name());
        vs.format("%s = (position + vec2(%s)) * %s;\n", "f_TexCoords", UV.name(), "u_InvAtlasSize");
        vs.format("vec3 pos = vec3(position + %s, 1.0);\n", XY.name());
        vs.format("vec3 devicePos = %s * pos;\n", "u_SubRunToDevice");
        vs.format("vec4 %s = vec4(devicePos.xy, %s, devicePos.z);\n", worldPosVar, DEPTH.name());
        if (localPosVar != null) {
            vs.format("%s = (%s * pos).xy;\n", localPosVar, "u_SubRunToLocal");
        }
    }

    @Override
    public void emitFragmentColorCode(Formatter fs, String outputColor) {
        fs.format("%s = texture(%s, %s);\n", outputColor, "u_GlyphAtlas", "f_TexCoords");
    }

    @Override
    public void emitFragmentCoverageCode(Formatter fs, String outputCoverage) {
        if (this.mMaskFormat == 0) {
            fs.format("%s = texture(%s, %s).rrrr;\n", outputCoverage, "u_GlyphAtlas", "f_TexCoords");
        } else {
            fs.format("%s = texture(%s, %s);\n", outputCoverage, "u_GlyphAtlas", "f_TexCoords");
        }
    }

    @Override
    public void writeMesh(MeshDrawWriter writer, Draw draw, @Nullable float[] solidColor, boolean mayRequireLocalCoords) {
        assert (solidColor == null);
        SubRunData subRunData = (SubRunData)draw.mGeometry;
        if (!mayRequireLocalCoords && draw.mTransform.isTranslate()) {
            subRunData.getSubRun().fillInstanceData(writer, subRunData.getStartGlyphIndex(), subRunData.getGlyphCount(), draw.mTransform.getTranslateX(), draw.mTransform.getTranslateY(), draw.getDepthAsFloat());
        } else {
            subRunData.getSubRun().fillInstanceData(writer, subRunData.getStartGlyphIndex(), subRunData.getGlyphCount(), draw.getDepthAsFloat());
        }
    }

    @Override
    public void writeUniformsAndTextures(RecordingContext context, Draw draw, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer, boolean mayRequireLocalCoords) {
        SubRunData subRunData = (SubRunData)draw.mGeometry;
        ImageViewProxy texture = context.getAtlasProvider().getGlyphAtlasManager().getCurrentTexture(subRunData.getSubRun().getMaskFormat());
        assert (texture != null);
        if (!mayRequireLocalCoords && draw.mTransform.isTranslate()) {
            uniformDataGatherer.writeMatrix3f(Matrix.identity());
        } else {
            uniformDataGatherer.writeMatrix3f(draw.mTransform);
        }
        if (mayRequireLocalCoords) {
            uniformDataGatherer.writeMatrix3f(subRunData.getSubRunToLocal());
        }
        uniformDataGatherer.write2f(1.0f / (float)texture.getWidth(), 1.0f / (float)texture.getHeight());
        textureDataGatherer.add(RefCnt.create(texture), SamplerDesc.make(subRunData.getFilter()));
    }
}

