/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite.geom;

import java.util.Formatter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import yslelf.cloudpick.render.core.Vertices;
import yslelf.cloudpick.render.engine.KeyBuilder;
import yslelf.cloudpick.render.engine.RecordingContext;
import yslelf.cloudpick.render.engine.ShaderCaps;
import yslelf.cloudpick.render.engine.VertexInputLayout;
import yslelf.cloudpick.render.granite.CommonDepthStencilSettings;
import yslelf.cloudpick.render.granite.Draw;
import yslelf.cloudpick.render.granite.GeometryStep;
import yslelf.cloudpick.render.granite.MeshDrawWriter;
import yslelf.cloudpick.render.granite.TextureDataGatherer;
import yslelf.cloudpick.render.granite.UniformDataGatherer;
import yslelf.cloudpick.render.granite.shading.UniformHandler;
import yslelf.cloudpick.render.granite.shading.VaryingHandler;

public class VerticesStep
extends GeometryStep {
    public static final VertexInputLayout.Attribute POSITION = new VertexInputLayout.Attribute("Pos", 1, 14);
    public static final VertexInputLayout.Attribute COLOR = new VertexInputLayout.Attribute("Color", 17, 16);
    public static final VertexInputLayout.Attribute TEX_COORD = new VertexInputLayout.Attribute("UV", 1, 14);
    public static final VertexInputLayout.AttributeSet ATTRIBS_POS = VertexInputLayout.AttributeSet.makeImplicit(0, POSITION);
    public static final VertexInputLayout.AttributeSet ATTRIBS_POS_COLOR = VertexInputLayout.AttributeSet.makeImplicit(0, POSITION, COLOR);
    public static final VertexInputLayout.AttributeSet ATTRIBS_POS_UV = VertexInputLayout.AttributeSet.makeImplicit(0, POSITION, TEX_COORD);
    public static final VertexInputLayout.AttributeSet ATTRIBS_POS_COLOR_UV = VertexInputLayout.AttributeSet.makeImplicit(0, POSITION, COLOR, TEX_COORD);
    private final boolean mHasColor;
    private final boolean mHasTexCoords;

    public VerticesStep(byte primitiveType, boolean hasColor, boolean hasTexCoords) {
        super("VerticesStep", VerticesStep.variant_name(primitiveType, hasColor, hasTexCoords), hasTexCoords ? (hasColor ? ATTRIBS_POS_COLOR_UV : ATTRIBS_POS_UV) : (hasColor ? ATTRIBS_POS_COLOR : ATTRIBS_POS), null, hasColor ? 66 : 2, primitiveType, CommonDepthStencilSettings.kDirectDepthGEqualPass);
        this.mHasColor = hasColor;
        this.mHasTexCoords = hasTexCoords;
    }

    private static String variant_name(byte primitiveType, boolean hasColor, boolean hasTexCoords) {
        Object name = switch (primitiveType) {
            case 0 -> "pts";
            case 1 -> "lines";
            case 2 -> "linestrip";
            case 3 -> "tris";
            case 4 -> "tristrip";
            default -> throw new AssertionError();
        };
        if (hasColor) {
            name = (String)name + "-color";
        }
        if (hasTexCoords) {
            name = (String)name + "-tex";
        }
        return name;
    }

    @Override
    public void appendToKey(@Nonnull KeyBuilder b) {
    }

    @Override
    @Nonnull
    public GeometryStep.ProgramImpl makeProgramImpl(ShaderCaps caps) {
        return null;
    }

    @Override
    public void emitVaryings(VaryingHandler varyingHandler, boolean usesFastSolidColor) {
        assert (!usesFastSolidColor);
        if (this.mHasColor) {
            varyingHandler.addVarying("f_Color", (byte)16);
        }
    }

    @Override
    public void emitUniforms(UniformHandler uniformHandler, boolean mayRequireLocalCoords) {
        uniformHandler.addUniform(1, (byte)18, "u_LocalToDevice", -1);
        uniformHandler.addUniform(1, (byte)13, "u_Depth", -1);
    }

    @Override
    public void emitVertexGeomCode(Formatter vs, @Nonnull String worldPosVar, @Nullable String localPosVar, boolean usesFastSolidColor) {
        assert (!usesFastSolidColor);
        if (this.mHasColor) {
            vs.format("%1$s = vec4(%2$s.rgb * %2$s.a, %2$s.a);\n", "f_Color", COLOR.name());
        }
        vs.format("vec3 devicePos = %s * vec3(%s, 1.0);\n", "u_LocalToDevice", POSITION.name());
        vs.format("vec4 %s = vec4(devicePos.xy, %s, devicePos.z);\n", worldPosVar, "u_Depth");
        if (localPosVar != null) {
            vs.format("%s = %s;\n", localPosVar, this.mHasTexCoords ? TEX_COORD.name() : POSITION.name());
        }
    }

    @Override
    public void emitFragmentColorCode(Formatter fs, String outputColor) {
        fs.format("%s = %s;\n", outputColor, "f_Color");
    }

    @Override
    public void writeMesh(MeshDrawWriter writer, Draw draw, @Nullable float[] solidColor, boolean mayRequireLocalCoords) {
        assert (solidColor == null);
        Vertices vertices = (Vertices)draw.mGeometry;
        int vertexCount = vertices.getVertexCount();
        int indexCount = vertices.getIndexCount();
        float[] positions = vertices.getPositions();
        float[] texCoords = vertices.getTexCoords();
        byte[] colors = vertices.getColors();
        short[] indices = vertices.getIndices();
        assert (this.mHasColor == (colors != null));
        assert (this.mHasTexCoords == (texCoords != null));
        writer.beginVertices();
        if (indices != null) {
            long vertexData = writer.append(indexCount);
            for (int i = 0; i < indexCount; ++i) {
                int index = indices[i] & 0xFFFF;
                MemoryUtil.memPutFloat((long)vertexData, (float)positions[index << 1]);
                MemoryUtil.memPutFloat((long)(vertexData + 4L), (float)positions[index << 1 | 1]);
                vertexData += 8L;
                if (this.mHasColor) {
                    MemoryUtil.memPutByte((long)vertexData, (byte)colors[index << 2]);
                    MemoryUtil.memPutByte((long)(vertexData + 1L), (byte)colors[index << 2 | 1]);
                    MemoryUtil.memPutByte((long)(vertexData + 2L), (byte)colors[index << 2 | 2]);
                    MemoryUtil.memPutByte((long)(vertexData + 3L), (byte)colors[index << 2 | 3]);
                    vertexData += 4L;
                }
                if (!this.mHasTexCoords) continue;
                MemoryUtil.memPutFloat((long)vertexData, (float)texCoords[index << 1]);
                MemoryUtil.memPutFloat((long)(vertexData + 4L), (float)texCoords[index << 1 | 1]);
                vertexData += 8L;
            }
        } else {
            long vertexData = writer.append(vertexCount);
            for (int i = 0; i < vertexCount; ++i) {
                MemoryUtil.memPutFloat((long)vertexData, (float)positions[i << 1]);
                MemoryUtil.memPutFloat((long)(vertexData + 4L), (float)positions[i << 1 | 1]);
                vertexData += 8L;
                if (this.mHasColor) {
                    MemoryUtil.memPutByte((long)vertexData, (byte)colors[i << 2]);
                    MemoryUtil.memPutByte((long)(vertexData + 1L), (byte)colors[i << 2 | 1]);
                    MemoryUtil.memPutByte((long)(vertexData + 2L), (byte)colors[i << 2 | 2]);
                    MemoryUtil.memPutByte((long)(vertexData + 3L), (byte)colors[i << 2 | 3]);
                    vertexData += 4L;
                }
                if (!this.mHasTexCoords) continue;
                MemoryUtil.memPutFloat((long)vertexData, (float)texCoords[i << 1]);
                MemoryUtil.memPutFloat((long)(vertexData + 4L), (float)texCoords[i << 1 | 1]);
                vertexData += 8L;
            }
        }
        writer.endAppender();
    }

    @Override
    public void writeUniformsAndTextures(RecordingContext context, Draw draw, UniformDataGatherer uniformDataGatherer, TextureDataGatherer textureDataGatherer, boolean mayRequireLocalCoords) {
        uniformDataGatherer.writeMatrix3f(draw.mTransform);
        uniformDataGatherer.write1f(draw.getDepthAsFloat());
    }
}

