/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite.shading;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Comparator;
import yslelf.cloudpick.render.core.SLDataType;
import yslelf.cloudpick.render.engine.ShaderCaps;
import yslelf.cloudpick.render.engine.ShaderVar;
import yslelf.cloudpick.render.granite.ShaderCodeSource;

public class UniformHandler {
    public static final String NO_MANGLE_PREFIX = "SV_";
    public static final String PROJECTION_NAME = "SV_Projection";
    public static final String PAINT_COLOR_NAME = "SV_PaintColor";
    public static final int Std140Layout = 0;
    public static final int Std430Layout = 1;
    public static final int MAIN_DESC_SET = 0;
    public static final int SAMPLER_DESC_SET = 1;
    public static final int INPUT_DESC_SET = 2;
    public static final int INPUT_BINDING = 0;
    protected final ShaderCaps mShaderCaps;
    private final int mLayout;
    public final ArrayList<UniformInfo> mUniforms = new ArrayList();
    public final ArrayList<UniformInfo> mSamplers = new ArrayList();
    private ArrayList<UniformInfo> mReorderedUniforms;
    public int mCurrentOffset;
    boolean mFinished;

    public UniformHandler(ShaderCaps shaderCaps, int layout) {
        this.mShaderCaps = shaderCaps;
        this.mLayout = layout;
    }

    public final int addUniform(int visibility, byte type, String name, int manglingSuffix) {
        assert (name != null && !name.isEmpty());
        assert ((visibility & 0xFFFFFFFA) == 0);
        assert (SLDataType.checkSLType(type));
        assert (!SLDataType.isCombinedSamplerType(type));
        return this.internalAddUniformArray(visibility, type, name, 0, manglingSuffix);
    }

    public final int addUniformArray(int visibility, byte type, String name, int arraySize, int manglingSuffix) {
        assert (name != null && !name.isEmpty());
        assert ((visibility & 0xFFFFFFFA) == 0);
        assert (SLDataType.checkSLType(type));
        assert (!SLDataType.isCombinedSamplerType(type));
        return this.internalAddUniformArray(visibility, type, name, arraySize, manglingSuffix);
    }

    public ShaderVar getUniformVariable(int handle) {
        return this.mUniforms.get((int)handle).mVariable;
    }

    public final String getUniformName(int handle) {
        return this.getUniformVariable(handle).getName();
    }

    public int numUniforms() {
        return this.mUniforms.size();
    }

    public int numSamplers() {
        return this.mSamplers.size();
    }

    public UniformInfo uniform(int index) {
        return this.mUniforms.get(index);
    }

    protected int internalAddUniformArray(int visibility, byte type, String name, int arraySize, int manglingSuffix) {
        String resolvedName;
        assert (SLDataType.canBeUniformValue(type));
        assert (visibility != 0);
        assert (!name.contains("__"));
        if (name.startsWith(NO_MANGLE_PREFIX)) {
            for (int i = 0; i < this.mUniforms.size(); ++i) {
                if (!this.mUniforms.get((int)i).mRawName.equals(name)) continue;
                return i;
            }
            resolvedName = name;
        } else {
            resolvedName = ShaderCodeSource.getMangledName(name, manglingSuffix);
        }
        assert (!resolvedName.contains("__"));
        int handle = this.mUniforms.size();
        UniformInfo tempInfo = new UniformInfo();
        tempInfo.mVariable = new ShaderVar(resolvedName, type, 0, arraySize);
        tempInfo.mVisibility = visibility;
        tempInfo.mRawName = name;
        this.mUniforms.add(tempInfo);
        return handle;
    }

    public int addSampler(byte type, String name, int manglingSuffix) {
        assert (name != null && !name.isEmpty());
        String resolvedName = ShaderCodeSource.getMangledName(name, manglingSuffix);
        int handle = this.mSamplers.size();
        Object layoutQualifier = this.mShaderCaps.mUseUniformBinding ? "binding = " + handle : "";
        UniformInfo tempInfo = new UniformInfo();
        tempInfo.mVariable = new ShaderVar(resolvedName, type, 4, 0, (String)layoutQualifier, "");
        tempInfo.mVisibility = 4;
        tempInfo.mRawName = name;
        this.mSamplers.add(tempInfo);
        return handle;
    }

    public String samplerVariable(int handle) {
        return this.mSamplers.get((int)handle).mVariable.getName();
    }

    protected int addInputSampler(short swizzle, String name) {
        throw new UnsupportedOperationException();
    }

    protected String inputSamplerVariable(int handle) {
        throw new UnsupportedOperationException();
    }

    public void finish(boolean reorderUniforms) {
        if (this.mFinished) {
            return;
        }
        this.mFinished = true;
        this.mReorderedUniforms = new ArrayList<UniformInfo>(this.mUniforms);
        if (reorderUniforms) {
            Comparator<UniformInfo> cmp = Comparator.comparingInt(u -> UniformHandler.getAlignmentMask(u.mVariable.getType(), !u.mVariable.isArray(), this.mLayout));
            this.mReorderedUniforms.sort(cmp.reversed());
        }
        for (UniformInfo u2 : this.mReorderedUniforms) {
            int offset = UniformHandler.getAlignedOffset(this.mCurrentOffset, u2.mVariable.getType(), u2.mVariable.getArraySize(), this.mLayout);
            this.mCurrentOffset = offset + UniformHandler.getAlignedStride(u2.mVariable.getType(), u2.mVariable.getArraySize(), this.mLayout);
            if (this.mShaderCaps.mUseBlockMemberOffset) {
                u2.mVariable.addLayoutQualifier("offset", offset);
            }
            u2.mOffset = offset;
        }
    }

    public boolean appendUniformDecls(int visibility, int binding, String blockName, StringBuilder out) {
        assert (visibility != 0);
        this.finish(false);
        boolean firstMember = false;
        boolean firstVisible = false;
        for (UniformInfo uniform : this.mReorderedUniforms) {
            assert (SLDataType.canBeUniformValue(uniform.mVariable.getType()));
            if (!firstMember) {
                assert (uniform.mOffset == 0);
                firstMember = true;
            }
            if ((uniform.mVisibility & visibility) == 0) continue;
            firstVisible = true;
        }
        if (firstVisible) {
            out.append("layout(");
            out.append(this.mLayout == 1 ? "std430" : "std140");
            if (this.mShaderCaps.mUseUniformBinding) {
                out.append(", binding = ");
                out.append(binding);
            }
            out.append(") uniform ");
            out.append(blockName);
            out.append(" {\n");
            for (UniformInfo uniform : this.mReorderedUniforms) {
                uniform.mVariable.appendDecl(out);
                out.append(";\n");
            }
            out.append("};\n");
        }
        return firstVisible;
    }

    public void appendSamplerDecls(int visibility, StringBuilder out) {
        for (UniformInfo sampler : this.mSamplers) {
            assert (sampler.mVariable.getType() == 35);
            if ((sampler.mVisibility & visibility) == 0) continue;
            sampler.mVariable.appendDecl(out);
            out.append(";\n");
        }
    }

    public static int getAlignmentMask(byte type, boolean nonArray, int layout) {
        switch (type) {
            case 1: 
            case 13: 
            case 27: 
            case 31: {
                return layout == 1 || nonArray ? 3 : 15;
            }
            case 2: 
            case 14: 
            case 28: 
            case 32: {
                return layout == 1 || nonArray ? 7 : 15;
            }
            case 3: 
            case 4: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 29: 
            case 30: 
            case 33: 
            case 34: {
                return 15;
            }
            case 17: {
                return layout == 1 ? 7 : 15;
            }
            case 0: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                throw new IllegalStateException(String.valueOf(type));
            }
        }
        throw new IllegalArgumentException(String.valueOf(type));
    }

    public static int getSize(byte type, int layout) {
        switch (type) {
            case 13: {
                return 4;
            }
            case 14: {
                return 8;
            }
            case 15: {
                return 12;
            }
            case 16: {
                return 16;
            }
            case 1: 
            case 27: 
            case 31: {
                return 4;
            }
            case 2: 
            case 28: 
            case 32: {
                return 8;
            }
            case 3: 
            case 29: 
            case 33: {
                return 12;
            }
            case 4: 
            case 30: 
            case 34: {
                return 16;
            }
            case 17: {
                return layout == 1 ? 16 : 32;
            }
            case 18: {
                return 48;
            }
            case 19: {
                return 64;
            }
            case 0: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                throw new IllegalStateException(String.valueOf(type));
            }
        }
        throw new IllegalArgumentException(String.valueOf(type));
    }

    public static int getAlignedOffset(int offset, byte type, int arraySize, int layout) {
        assert (SLDataType.checkSLType(type));
        assert (arraySize == 0 || arraySize >= 1);
        int alignmentMask = UniformHandler.getAlignmentMask(type, arraySize == 0, layout);
        return offset + alignmentMask & ~alignmentMask;
    }

    public static int getAlignedStride(byte type, int arraySize, int layout) {
        assert (SLDataType.checkSLType(type));
        assert (arraySize == 0 || arraySize >= 1);
        if (arraySize == 0) {
            return UniformHandler.getSize(type, layout);
        }
        int elementSize = layout == 1 ? UniformHandler.getSize(type, 1) : Math.max(UniformHandler.getSize(type, 0), 16);
        assert ((elementSize & 0xF) == 0);
        return elementSize * arraySize;
    }

    public static class UniformInfo {
        public ShaderVar mVariable;
        public int mVisibility;
        public String mRawName;
        public int mOffset;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SamplerHandle {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UniformHandle {
    }
}

