/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.granite.shading;

import java.util.ArrayList;
import yslelf.cloudpick.render.core.SLDataType;
import yslelf.cloudpick.render.engine.ShaderCaps;
import yslelf.cloudpick.render.engine.ShaderVar;

public class VaryingHandler {
    public static final int kSmooth_Interpolation = 0;
    public static final int kCanBeFlat_Interpolation = 1;
    public static final int kRequiredToBeFlat_Interpolation = 2;
    protected final ArrayList<VaryingInfo> mVaryings = new ArrayList();
    protected final ArrayList<ShaderVar> mVertexOutputs = new ArrayList();
    protected final ArrayList<ShaderVar> mFragInputs = new ArrayList();
    protected final ShaderCaps mShaderCaps;
    private String mDefaultInterpolationModifier = "";

    public VaryingHandler(ShaderCaps shaderCaps) {
        this.mShaderCaps = shaderCaps;
    }

    public final void setNoPerspective() {
        if (!this.mShaderCaps.mNoPerspectiveInterpolationSupport) {
            return;
        }
        this.mDefaultInterpolationModifier = "noperspective";
    }

    public final void addVarying(String name, byte type) {
        this.addVarying(name, type, 0);
    }

    public final void addVarying(String name, byte type, int interpolation) {
        assert (type != 0);
        assert (SLDataType.isFloatType(type) || interpolation == 2);
        VaryingInfo v = new VaryingInfo();
        v.mType = type;
        v.mIsFlat = VaryingHandler.useFlatInterpolation(interpolation, this.mShaderCaps);
        v.mVsOut = name;
        v.mVisibility = 0;
        v.mVisibility |= 1;
        v.mVisibility |= 4;
        this.mVaryings.add(v);
    }

    private static boolean useFlatInterpolation(int interpolation, ShaderCaps shaderCaps) {
        return switch (interpolation) {
            case 0 -> false;
            case 1 -> shaderCaps.mPreferFlatInterpolation;
            case 2 -> true;
            default -> throw new AssertionError(interpolation);
        };
    }

    public final void finish() {
        int locationIndex = 0;
        for (VaryingInfo v : this.mVaryings) {
            String modifier;
            Object layoutQualifier = this.mShaderCaps.mUseVaryingLocation ? "location = " + locationIndex : "";
            String string = modifier = v.mIsFlat ? "flat" : this.mDefaultInterpolationModifier;
            if ((v.mVisibility & 1) != 0) {
                this.mVertexOutputs.add(new ShaderVar(v.mVsOut, v.mType, 1, 0, (String)layoutQualifier, modifier));
            }
            if ((v.mVisibility & 4) != 0) {
                String fsIn = v.mVsOut;
                this.mFragInputs.add(new ShaderVar(fsIn, v.mType, 2, 0, (String)layoutQualifier, modifier));
            }
            int locations = SLDataType.locations(v.mType);
            assert (locations > 0);
            locationIndex += locations;
        }
        this.onFinish();
    }

    protected void onFinish() {
    }

    public final void getVertDecls(StringBuilder outputDecls) {
        for (ShaderVar var : this.mVertexOutputs) {
            var.appendDecl(outputDecls);
            outputDecls.append(";\n");
        }
    }

    public final void getFragDecls(StringBuilder inputDecls) {
        for (ShaderVar var : this.mFragInputs) {
            var.appendDecl(inputDecls);
            inputDecls.append(";\n");
        }
    }

    protected static class VaryingInfo {
        public byte mType;
        public boolean mIsFlat;
        public String mVsOut;
        public int mVisibility;
    }
}

