/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.mock;

import javax.annotation.Nonnull;
import yslelf.cloudpick.render.core.ColorInfo;
import yslelf.cloudpick.render.core.MathUtil;
import yslelf.cloudpick.render.engine.BackendFormat;

public final class MockBackendFormat
extends BackendFormat {
    private final int mColorType;
    private final int mCompressionType;
    private final short mDepthBits;
    private final boolean mIsStencilFormat;

    public MockBackendFormat(int colorType, int compressionType, short depthBits, boolean isStencilFormat) {
        this.mColorType = colorType;
        this.mCompressionType = compressionType;
        this.mDepthBits = depthBits;
        this.mIsStencilFormat = isStencilFormat;
    }

    @Nonnull
    public static MockBackendFormat make(int colorType, int compressionType) {
        return MockBackendFormat.make(colorType, compressionType, 0, false);
    }

    @Nonnull
    public static MockBackendFormat make(int colorType, int compressionType, int depthBits, boolean isStencilFormat) {
        return new MockBackendFormat(colorType, compressionType, (short)depthBits, isStencilFormat);
    }

    @Override
    public int getBackend() {
        return 2;
    }

    @Override
    public int getChannelFlags() {
        return ColorInfo.colorTypeChannelFlags(this.mColorType);
    }

    @Override
    public boolean isSRGB() {
        return this.mCompressionType == 0 && this.mColorType == 8;
    }

    @Override
    public int getCompressionType() {
        return this.mCompressionType;
    }

    @Override
    public int getBytesPerBlock() {
        if (this.mCompressionType != 0) {
            return 8;
        }
        if (this.mDepthBits > 0 || this.mIsStencilFormat) {
            return MathUtil.ceilPow2((this.mDepthBits >>> 3) + (this.mIsStencilFormat ? 1 : 0));
        }
        return ColorInfo.bytesPerPixel(this.mColorType);
    }

    @Override
    public int getDepthBits() {
        return this.mDepthBits;
    }

    @Override
    public int getStencilBits() {
        return this.mIsStencilFormat ? 8 : 0;
    }

    @Override
    public int getFormatKey() {
        return this.mColorType;
    }
}

