/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.opengl;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.lwjgl.system.NativeType;
import yslelf.cloudpick.render.engine.BackendFormat;
import yslelf.cloudpick.render.opengl.GLUtil;

@Immutable
public final class GLBackendFormat
extends BackendFormat {
    private static final Int2ObjectOpenHashMap<GLBackendFormat> FORMATS = new Int2ObjectOpenHashMap(24, 0.5f);
    private final int mFormat;

    GLBackendFormat(@NativeType(value="GLenum") int format) {
        this.mFormat = format;
    }

    @Nonnull
    public static GLBackendFormat make(@NativeType(value="GLenum") int format) {
        if (GLUtil.glFormatIsSupported(format)) {
            assert (format > 0);
            return (GLBackendFormat)FORMATS.computeIfAbsent(format, GLBackendFormat::new);
        }
        return new GLBackendFormat(format);
    }

    @Override
    public int getBackend() {
        return 0;
    }

    @Override
    public int getGLFormat() {
        return this.mFormat;
    }

    @Override
    public int getChannelFlags() {
        return GLUtil.glFormatChannels(this.mFormat);
    }

    @Override
    public boolean isSRGB() {
        return GLUtil.glFormatIsSRGB(this.mFormat);
    }

    @Override
    public int getCompressionType() {
        return GLUtil.glFormatCompressionType(this.mFormat);
    }

    @Override
    public int getBytesPerBlock() {
        return GLUtil.glFormatBytesPerBlock(this.mFormat);
    }

    @Override
    public int getDepthBits() {
        return GLUtil.glFormatDepthBits(this.mFormat);
    }

    @Override
    public int getStencilBits() {
        return GLUtil.glFormatStencilBits(this.mFormat);
    }

    @Override
    public int getFormatKey() {
        return this.mFormat;
    }

    public int hashCode() {
        return this.mFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.mFormat == ((GLBackendFormat)o).mFormat;
    }

    public String toString() {
        return "{mBackend=OpenGL, mFormat=" + GLUtil.glFormatName(this.mFormat) + "}";
    }
}

