/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.opengl;

import javax.annotation.Nonnull;
import yslelf.cloudpick.render.engine.BackendRenderTarget;
import yslelf.cloudpick.render.opengl.GLBackendFormat;
import yslelf.cloudpick.render.opengl.GLFramebufferInfo;

public final class GLBackendRenderTarget
extends BackendRenderTarget {
    private final int mSampleCount;
    private final int mDepthBits;
    private final int mStencilBits;
    private final GLFramebufferInfo mInfo;
    private GLBackendFormat mBackendFormat;

    public GLBackendRenderTarget(int width, int height, int sampleCount, int depthBits, int stencilBits, GLFramebufferInfo info) {
        super(width, height);
        this.mSampleCount = sampleCount;
        this.mDepthBits = depthBits;
        this.mStencilBits = stencilBits;
        this.mInfo = info;
        assert (sampleCount > 0);
    }

    @Override
    public int getBackend() {
        return 0;
    }

    @Override
    public int getSampleCount() {
        return this.mSampleCount;
    }

    @Override
    public int getDepthBits() {
        return this.mDepthBits;
    }

    @Override
    public int getStencilBits() {
        return this.mStencilBits;
    }

    @Override
    public boolean getGLFramebufferInfo(GLFramebufferInfo info) {
        info.set(this.mInfo);
        return true;
    }

    @Override
    @Nonnull
    public GLBackendFormat getBackendFormat() {
        if (this.mBackendFormat == null) {
            this.mBackendFormat = GLBackendFormat.make(this.mInfo.mFormat);
        }
        return this.mBackendFormat;
    }

    @Override
    public boolean isProtected() {
        return false;
    }
}

