/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.opengl;

import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import yslelf.cloudpick.render.core.MathUtil;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.Buffer;
import yslelf.cloudpick.render.engine.Context;
import yslelf.cloudpick.render.opengl.GLDevice;
import yslelf.cloudpick.render.opengl.GLInterface;

public final class GLBuffer
extends Buffer {
    private volatile int mBuffer;
    private volatile long mPersistentlyMappedBuffer;
    private long mCachedBuffer;
    private long mCachedBufferSize;
    private final boolean mClientUploadBuffer;
    private static final long MAX_BYTES_PER_UPDATE = 262144L;

    private GLBuffer(Context context, long size, int usage, boolean clientUploadBuffer) {
        super(context, size, usage);
        this.mClientUploadBuffer = clientUploadBuffer;
    }

    @Nullable
    @SharedPtr
    public static GLBuffer make(Context context, long size, int usage) {
        boolean clientUploadBuffer;
        assert (size > 0L);
        GLDevice device = (GLDevice)context.getDevice();
        boolean bufferStorage = device.getCaps().hasBufferStorageSupport();
        boolean bl = clientUploadBuffer = !bufferStorage && (usage & 8) != 0;
        if (clientUploadBuffer) {
            long clientBuffer = MemoryUtil.nmemAlloc((long)size);
            if (clientBuffer == 0L) {
                return null;
            }
            assert (MathUtil.isAlign8(clientBuffer));
            GLBuffer buffer = new GLBuffer(context, size, usage, true);
            buffer.mCachedBuffer = clientBuffer;
            buffer.mCachedBufferSize = size;
            return buffer;
        }
        GLBuffer buffer = new GLBuffer(context, size, usage, false);
        if (device.isOnExecutingThread()) {
            if (!buffer.initialize()) {
                buffer.unref();
                return null;
            }
        } else {
            device.executeRenderCall(dev -> {
                if (!buffer.isDestroyed() && !buffer.initialize()) {
                    buffer.setNonCacheable();
                }
            });
        }
        return buffer;
    }

    private boolean initialize() {
        boolean success;
        if (this.mClientUploadBuffer) {
            return true;
        }
        GLDevice device = this.getDevice();
        boolean bufferStorage = device.getCaps().hasBufferStorageSupport();
        boolean dsa = device.getCaps().hasDSASupport();
        int buffer = dsa ? device.getGL().glCreateBuffers() : device.getGL().glGenBuffers();
        if (buffer == 0) {
            return false;
        }
        int target = 0;
        if (!dsa) {
            target = this.getTarget();
            device.getGL().glBindBuffer(target, buffer);
        }
        if (success = bufferStorage ? this.allocate(device, buffer, target, dsa) : this.allocateMutable(device, buffer, target, dsa)) {
            if (!dsa) {
                device.getGL().glBindBuffer(target, 0);
            }
            this.mBuffer = buffer;
        } else {
            device.getGL().glDeleteBuffers(buffer);
        }
        return success;
    }

    public static int getBufferStorageFlags(int usage) {
        int allocFlags;
        if ((usage & 0x10) != 0) {
            allocFlags = 705;
        } else if ((usage & 0x20000) != 0) {
            allocFlags = 194;
            if ((usage & 8) != 0) {
                allocFlags |= 0x200;
            }
        } else if ((usage & 0x10000) != 0) {
            allocFlags = 0;
        } else {
            assert (false);
            allocFlags = 256;
        }
        return allocFlags;
    }

    private boolean allocate(GLDevice device, int buffer, int target, boolean dsa) {
        boolean checkError;
        int allocFlags = GLBuffer.getBufferStorageFlags(this.mUsage);
        boolean bl = checkError = !device.getCaps().skipErrorChecks();
        if (checkError) {
            device.clearErrors();
        }
        if (dsa) {
            device.getGL().glNamedBufferStorage(buffer, this.mSize, 0L, allocFlags);
        } else {
            device.getGL().glBufferStorage(target, this.mSize, 0L, allocFlags);
        }
        if (checkError && device.getError() != 0) {
            device.getLogger().error("Failed to create GLBuffer: cannot allocate {} bytes from device", (Object)this.mSize);
            return false;
        }
        if ((allocFlags & 0x40) != 0) {
            int mapFlags = allocFlags & 0xC3;
            long persistentlyMappedBuffer = dsa ? device.getGL().glMapNamedBufferRange(buffer, 0L, this.mSize, mapFlags) : device.getGL().glMapBufferRange(target, 0L, this.mSize, mapFlags);
            if (persistentlyMappedBuffer == 0L) {
                device.getLogger().error("Failed to create GLBuffer: cannot create persistent mapping");
                return false;
            }
            this.mPersistentlyMappedBuffer = persistentlyMappedBuffer;
        }
        return true;
    }

    public static int getMutableBufferUsage(int usage) {
        int allocUsage;
        if ((usage & 0x10) != 0) {
            allocUsage = 35049;
        } else if ((usage & 0x20000) != 0) {
            allocUsage = (usage & 0x10000) != 0 ? 35048 : 35040;
        } else if ((usage & 0x10000) != 0) {
            allocUsage = 35044;
        } else {
            assert (false);
            allocUsage = 35048;
        }
        return allocUsage;
    }

    private boolean allocateMutable(GLDevice device, int buffer, int target, boolean dsa) {
        boolean checkError;
        int allocUsage = GLBuffer.getMutableBufferUsage(this.mUsage);
        boolean bl = checkError = !device.getCaps().skipErrorChecks();
        if (checkError) {
            device.clearErrors();
        }
        if (dsa) {
            device.getGL().glNamedBufferData(buffer, this.mSize, 0L, allocUsage);
        } else {
            device.getGL().glBufferData(target, this.mSize, 0L, allocUsage);
        }
        if (checkError && device.getError() != 0) {
            device.getLogger().error("Failed to create GLBuffer: cannot allocate {} bytes from device", (Object)this.mSize);
            return false;
        }
        return true;
    }

    public int getHandle() {
        return this.mBuffer;
    }

    public long getClientUploadBuffer() {
        return this.mClientUploadBuffer ? this.mCachedBuffer : 0L;
    }

    public int getTarget() {
        if ((this.mUsage & 0x40) != 0) {
            return 37074;
        }
        if ((this.mUsage & 0x20) != 0) {
            return 35345;
        }
        if ((this.mUsage & 4) != 0) {
            return 36671;
        }
        if ((this.mUsage & 0x10) != 0) {
            return 35051;
        }
        return 34962;
    }

    public int getBindingTarget() {
        if ((this.mUsage & 0x40) != 0) {
            return 37075;
        }
        if ((this.mUsage & 0x20) != 0) {
            return 35368;
        }
        if ((this.mUsage & 4) != 0) {
            return 36675;
        }
        if ((this.mUsage & 0x10) != 0) {
            return 35053;
        }
        return 34964;
    }

    @Override
    protected void onSetLabel(@Nullable String label) {
        this.getDevice().executeRenderCall(dev -> {
            if (dev.getCaps().hasDebugSupport() && !this.mClientUploadBuffer) {
                if (label == null) {
                    dev.getGL().glObjectLabel(33504, this.mBuffer, 0, 0L);
                } else {
                    Object subLabel = "Arc3D_BUF_" + label;
                    subLabel = ((String)subLabel).substring(0, Math.min(((String)subLabel).length(), dev.getCaps().maxLabelLength()));
                    dev.getGL().glObjectLabel(33504, this.mBuffer, (CharSequence)subLabel);
                }
            }
        });
    }

    @Override
    protected void onRelease() {
        this.getDevice().executeRenderCall(dev -> {
            if (this.mBuffer != 0) {
                dev.getGL().glDeleteBuffers(this.mBuffer);
            }
            this.mBuffer = 0;
        });
        if (this.mCachedBuffer != 0L) {
            MemoryUtil.nmemFree((long)this.mCachedBuffer);
        }
        this.mCachedBuffer = 0L;
    }

    @Override
    protected GLDevice getDevice() {
        return (GLDevice)super.getDevice();
    }

    @Override
    protected long onMap(int mode, long offset, long size) {
        GLDevice device = this.getDevice();
        if (mode == 0) {
            long mappedBuffer;
            if (this.mBuffer == 0) {
                return 0L;
            }
            assert (this.mBuffer != 0);
            assert (device.isOnExecutingThread());
            if (device.getCaps().hasDSASupport()) {
                mappedBuffer = device.getGL().glMapNamedBufferRange(this.mBuffer, offset, size, 1);
            } else {
                int target = this.getTarget();
                device.getGL().glBindBuffer(target, this.mBuffer);
                mappedBuffer = device.getGL().glMapBufferRange(target, offset, size, 1);
                device.getGL().glBindBuffer(target, 0);
            }
            if (mappedBuffer == 0L) {
                device.getLogger().error("Failed to map buffer {}", (Object)this.mBuffer);
            }
            return mappedBuffer;
        }
        assert (mode == 1);
        if (this.mPersistentlyMappedBuffer != 0L) {
            return this.mPersistentlyMappedBuffer + offset;
        }
        if (this.mCachedBuffer == 0L || this.mCachedBufferSize < size) {
            this.mCachedBuffer = this.mCachedBuffer == 0L ? MemoryUtil.nmemAlloc((long)size) : MemoryUtil.nmemRealloc((long)this.mCachedBuffer, (long)size);
            this.mCachedBufferSize = size;
            if (this.mCachedBuffer == 0L) {
                device.getLogger().error("Failed to map buffer {}", (Object)this);
            }
        }
        return this.mCachedBuffer;
    }

    @Override
    protected void onUnmap(int mode, long offset, long size) {
        GLDevice device = this.getDevice();
        if (mode == 0) {
            if (this.mBuffer == 0) {
                return;
            }
            assert (this.mBuffer != 0);
            assert (device.isOnExecutingThread());
            if (device.getCaps().hasDSASupport()) {
                device.getGL().glUnmapNamedBuffer(this.mBuffer);
            } else {
                int target = this.getTarget();
                device.getGL().glBindBuffer(target, this.mBuffer);
                device.getGL().glUnmapBuffer(target);
                device.getGL().glBindBuffer(target, 0);
            }
        } else {
            assert (mode == 1);
            if (this.mPersistentlyMappedBuffer != 0L && this.mCachedBuffer == 0L || this.mClientUploadBuffer) {
                return;
            }
            if (size == 0L) {
                return;
            }
            device.executeRenderCall(dev -> {
                if (this.mBuffer == 0) {
                    return;
                }
                if (this.mPersistentlyMappedBuffer != 0L) {
                    if (this.mCachedBuffer != 0L) {
                        MemoryUtil.memCopy((long)this.mCachedBuffer, (long)(this.mPersistentlyMappedBuffer + offset), (long)size);
                        MemoryUtil.nmemFree((long)this.mCachedBuffer);
                        this.mCachedBuffer = 0L;
                    }
                } else if (this.mCachedBuffer != 0L) {
                    int target = dev.getCaps().hasDSASupport() ? 0 : this.getTarget();
                    GLBuffer.doUploadData(dev, this.mBuffer, target, this.mCachedBuffer, offset, size);
                }
            });
        }
    }

    public static void doUploadData(GLDevice device, int buffer, int target, long data, long offset, long totalSize) {
        GLInterface gl = device.getGL();
        if (target == 0) {
            while (totalSize > 0L) {
                long size = Math.min(262144L, totalSize);
                gl.glNamedBufferSubData(buffer, offset, size, data);
                data += size;
                offset += size;
                totalSize -= size;
            }
        } else {
            gl.glBindBuffer(target, buffer);
            while (totalSize > 0L) {
                long size = Math.min(262144L, totalSize);
                gl.glBufferSubData(target, offset, size, data);
                data += size;
                offset += size;
                totalSize -= size;
            }
        }
    }
}

