/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.opengl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.lwjgl.system.NativeType;
import yslelf.cloudpick.render.core.ColorInfo;
import yslelf.cloudpick.render.core.MathUtil;
import yslelf.cloudpick.render.engine.BackendFormat;
import yslelf.cloudpick.render.engine.Caps;
import yslelf.cloudpick.render.engine.ContextOptions;
import yslelf.cloudpick.render.engine.DataUtils;
import yslelf.cloudpick.render.engine.DriverBugWorkarounds;
import yslelf.cloudpick.render.engine.GpuRenderTarget;
import yslelf.cloudpick.render.engine.IResourceKey;
import yslelf.cloudpick.render.engine.ImageDesc;
import yslelf.cloudpick.render.engine.PipelineDesc;
import yslelf.cloudpick.render.engine.PipelineKey;
import yslelf.cloudpick.render.engine.RenderPassDesc;
import yslelf.cloudpick.render.engine.Swizzle;
import yslelf.cloudpick.render.engine.trash.GraphicsPipelineDesc_Old;
import yslelf.cloudpick.render.engine.trash.PipelineKey_old;
import yslelf.cloudpick.render.opengl.GLBackendFormat;
import yslelf.cloudpick.render.opengl.GLGraphicsPipelineKey;
import yslelf.cloudpick.render.opengl.GLImage;
import yslelf.cloudpick.render.opengl.GLImageDesc;
import yslelf.cloudpick.render.opengl.GLUtil;

public abstract class GLCaps
extends Caps {
    public static final List<String> MISSING_EXTENSIONS = new ArrayList<String>();
    GLUtil.GLVendor mVendor;
    GLUtil.GLDriver mDriver;
    int mMaxFragmentUniformVectors;
    float mMaxTextureMaxAnisotropy = 1.0f;
    boolean mSupportsProtected = false;
    boolean mSkipErrorChecks = false;
    int mMaxLabelLength;
    boolean mDebugSupport;
    boolean mBufferStorageSupport;
    boolean mDrawElementsBaseVertexSupport;
    boolean mBaseInstanceSupport;
    boolean mVertexAttribBindingSupport;
    boolean mProgramBinarySupport;
    boolean mProgramParameterSupport;
    boolean mCopyImageSupport;
    boolean mDSASupport;
    boolean mSPIRVSupport = false;
    boolean mViewCompatibilityClassSupport = false;
    boolean mTexStorageSupport;
    boolean mInvalidateFramebufferSupport;
    final boolean mVolatileContext;
    int[] mProgramBinaryFormats;
    public static final int INVALIDATE_BUFFER_TYPE_NULL_DATA = 1;
    public static final int INVALIDATE_BUFFER_TYPE_INVALIDATE = 2;
    int mInvalidateBufferType;
    int mGLSLVersion;
    final FormatInfo[] mFormatTable = new FormatInfo[17];
    private final int[] mColorTypeToBackendFormat = new int[26];
    private final GLBackendFormat[] mCompressionTypeToBackendFormat = new GLBackendFormat[4];

    GLCaps(ContextOptions options) {
        super(options);
        MISSING_EXTENSIONS.clear();
        this.mVolatileContext = options.mVolatileContext;
        this.mDepthClipNegativeOneToOne = true;
    }

    void initFormatTable(boolean texStorageSupported, boolean EXT_texture_compression_s3tc) {
        int nonMSAARenderFlags = 2;
        int msaaRenderFlags = 6;
        this.mFormatTable[0] = new FormatInfo();
        int format = 32856;
        FormatInfo info = this.mFormatTable[1] = new FormatInfo();
        assert (this.getFormatInfo(32856) == info && GLUtil.glIndexToFormat(1) == 32856);
        info.mFormatType = 1;
        info.mInternalFormatForRenderbuffer = 32856;
        info.mDefaultExternalFormat = 6408;
        info.mDefaultExternalType = 5121;
        info.mDefaultColorType = 6;
        info.mFlags = 17;
        info.mFlags |= 6;
        if (texStorageSupported) {
            info.mFlags |= 8;
        }
        info.mInternalFormatForTexture = 32856;
        info.mColorTypeInfos = new ColorTypeInfo[3];
        ColorTypeInfo ctInfo = info.mColorTypeInfos[0] = new ColorTypeInfo();
        ctInfo.mColorType = 6;
        ctInfo.mFlags = 3;
        this.setColorTypeFormat(6, 32856);
        ctInfo.mExternalIOFormats = new ExternalIOFormat[2];
        ExternalIOFormat ioFormat = ctInfo.mExternalIOFormats[0] = new ExternalIOFormat();
        ioFormat.mColorType = 6;
        ioFormat.mExternalType = 5121;
        ioFormat.mExternalTexImageFormat = 6408;
        ioFormat.mExternalReadFormat = 6408;
        ioFormat = ctInfo.mExternalIOFormats[1] = new ExternalIOFormat();
        ioFormat.mColorType = 7;
        ioFormat.mExternalType = 5121;
        ioFormat.mExternalTexImageFormat = 32993;
        ioFormat.mExternalReadFormat = 32993;
        ctInfo = info.mColorTypeInfos[1] = new ColorTypeInfo();
        ctInfo.mColorType = 7;
        ctInfo.mFlags = 3;
        this.setColorTypeFormat(7, 32856);
        ctInfo.mExternalIOFormats = new ExternalIOFormat[2];
        ioFormat = ctInfo.mExternalIOFormats[0] = new ExternalIOFormat();
        ioFormat.mColorType = 7;
        ioFormat.mExternalType = 5121;
        ioFormat.mExternalTexImageFormat = 32993;
        ioFormat.mExternalReadFormat = 32993;
        ioFormat = ctInfo.mExternalIOFormats[1] = new ExternalIOFormat();
        ioFormat.mColorType = 6;
        ioFormat.mExternalType = 5121;
        ioFormat.mExternalTexImageFormat = 0;
        ioFormat.mExternalReadFormat = 6408;
        ctInfo = info.mColorTypeInfos[2] = new ColorTypeInfo();
        ctInfo.mColorType = 5;
        ctInfo.mFlags = 1;
        ctInfo.mReadSwizzle = (short)21008;
        ctInfo.mExternalIOFormats = new ExternalIOFormat[1];
        ioFormat = ctInfo.mExternalIOFormats[0] = new ExternalIOFormat();
        ioFormat.mColorType = 5;
        ioFormat.mExternalType = 5121;
        ioFormat.mExternalTexImageFormat = 6408;
        ioFormat.mExternalReadFormat = 6408;
        FormatInfo info2 = this.mFormatTable[2] = new FormatInfo();
        info2.mFormatType = 1;
        info2.mInternalFormatForRenderbuffer = 33321;
        info2.mDefaultExternalFormat = 6403;
        info2.mDefaultExternalType = 5121;
        info2.mDefaultColorType = 2;
        info2.mFlags = 17;
        info2.mFlags |= 6;
        if (texStorageSupported) {
            info2.mFlags |= 8;
        }
        info2.mInternalFormatForTexture = 33321;
        info2.mColorTypeInfos = new ColorTypeInfo[3];
        ColorTypeInfo ctInfo2 = info2.mColorTypeInfos[0] = new ColorTypeInfo();
        ctInfo2.mColorType = 2;
        ctInfo2.mFlags = 3;
        this.setColorTypeFormat(2, 33321);
        ctInfo2.mExternalIOFormats = new ExternalIOFormat[1];
        ExternalIOFormat ioFormat2 = ctInfo2.mExternalIOFormats[0] = new ExternalIOFormat();
        ioFormat2.mColorType = 2;
        ioFormat2.mExternalType = 5121;
        ioFormat2.mExternalTexImageFormat = 6403;
        ioFormat2.mExternalReadFormat = 6403;
        ctInfo2 = info2.mColorTypeInfos[1] = new ColorTypeInfo();
        ctInfo2.mColorType = 19;
        ctInfo2.mFlags = 3;
        ctInfo2.mReadSwizzle = Swizzle.make("000r");
        ctInfo2.mWriteSwizzle = Swizzle.make("a000");
        this.setColorTypeFormat(19, 33321);
        ctInfo2.mExternalIOFormats = new ExternalIOFormat[1];
        ioFormat2 = ctInfo2.mExternalIOFormats[0] = new ExternalIOFormat();
        ioFormat2.mColorType = 19;
        ioFormat2.mExternalType = 5121;
        ioFormat2.mExternalTexImageFormat = 6403;
        ioFormat2.mExternalReadFormat = 6403;
        ctInfo2 = info2.mColorTypeInfos[2] = new ColorTypeInfo();
        ctInfo2.mColorType = 22;
        ctInfo2.mFlags = 1;
        ctInfo2.mReadSwizzle = Swizzle.make("rrr1");
        this.setColorTypeFormat(22, 33321);
        ctInfo2.mExternalIOFormats = new ExternalIOFormat[1];
        ioFormat2 = ctInfo2.mExternalIOFormats[0] = new ExternalIOFormat();
        ioFormat2.mColorType = 22;
        ioFormat2.mExternalType = 5121;
        ioFormat2.mExternalTexImageFormat = 6403;
        ioFormat2.mExternalReadFormat = 6403;
        info2 = this.mFormatTable[3] = new FormatInfo();
        info2.mFormatType = 1;
        info2.mInternalFormatForRenderbuffer = 36194;
        info2.mDefaultExternalFormat = 6407;
        info2.mDefaultExternalType = 33635;
        info2.mDefaultColorType = 1;
        if (texStorageSupported) {
            info2.mFlags |= 8;
        }
        info2.mInternalFormatForTexture = 36194;
        info2.mColorTypeInfos = new ColorTypeInfo[1];
        ctInfo2 = info2.mColorTypeInfos[0] = new ColorTypeInfo();
        ctInfo2.mColorType = 1;
        ctInfo2.mFlags = 3;
        this.setColorTypeFormat(1, 36194);
        ctInfo2.mExternalIOFormats = new ExternalIOFormat[2];
        ioFormat2 = ctInfo2.mExternalIOFormats[0] = new ExternalIOFormat();
        ioFormat2.mColorType = 1;
        ioFormat2.mExternalType = 33635;
        ioFormat2.mExternalTexImageFormat = 6407;
        ioFormat2.mExternalReadFormat = 6407;
        ioFormat2 = ctInfo2.mExternalIOFormats[1] = new ExternalIOFormat();
        ioFormat2.mColorType = 6;
        ioFormat2.mExternalType = 5121;
        ioFormat2.mExternalTexImageFormat = 0;
        ioFormat2.mExternalReadFormat = 6408;
        info2 = this.mFormatTable[4] = new FormatInfo();
        info2.mFormatType = 2;
        info2.mInternalFormatForRenderbuffer = 34842;
        info2.mDefaultExternalFormat = 6408;
        info2.mDefaultExternalType = 5131;
        info2.mDefaultColorType = 16;
        info2.mFlags = 17;
        info2.mFlags |= 6;
        if (texStorageSupported) {
            info2.mFlags |= 8;
        }
        info2.mInternalFormatForTexture = 34842;
        info2.mColorTypeInfos = new ColorTypeInfo[2];
        ctInfo2 = info2.mColorTypeInfos[0] = new ColorTypeInfo();
        ctInfo2.mColorType = 16;
        ctInfo2.mFlags = 3;
        this.setColorTypeFormat(16, 34842);
        ctInfo2.mExternalIOFormats = new ExternalIOFormat[2];
        ioFormat2 = ctInfo2.mExternalIOFormats[0] = new ExternalIOFormat();
        ioFormat2.mColorType = 16;
        ioFormat2.mExternalType = 5131;
        ioFormat2.mExternalTexImageFormat = 6408;
        ioFormat2.mExternalReadFormat = 6408;
        ioFormat2 = ctInfo2.mExternalIOFormats[1] = new ExternalIOFormat();
        ioFormat2.mColorType = 18;
        ioFormat2.mExternalType = 5126;
        ioFormat2.mExternalTexImageFormat = 0;
        ioFormat2.mExternalReadFormat = 6408;
        ctInfo2 = info2.mColorTypeInfos[1] = new ColorTypeInfo();
        ctInfo2.mColorType = 17;
        ctInfo2.mFlags = 3;
        this.setColorTypeFormat(17, 34842);
        ctInfo2.mExternalIOFormats = new ExternalIOFormat[2];
        ioFormat2 = ctInfo2.mExternalIOFormats[0] = new ExternalIOFormat();
        ioFormat2.mColorType = 17;
        ioFormat2.mExternalType = 5131;
        ioFormat2.mExternalTexImageFormat = 6408;
        ioFormat2.mExternalReadFormat = 6408;
        ioFormat2 = ctInfo2.mExternalIOFormats[1] = new ExternalIOFormat();
        ioFormat2.mColorType = 18;
        ioFormat2.mExternalType = 5126;
        ioFormat2.mExternalTexImageFormat = 0;
        ioFormat2.mExternalReadFormat = 6408;
        info2 = this.mFormatTable[5] = new FormatInfo();
        info2.mFormatType = 2;
        info2.mInternalFormatForRenderbuffer = 33325;
        info2.mDefaultExternalFormat = 6403;
        info2.mDefaultExternalType = 5131;
        info2.mDefaultColorType = 12;
        info2.mFlags = 17;
        info2.mFlags |= 6;
        if (texStorageSupported) {
            info2.mFlags |= 8;
        }
        info2.mInternalFormatForTexture = 33325;
        info2.mColorTypeInfos = new ColorTypeInfo[1];
        ctInfo2 = info2.mColorTypeInfos[0] = new ColorTypeInfo();
        ctInfo2.mColorType = 21;
        ctInfo2.mFlags = 3;
        ctInfo2.mReadSwizzle = Swizzle.make("000r");
        ctInfo2.mWriteSwizzle = Swizzle.make("a000");
        this.setColorTypeFormat(21, 33325);
        ctInfo2.mExternalIOFormats = new ExternalIOFormat[1];
        ioFormat2 = ctInfo2.mExternalIOFormats[0] = new ExternalIOFormat();
        ioFormat2.mColorType = 21;
        ioFormat2.mExternalType = 5131;
        ioFormat2.mExternalTexImageFormat = 6403;
        ioFormat2.mExternalReadFormat = 6403;
        info2 = this.mFormatTable[6] = new FormatInfo();
        info2.mFormatType = 1;
        info2.mInternalFormatForRenderbuffer = 32849;
        info2.mDefaultExternalFormat = 6407;
        info2.mDefaultExternalType = 5121;
        info2.mDefaultColorType = 4;
        info2.mFlags = 17;
        if (texStorageSupported) {
            info2.mFlags |= 8;
        }
        info2.mInternalFormatForTexture = 32849;
        info2.mColorTypeInfos = new ColorTypeInfo[1];
        ctInfo2 = info2.mColorTypeInfos[0] = new ColorTypeInfo();
        ctInfo2.mColorType = 4;
        ctInfo2.mFlags = 3;
        this.setColorTypeFormat(4, 32849);
        ctInfo2.mExternalIOFormats = new ExternalIOFormat[2];
        ioFormat2 = ctInfo2.mExternalIOFormats[0] = new ExternalIOFormat();
        ioFormat2.mColorType = 4;
        ioFormat2.mExternalType = 5121;
        ioFormat2.mExternalTexImageFormat = 6407;
        ioFormat2.mExternalReadFormat = 6407;
        ioFormat2 = ctInfo2.mExternalIOFormats[1] = new ExternalIOFormat();
        ioFormat2.mColorType = 6;
        ioFormat2.mExternalType = 5121;
        ioFormat2.mExternalTexImageFormat = 0;
        ioFormat2.mExternalReadFormat = 6408;
        info2 = this.mFormatTable[7] = new FormatInfo();
        info2.mFormatType = 1;
        info2.mInternalFormatForRenderbuffer = 33323;
        info2.mDefaultExternalFormat = 33319;
        info2.mDefaultExternalType = 5121;
        info2.mDefaultColorType = 3;
        info2.mFlags = 17;
        info2.mFlags |= 6;
        if (texStorageSupported) {
            info2.mFlags |= 8;
        }
        info2.mInternalFormatForTexture = 33323;
        info2.mColorTypeInfos = new ColorTypeInfo[2];
        ctInfo2 = info2.mColorTypeInfos[0] = new ColorTypeInfo();
        ctInfo2.mColorType = 3;
        ctInfo2.mFlags = 3;
        this.setColorTypeFormat(3, 33323);
        ctInfo2.mExternalIOFormats = new ExternalIOFormat[2];
        ioFormat2 = ctInfo2.mExternalIOFormats[0] = new ExternalIOFormat();
        ioFormat2.mColorType = 3;
        ioFormat2.mExternalType = 5121;
        ioFormat2.mExternalTexImageFormat = 33319;
        ioFormat2.mExternalReadFormat = 33319;
        ioFormat2 = ctInfo2.mExternalIOFormats[1] = new ExternalIOFormat();
        ioFormat2.mColorType = 6;
        ioFormat2.mExternalType = 5121;
        ioFormat2.mExternalTexImageFormat = 0;
        ioFormat2.mExternalReadFormat = 6408;
        ctInfo2 = info2.mColorTypeInfos[1] = new ColorTypeInfo();
        ctInfo2.mColorType = 23;
        ctInfo2.mFlags = 1;
        ctInfo2.mReadSwizzle = Swizzle.make("rrrg");
        this.setColorTypeFormat(23, 33323);
        ctInfo2.mExternalIOFormats = new ExternalIOFormat[1];
        ioFormat2 = ctInfo2.mExternalIOFormats[0] = new ExternalIOFormat();
        ioFormat2.mColorType = 23;
        ioFormat2.mExternalType = 5121;
        ioFormat2.mExternalTexImageFormat = 33319;
        ioFormat2.mExternalReadFormat = 33319;
        info2 = this.mFormatTable[8] = new FormatInfo();
        info2.mFormatType = 1;
        info2.mInternalFormatForRenderbuffer = 32857;
        info2.mDefaultExternalFormat = 6408;
        info2.mDefaultExternalType = 33640;
        info2.mDefaultColorType = 9;
        info2.mFlags = 17;
        info2.mFlags |= 6;
        if (texStorageSupported) {
            info2.mFlags |= 8;
        }
        info2.mInternalFormatForTexture = 32857;
        info2.mColorTypeInfos = new ColorTypeInfo[2];
        ctInfo2 = info2.mColorTypeInfos[0] = new ColorTypeInfo();
        ctInfo2.mColorType = 9;
        ctInfo2.mFlags = 3;
        this.setColorTypeFormat(9, 32857);
        ctInfo2.mExternalIOFormats = new ExternalIOFormat[2];
        ioFormat2 = ctInfo2.mExternalIOFormats[0] = new ExternalIOFormat();
        ioFormat2.mColorType = 9;
        ioFormat2.mExternalType = 33640;
        ioFormat2.mExternalTexImageFormat = 6408;
        ioFormat2.mExternalReadFormat = 6408;
        ioFormat2 = ctInfo2.mExternalIOFormats[1] = new ExternalIOFormat();
        ioFormat2.mColorType = 6;
        ioFormat2.mExternalType = 5121;
        ioFormat2.mExternalTexImageFormat = 0;
        ioFormat2.mExternalReadFormat = 6408;
        ctInfo2 = info2.mColorTypeInfos[1] = new ColorTypeInfo();
        ctInfo2.mColorType = 10;
        ctInfo2.mFlags = 3;
        this.setColorTypeFormat(10, 32857);
        ctInfo2.mExternalIOFormats = new ExternalIOFormat[2];
        ioFormat2 = ctInfo2.mExternalIOFormats[0] = new ExternalIOFormat();
        ioFormat2.mColorType = 10;
        ioFormat2.mExternalType = 33640;
        ioFormat2.mExternalTexImageFormat = 32993;
        ioFormat2.mExternalReadFormat = 32993;
        ioFormat2 = ctInfo2.mExternalIOFormats[1] = new ExternalIOFormat();
        ioFormat2.mColorType = 6;
        ioFormat2.mExternalType = 5121;
        ioFormat2.mExternalTexImageFormat = 0;
        ioFormat2.mExternalReadFormat = 6408;
        info2 = this.mFormatTable[9] = new FormatInfo();
        info2.mFormatType = 1;
        info2.mInternalFormatForRenderbuffer = 35907;
        info2.mDefaultExternalFormat = 6408;
        info2.mDefaultExternalType = 5121;
        info2.mDefaultColorType = 8;
        info2.mFlags = 17;
        info2.mFlags |= 6;
        if (texStorageSupported) {
            info2.mFlags |= 8;
        }
        info2.mInternalFormatForTexture = 35907;
        info2.mColorTypeInfos = new ColorTypeInfo[1];
        ctInfo2 = info2.mColorTypeInfos[0] = new ColorTypeInfo();
        ctInfo2.mColorType = 8;
        ctInfo2.mFlags = 3;
        this.setColorTypeFormat(8, 35907);
        ctInfo2.mExternalIOFormats = new ExternalIOFormat[1];
        ioFormat2 = ctInfo2.mExternalIOFormats[0] = new ExternalIOFormat();
        ioFormat2.mColorType = 8;
        ioFormat2.mExternalType = 5121;
        ioFormat2.mExternalTexImageFormat = 6408;
        ioFormat2.mExternalReadFormat = 6408;
        info2 = this.mFormatTable[10] = new FormatInfo();
        info2.mFormatType = 1;
        info2.mInternalFormatForTexture = 37492;
        this.mCompressionTypeToBackendFormat[1] = GLBackendFormat.make(37492);
        info2 = this.mFormatTable[11] = new FormatInfo();
        info2.mFormatType = 1;
        info2.mInternalFormatForTexture = 33776;
        if (EXT_texture_compression_s3tc) {
            info2.mFlags = 1;
            this.mCompressionTypeToBackendFormat[2] = GLBackendFormat.make(33776);
        }
        info2 = this.mFormatTable[12] = new FormatInfo();
        info2.mFormatType = 1;
        info2.mInternalFormatForTexture = 33777;
        if (EXT_texture_compression_s3tc) {
            info2.mFlags = 1;
            this.mCompressionTypeToBackendFormat[3] = GLBackendFormat.make(33777);
        }
        info2 = this.mFormatTable[13] = new FormatInfo();
        info2.mFormatType = 1;
        info2.mInternalFormatForRenderbuffer = 33322;
        info2.mDefaultExternalFormat = 6403;
        info2.mDefaultExternalType = 5123;
        info2.mDefaultColorType = 11;
        info2.mFlags = 17;
        info2.mFlags |= 6;
        if (texStorageSupported) {
            info2.mFlags |= 8;
        }
        info2.mInternalFormatForTexture = 33322;
        info2.mColorTypeInfos = new ColorTypeInfo[1];
        ctInfo2 = info2.mColorTypeInfos[0] = new ColorTypeInfo();
        ctInfo2.mColorType = 20;
        ctInfo2.mFlags = 3;
        ctInfo2.mReadSwizzle = Swizzle.make("000r");
        ctInfo2.mWriteSwizzle = Swizzle.make("a000");
        this.setColorTypeFormat(20, 33322);
        ctInfo2.mExternalIOFormats = new ExternalIOFormat[1];
        ioFormat2 = ctInfo2.mExternalIOFormats[0] = new ExternalIOFormat();
        ioFormat2.mColorType = 20;
        ioFormat2.mExternalType = 5123;
        ioFormat2.mExternalTexImageFormat = 6403;
        ioFormat2.mExternalReadFormat = 6403;
        info2 = this.mFormatTable[14] = new FormatInfo();
        info2.mFormatType = 1;
        info2.mInternalFormatForRenderbuffer = 33324;
        info2.mDefaultExternalFormat = 33319;
        info2.mDefaultExternalType = 5123;
        info2.mDefaultColorType = 13;
        info2.mFlags = 17;
        info2.mFlags |= 6;
        if (texStorageSupported) {
            info2.mFlags |= 8;
        }
        info2.mInternalFormatForTexture = 33324;
        info2.mColorTypeInfos = new ColorTypeInfo[1];
        ctInfo2 = info2.mColorTypeInfos[0] = new ColorTypeInfo();
        ctInfo2.mColorType = 13;
        ctInfo2.mFlags = 3;
        this.setColorTypeFormat(13, 33324);
        ctInfo2.mExternalIOFormats = new ExternalIOFormat[2];
        ioFormat2 = ctInfo2.mExternalIOFormats[0] = new ExternalIOFormat();
        ioFormat2.mColorType = 13;
        ioFormat2.mExternalType = 5123;
        ioFormat2.mExternalTexImageFormat = 33319;
        ioFormat2.mExternalReadFormat = 33319;
        ioFormat2 = ctInfo2.mExternalIOFormats[1] = new ExternalIOFormat();
        ioFormat2.mColorType = 6;
        ioFormat2.mExternalType = 5121;
        ioFormat2.mExternalTexImageFormat = 0;
        ioFormat2.mExternalReadFormat = 6408;
        info2 = this.mFormatTable[15] = new FormatInfo();
        info2.mFormatType = 1;
        info2.mInternalFormatForRenderbuffer = 32859;
        info2.mDefaultExternalFormat = 6408;
        info2.mDefaultExternalType = 5123;
        info2.mDefaultColorType = 15;
        info2.mFlags = 17;
        info2.mFlags |= 6;
        if (texStorageSupported) {
            info2.mFlags |= 8;
        }
        info2.mInternalFormatForTexture = 32859;
        info2.mColorTypeInfos = new ColorTypeInfo[1];
        ctInfo2 = info2.mColorTypeInfos[0] = new ColorTypeInfo();
        ctInfo2.mColorType = 15;
        ctInfo2.mFlags = 3;
        this.setColorTypeFormat(15, 32859);
        ctInfo2.mExternalIOFormats = new ExternalIOFormat[2];
        ioFormat2 = ctInfo2.mExternalIOFormats[0] = new ExternalIOFormat();
        ioFormat2.mColorType = 15;
        ioFormat2.mExternalType = 5123;
        ioFormat2.mExternalTexImageFormat = 6408;
        ioFormat2.mExternalReadFormat = 6408;
        ioFormat2 = ctInfo2.mExternalIOFormats[1] = new ExternalIOFormat();
        ioFormat2.mColorType = 6;
        ioFormat2.mExternalType = 5121;
        ioFormat2.mExternalTexImageFormat = 0;
        ioFormat2.mExternalReadFormat = 6408;
        info2 = this.mFormatTable[16] = new FormatInfo();
        info2.mFormatType = 2;
        info2.mInternalFormatForRenderbuffer = 33327;
        info2.mDefaultExternalFormat = 33319;
        info2.mDefaultExternalType = 5131;
        info2.mDefaultColorType = 14;
        info2.mFlags = 17;
        info2.mFlags |= 6;
        if (texStorageSupported) {
            info2.mFlags |= 8;
        }
        info2.mInternalFormatForTexture = 33327;
        info2.mColorTypeInfos = new ColorTypeInfo[1];
        ctInfo2 = info2.mColorTypeInfos[0] = new ColorTypeInfo();
        ctInfo2.mColorType = 14;
        ctInfo2.mFlags = 3;
        this.setColorTypeFormat(14, 33327);
        ctInfo2.mExternalIOFormats = new ExternalIOFormat[2];
        ioFormat2 = ctInfo2.mExternalIOFormats[0] = new ExternalIOFormat();
        ioFormat2.mColorType = 14;
        ioFormat2.mExternalType = 5131;
        ioFormat2.mExternalTexImageFormat = 33319;
        ioFormat2.mExternalReadFormat = 33319;
        ioFormat2 = ctInfo2.mExternalIOFormats[1] = new ExternalIOFormat();
        ioFormat2.mColorType = 18;
        ioFormat2.mExternalType = 5126;
        ioFormat2.mExternalTexImageFormat = 0;
        ioFormat2.mExternalReadFormat = 6408;
    }

    boolean validateFormatTable() {
        for (int index = 1; index < this.mFormatTable.length; ++index) {
            FormatInfo info = this.mFormatTable[index];
            if ((info.mFlags & 4) != 0 && (info.mFlags & 2) == 0) assert (false);
            if ((info.mFlags & 2) != 0 && (info.mFlags & 1) == 0) assert (false);
            if (info.mFormatType == 0) assert (false);
            if ((info.mFlags & 1) != 0 && info.mInternalFormatForTexture == 0) assert (false);
            if ((info.mFlags & 2) != 0 && info.mInternalFormatForRenderbuffer == 0) assert (false);
            for (ColorTypeInfo ctInfo : info.mColorTypeInfos) {
                if (ctInfo.mColorType == 0) assert (false);
                if (ctInfo.mFlags == 0) assert (false);
                for (ExternalIOFormat ioInfo : ctInfo.mExternalIOFormats) {
                    if (ioInfo.mColorType == 0) assert (false);
                }
            }
        }
        return true;
    }

    void applyDriverWorkaround() {
        DriverBugWorkarounds workarounds = this.mDriverBugWorkarounds;
    }

    FormatInfo getFormatInfo(@NativeType(value="GLenum") int format) {
        return this.mFormatTable[GLUtil.glFormatToIndex(format)];
    }

    private void setColorTypeFormat(int colorType, int format) {
        assert (GLUtil.glFormatIsSupported(format));
        this.mColorTypeToBackendFormat[colorType] = format;
    }

    public GLUtil.GLVendor getVendor() {
        return this.mVendor;
    }

    public GLUtil.GLDriver getDriver() {
        return this.mDriver;
    }

    public abstract boolean isGLES();

    public boolean hasDSASupport() {
        return this.mDSASupport;
    }

    public int getInvalidateBufferType() {
        return this.mInvalidateBufferType;
    }

    public boolean hasDebugSupport() {
        return this.mDebugSupport;
    }

    public boolean hasDrawElementsBaseVertexSupport() {
        return this.mDrawElementsBaseVertexSupport;
    }

    public boolean hasBaseInstanceSupport() {
        return this.mBaseInstanceSupport;
    }

    public boolean hasVertexAttribBindingSupport() {
        return this.mVertexAttribBindingSupport;
    }

    public boolean hasCopyImageSupport() {
        return this.mCopyImageSupport;
    }

    public boolean hasBufferStorageSupport() {
        return this.mBufferStorageSupport;
    }

    public boolean hasSPIRVSupport() {
        return this.mSPIRVSupport;
    }

    public boolean hasProgramBinarySupport() {
        return this.mProgramBinarySupport;
    }

    public boolean hasVolatileContext() {
        return this.mVolatileContext;
    }

    public boolean hasInvalidateFramebufferSupport() {
        return this.mInvalidateFramebufferSupport;
    }

    @Nullable
    public int[] getProgramBinaryFormats() {
        return this.mProgramBinarySupport ? (int[])this.mProgramBinaryFormats.clone() : null;
    }

    public int getGLSLVersion() {
        return this.mGLSLVersion;
    }

    @Override
    public boolean isFormatTexturable(BackendFormat format) {
        return this.isFormatTexturable(format.getGLFormat());
    }

    public boolean isFormatTexturable(int format) {
        return (this.getFormatInfo((int)format).mFlags & 1) != 0;
    }

    public boolean isTextureStorageCompatible(int format) {
        return (this.getFormatInfo((int)format).mFlags & 8) != 0;
    }

    @Override
    public int getMaxRenderTargetSampleCount(BackendFormat format) {
        return this.getMaxRenderTargetSampleCount(format.getGLFormat());
    }

    public int getMaxRenderTargetSampleCount(int format) {
        int[] table = this.getFormatInfo((int)format).mColorSampleCounts;
        if (table.length == 0) {
            return 0;
        }
        return table[table.length - 1];
    }

    @Override
    public boolean isFormatRenderable(int colorType, BackendFormat format, int sampleCount) {
        if (format.isExternal()) {
            return false;
        }
        int f2 = format.getGLFormat();
        if ((this.getFormatInfo(f2).colorTypeFlags(colorType) & 2) == 0) {
            return false;
        }
        return this.isFormatRenderable(f2, sampleCount);
    }

    @Override
    public boolean isFormatRenderable(BackendFormat format, int sampleCount) {
        if (format.isExternal()) {
            return false;
        }
        return this.isFormatRenderable(format.getGLFormat(), sampleCount);
    }

    public boolean isFormatRenderable(int format, int sampleCount) {
        return sampleCount <= this.getMaxRenderTargetSampleCount(format);
    }

    @Override
    public int getRenderTargetSampleCount(int sampleCount, BackendFormat format) {
        return this.getRenderTargetSampleCount(sampleCount, format.getGLFormat());
    }

    public int getRenderTargetSampleCount(int sampleCount, int format) {
        FormatInfo formatInfo = this.getFormatInfo(format);
        if (formatInfo.mColorTypeInfos.length == 0) {
            return 0;
        }
        if (sampleCount <= 1) {
            return formatInfo.mColorSampleCounts[0] == 1 ? 1 : 0;
        }
        for (int count : formatInfo.mColorSampleCounts) {
            if (count < sampleCount) continue;
            return count;
        }
        return 0;
    }

    @Override
    @Nullable
    public ImageDesc getDefaultColorImageDesc(int imageType, int colorType, int width, int height, int depthOrArraySize, int mipLevelCount, int sampleCount, int imageFlags) {
        int target;
        int arraySize;
        int depth;
        if (width < 1 || height < 1 || depthOrArraySize < 1 || mipLevelCount < 0 || sampleCount < 0) {
            return null;
        }
        int format = this.mColorTypeToBackendFormat[colorType];
        FormatInfo formatInfo = this.getFormatInfo(format);
        if ((imageFlags & 0x80) != 0) {
            return null;
        }
        switch (imageType) {
            case 5: {
                depth = depthOrArraySize;
                arraySize = 1;
                break;
            }
            case 2: 
            case 4: {
                depth = 1;
                arraySize = depthOrArraySize;
                break;
            }
            default: {
                arraySize = 1;
                depth = 1;
            }
        }
        if ((imageFlags & 0x18) != 0) {
            maxSize = this.maxTextureSize();
            if (width > maxSize || height > maxSize || !formatInfo.isTexturable()) {
                return null;
            }
            target = 3553;
        } else if ((imageFlags & 0x20) != 0) {
            maxSize = this.maxRenderTargetSize();
            if (width > maxSize || height > maxSize) {
                return null;
            }
            target = 36161;
        } else {
            return null;
        }
        int maxMipLevels = DataUtils.computeMipLevelCount(width, height, depth);
        mipLevelCount = mipLevelCount == 0 ? ((imageFlags & 4) != 0 ? maxMipLevels : 1) : Math.min(mipLevelCount, maxMipLevels);
        if ((imageFlags & 0x20) != 0) {
            if ((formatInfo.colorTypeFlags(colorType) & 2) == 0) {
                return null;
            }
            if ((sampleCount = this.getRenderTargetSampleCount(sampleCount, format)) == 0) {
                return null;
            }
        } else {
            sampleCount = 1;
        }
        if (sampleCount > 1 && mipLevelCount > 1) {
            return null;
        }
        return new GLImageDesc(target, format, width, height, depth, arraySize, mipLevelCount, sampleCount, imageFlags);
    }

    @Override
    @Nullable
    public ImageDesc getDefaultDepthStencilImageDesc(int depthBits, int stencilBits, int width, int height, int sampleCount, int imageFlags) {
        if (depthBits < 0 || depthBits > 32) {
            return null;
        }
        if (stencilBits < 0 || stencilBits > 8) {
            return null;
        }
        depthBits = MathUtil.align8(depthBits);
        stencilBits = MathUtil.align8(stencilBits);
        int depthStencilFormat = 0;
        if (stencilBits == 8) {
            switch (depthBits) {
                case 0: {
                    depthStencilFormat = 36168;
                    break;
                }
                case 8: 
                case 16: 
                case 24: {
                    depthStencilFormat = 35056;
                    break;
                }
                case 32: {
                    depthStencilFormat = 36013;
                }
            }
        } else {
            assert (stencilBits == 0);
            switch (depthBits) {
                case 8: 
                case 16: {
                    depthStencilFormat = 33189;
                    break;
                }
                case 24: {
                    depthStencilFormat = 33190;
                    break;
                }
                case 32: {
                    depthStencilFormat = 36012;
                }
            }
        }
        if (depthStencilFormat == 0) {
            assert (depthBits == 0);
            return null;
        }
        return new GLImageDesc(36161, depthStencilFormat, width, height, 1, 1, 1, sampleCount, imageFlags);
    }

    @Override
    @Nullable
    public ImageDesc getImageDescForSampledCopy(ImageDesc src, int width, int height, int depthOrArraySize, int imageFlags) {
        if (!(src instanceof GLImageDesc)) {
            return null;
        }
        GLImageDesc glSrc = (GLImageDesc)src;
        int maxSize = this.maxTextureSize();
        if (width > maxSize || height > maxSize) {
            return null;
        }
        int maxMipLevels = DataUtils.computeMipLevelCount(width, height, 1);
        int mipLevelCount = (imageFlags & 4) != 0 ? maxMipLevels : 1;
        return new GLImageDesc(3553, glSrc.getGLFormat(), width, height, 1, 1, mipLevelCount, 1, imageFlags | 8);
    }

    @Override
    public boolean onFormatCompatible(int colorType, BackendFormat format) {
        FormatInfo formatInfo = this.getFormatInfo(format.getGLFormat());
        for (ColorTypeInfo info : formatInfo.mColorTypeInfos) {
            if (info.mColorType != colorType) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    protected BackendFormat onGetDefaultBackendFormat(int colorType) {
        return null;
    }

    @Override
    @Nullable
    public BackendFormat getCompressedBackendFormat(int compressionType) {
        return this.mCompressionTypeToBackendFormat[compressionType];
    }

    @Override
    @Nonnull
    public PipelineKey_old makeDesc(PipelineKey_old desc, GpuRenderTarget renderTarget, GraphicsPipelineDesc_Old graphicsPipelineDesc) {
        return PipelineKey_old.build(desc, graphicsPipelineDesc, this);
    }

    @Override
    @Nonnull
    public PipelineKey makeGraphicsPipelineKey(PipelineKey old, PipelineDesc pipelineDesc, RenderPassDesc renderPassDesc) {
        if (old instanceof GLGraphicsPipelineKey) {
            GLGraphicsPipelineKey pipelineKey = (GLGraphicsPipelineKey)old;
            pipelineKey.mPipelineDesc = pipelineDesc;
            return pipelineKey;
        }
        GLGraphicsPipelineKey pipelineKey = new GLGraphicsPipelineKey();
        pipelineKey.mPipelineDesc = pipelineDesc;
        return pipelineKey;
    }

    @Override
    protected short onGetReadSwizzle(ImageDesc desc, int colorType) {
        FormatInfo formatInfo = this.getFormatInfo(desc.getGLFormat());
        for (ColorTypeInfo ctInfo : formatInfo.mColorTypeInfos) {
            if (ctInfo.mColorType != colorType) continue;
            return ctInfo.mReadSwizzle;
        }
        assert (false);
        return 12816;
    }

    @Override
    public short getWriteSwizzle(ImageDesc desc, int colorType) {
        FormatInfo formatInfo = this.getFormatInfo(desc.getGLFormat());
        for (ColorTypeInfo ctInfo : formatInfo.mColorTypeInfos) {
            if (ctInfo.mColorType != colorType) continue;
            return ctInfo.mWriteSwizzle;
        }
        assert (false);
        return 12816;
    }

    @Override
    public IResourceKey computeImageKey(ImageDesc desc, IResourceKey recycle) {
        if (desc instanceof GLImageDesc) {
            GLImageDesc glDesc = (GLImageDesc)desc;
            return new GLImage.ResourceKey(glDesc);
        }
        return null;
    }

    @Override
    public long getSupportedWriteColorType(int dstColorType, ImageDesc dstDesc, int srcColorType) {
        int fallbackCT = 0;
        FormatInfo formatInfo = this.getFormatInfo(dstDesc.getGLFormat());
        boolean foundSurfaceCT = false;
        long transferOffsetAlignment = 0L;
        if ((formatInfo.mFlags & 0x10) != 0) {
            transferOffsetAlignment = 1L;
        }
        for (int i = 0; !foundSurfaceCT && i < formatInfo.mColorTypeInfos.length; ++i) {
            if (formatInfo.mColorTypeInfos[i].mColorType != dstColorType) continue;
            ColorTypeInfo ctInfo = formatInfo.mColorTypeInfos[i];
            foundSurfaceCT = true;
            for (ExternalIOFormat ioInfo : ctInfo.mExternalIOFormats) {
                if (ioInfo.mExternalTexImageFormat == 0) continue;
                if (ioInfo.mColorType == srcColorType) {
                    return (long)srcColorType | transferOffsetAlignment << 32;
                }
                if (fallbackCT != 0) continue;
                fallbackCT = ioInfo.mColorType;
            }
        }
        return (long)fallbackCT | transferOffsetAlignment << 32;
    }

    public static int getExternalTypeAlignment(int type) {
        return switch (type) {
            case 5120, 5121, 32818, 33634 -> 1;
            case 5122, 5123, 5131, 32819, 32820, 33635, 33636, 33637, 33638 -> 2;
            case 5124, 5125, 5126, 32821, 32822, 33639, 33640, 34042, 35899, 35902, 36269 -> 4;
            default -> 0;
        };
    }

    @Override
    protected long onSupportedReadColorType(int srcColorType, BackendFormat srcFormat, int dstColorType) {
        int compression = srcFormat.getCompressionType();
        if (compression != 0) {
            return DataUtils.compressionTypeIsOpaque(compression) ? 5 : 6;
        }
        int fallbackColorType = 0;
        long fallbackTransferOffsetAlignment = 0L;
        FormatInfo formatInfo = this.getFormatInfo(srcFormat.getGLFormat());
        for (ColorTypeInfo ctInfo : formatInfo.mColorTypeInfos) {
            if (ctInfo.mColorType != srcColorType) continue;
            for (ExternalIOFormat ioInfo : ctInfo.mExternalIOFormats) {
                if (ioInfo.mExternalReadFormat == 0) continue;
                long transferOffsetAlignment = 0L;
                if ((formatInfo.mFlags & 0x10) != 0) {
                    transferOffsetAlignment = GLCaps.getExternalTypeAlignment(ioInfo.mExternalType);
                }
                if (ioInfo.mColorType == dstColorType) {
                    return (long)dstColorType | transferOffsetAlignment << 32;
                }
                if (fallbackColorType != 0) continue;
                fallbackColorType = ioInfo.mColorType;
                fallbackTransferOffsetAlignment = transferOffsetAlignment;
            }
            break;
        }
        return (long)fallbackColorType | fallbackTransferOffsetAlignment << 32;
    }

    @Override
    protected void onApplyOptionsOverrides(ContextOptions options) {
        super.onApplyOptionsOverrides(options);
        this.mSkipErrorChecks = options.mSkipGLErrorChecks == Boolean.FALSE ? false : (options.mSkipGLErrorChecks == Boolean.TRUE ? true : this.mDriver == GLUtil.GLDriver.NVIDIA);
    }

    public int getTextureInternalFormat(int format) {
        return this.getFormatInfo((int)format).mInternalFormatForTexture;
    }

    public int getRenderbufferInternalFormat(int format) {
        return this.getFormatInfo((int)format).mInternalFormatForRenderbuffer;
    }

    public int getFormatDefaultExternalFormat(int format) {
        return this.getFormatInfo((int)format).mDefaultExternalFormat;
    }

    public int getFormatDefaultExternalType(int format) {
        return this.getFormatInfo((int)format).mDefaultExternalType;
    }

    public int getPixelsExternalFormat(int format, int dstColorType, int srcColorType, boolean write) {
        return this.getFormatInfo(format).externalFormat(dstColorType, srcColorType, write);
    }

    public int getPixelsExternalType(int format, int dstColorType, int srcColorType) {
        return this.getFormatInfo(format).externalType(dstColorType, srcColorType);
    }

    public boolean canCopyImage(@NativeType(value="GLenum") int srcFormat, int srcSampleCount, @NativeType(value="GLenum") int dstFormat, int dstSampleCount) {
        if (!this.mCopyImageSupport) {
            return false;
        }
        if ((dstSampleCount > 1 || srcSampleCount > 1) && dstSampleCount != srcSampleCount) {
            return false;
        }
        if (srcFormat == dstFormat) {
            return true;
        }
        if (this.mViewCompatibilityClassSupport) {
            return this.getFormatInfo((int)srcFormat).mViewCompatibilityClass == this.getFormatInfo((int)dstFormat).mViewCompatibilityClass;
        }
        return false;
    }

    public boolean canCopyTexSubImage(@NativeType(value="GLenum") int srcFormat, @NativeType(value="GLenum") int dstFormat) {
        if (this.getFormatDefaultExternalType(dstFormat) != this.getFormatDefaultExternalType(srcFormat)) {
            return false;
        }
        if (GLUtil.glFormatIsSRGB(dstFormat) != GLUtil.glFormatIsSRGB(srcFormat)) {
            return false;
        }
        return (this.getFormatInfo((int)srcFormat).mFlags & 2) != 0;
    }

    public boolean skipErrorChecks() {
        return this.mSkipErrorChecks;
    }

    public int maxLabelLength() {
        return this.mMaxLabelLength;
    }

    public float maxTextureMaxAnisotropy() {
        return this.mMaxTextureMaxAnisotropy;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("GLCaps:\n");
        this.dump(b, true);
        return b.toString();
    }

    public void dump(StringBuilder out, boolean includeFormatTable) {
        int i;
        out.append("AnisotropySupport: ").append(this.mAnisotropySupport).append('\n');
        out.append("GpuTracingSupport: ").append(this.mGpuTracingSupport).append('\n');
        out.append("ConservativeRasterSupport: ").append(this.mConservativeRasterSupport).append('\n');
        out.append("TextureBarrierSupport: ").append(this.mTextureBarrierSupport).append('\n');
        out.append("DepthClipNegativeOneToOne: ").append(this.mDepthClipNegativeOneToOne).append('\n');
        out.append("BlendEquationSupport: ").append((Object)this.mBlendEquationSupport).append('\n');
        out.append("ClampToBorderSupport: ").append(this.mClampToBorderSupport).append('\n');
        out.append("MaxRenderTargetSize: ").append(this.mMaxRenderTargetSize).append('\n');
        out.append("MaxPreferredRenderTargetSize: ").append(this.mMaxPreferredRenderTargetSize).append('\n');
        out.append("MaxVertexAttributes: ").append(this.mMaxVertexAttributes).append('\n');
        out.append("MaxVertexBindings: ").append(this.mMaxVertexBindings).append('\n');
        out.append("MaxTextureSize: ").append(this.mMaxTextureSize).append('\n');
        out.append("MaxPushConstantsSize: ").append(this.mMaxPushConstantsSize).append('\n');
        out.append("MaxColorAttachments: ").append(this.mMaxColorAttachments).append('\n');
        out.append("MinUniformBufferOffsetAlignment: ").append(this.mMinUniformBufferOffsetAlignment).append('\n');
        out.append("MinStorageBufferOffsetAlignment: ").append(this.mMinStorageBufferOffsetAlignment).append('\n');
        out.append("ShaderCaps:\n");
        this.mShaderCaps.dump("\t", out);
        out.append("Vendor: ").append((Object)this.mVendor).append('\n');
        out.append("Driver: ").append((Object)this.mDriver).append('\n');
        out.append("MaxFragmentUniformVectors: ").append(this.mMaxFragmentUniformVectors).append('\n');
        out.append("MaxTextureMaxAnisotropy: ").append(this.mMaxTextureMaxAnisotropy).append('\n');
        out.append("SupportsProtected: ").append(this.mSupportsProtected).append('\n');
        out.append("SkipErrorChecks: ").append(this.mSkipErrorChecks).append('\n');
        out.append("MaxLabelLength: ").append(this.mMaxLabelLength).append('\n');
        out.append("DebugSupport: ").append(this.mDebugSupport).append('\n');
        out.append("BufferStorageSupport: ").append(this.mBufferStorageSupport).append('\n');
        out.append("DrawElementsBaseVertexSupport: ").append(this.mDrawElementsBaseVertexSupport).append('\n');
        out.append("BaseInstanceSupport: ").append(this.mBaseInstanceSupport).append('\n');
        out.append("DSASupport: ").append(this.mDSASupport).append('\n');
        out.append("InvalidateBufferType: ").append(this.mInvalidateBufferType).append('\n');
        out.append("InvalidateFramebufferSupport: ").append(this.mInvalidateFramebufferSupport).append('\n');
        out.append("VertexAttribBindingSupport: ").append(this.mVertexAttribBindingSupport).append('\n');
        out.append("CopyImageSupport: ").append(this.mCopyImageSupport).append('\n');
        out.append("SPIRVSupport: ").append(this.mSPIRVSupport).append('\n');
        out.append("ViewCompatibilityClassSupport: ").append(this.mViewCompatibilityClassSupport).append('\n');
        out.append("TexStorageSupport: ").append(this.mTexStorageSupport).append('\n');
        out.append("ProgramBinarySupport: ").append(this.mProgramBinarySupport).append('\n');
        out.append("ProgramBinaryFormats: ").append(Arrays.toString(this.mProgramBinaryFormats)).append('\n');
        out.append("GLSLVersion: ").append(this.mGLSLVersion).append('\n');
        out.append("ColorTypeToBackendFormat:\n");
        for (i = 0; i < this.mColorTypeToBackendFormat.length; ++i) {
            out.append('\t').append(ColorInfo.colorTypeToString(i)).append("=>").append(GLUtil.glFormatName(this.mColorTypeToBackendFormat[i])).append('\n');
        }
        out.append("CompressionTypeToBackendFormat: ").append(Arrays.toString(this.mCompressionTypeToBackendFormat)).append('\n');
        if (includeFormatTable) {
            out.append("FormatTable:\n");
            for (i = 1; i < this.mFormatTable.length; ++i) {
                out.append('\t').append(GLUtil.glFormatName(GLUtil.glIndexToFormat(i))).append("=>\n");
                this.mFormatTable[i].dump("\t\t", out);
            }
        }
    }

    static class FormatInfo {
        static final int TEXTURABLE_FLAG = 1;
        static final int COLOR_ATTACHMENT_FLAG = 2;
        static final int COLOR_ATTACHMENT_WITH_MSAA_FLAG = 4;
        static final int TEXTURE_STORAGE_FLAG = 8;
        static final int TRANSFERS_FLAG = 16;
        int mFlags = 0;
        static final int FORMAT_TYPE_UNKNOWN = 0;
        static final int FORMAT_TYPE_NORMALIZED_FIXED_POINT = 1;
        static final int FORMAT_TYPE_FLOAT = 2;
        int mFormatType = 0;
        int mInternalFormatForTexture = 0;
        int mInternalFormatForRenderbuffer = 0;
        int mDefaultExternalFormat = 0;
        int mDefaultExternalType = 0;
        int mDefaultColorType = 0;
        int mViewCompatibilityClass = 0;
        int[] mColorSampleCounts = new int[0];
        ColorTypeInfo[] mColorTypeInfos = new ColorTypeInfo[0];

        FormatInfo() {
        }

        public boolean isTexturable() {
            return (this.mFlags & 1) != 0;
        }

        public int colorTypeFlags(int colorType) {
            for (ColorTypeInfo info : this.mColorTypeInfos) {
                if (info.mColorType != colorType) continue;
                return info.mFlags;
            }
            return 0;
        }

        public int externalFormat(int dstColorType, int srcColorType, boolean write) {
            for (ColorTypeInfo info : this.mColorTypeInfos) {
                if (info.mColorType != dstColorType) continue;
                return info.externalFormat(srcColorType, write);
            }
            return 0;
        }

        public int externalType(int dstColorType, int srcColorType) {
            for (ColorTypeInfo info : this.mColorTypeInfos) {
                if (info.mColorType != dstColorType) continue;
                return info.externalType(srcColorType);
            }
            return 0;
        }

        public String toString() {
            StringBuilder b = new StringBuilder("FormatInfo:\n");
            this.dump("", b);
            return b.toString();
        }

        void dump(String prefix, StringBuilder out) {
            out.append(prefix).append("Flags: 0x").append(Integer.toHexString(this.mFlags)).append('\n');
            out.append(prefix).append("FormatType: ").append(this.mFormatType).append('\n');
            out.append(prefix).append("InternalFormatForTexture: ").append(this.mInternalFormatForTexture).append('\n');
            out.append(prefix).append("InternalFormatForRenderbuffer: ").append(this.mInternalFormatForRenderbuffer).append('\n');
            out.append(prefix).append("DefaultExternalFormat: ").append(this.mDefaultExternalFormat).append('\n');
            out.append(prefix).append("DefaultExternalType: ").append(this.mDefaultExternalType).append('\n');
            out.append(prefix).append("DefaultColorType: ").append(ColorInfo.colorTypeToString(this.mDefaultColorType)).append('\n');
            out.append(prefix).append("ColorSampleCounts: ").append(Arrays.toString(this.mColorSampleCounts)).append('\n');
            for (int i = 0; i < this.mColorTypeInfos.length; ++i) {
                out.append(prefix).append("ColorTypeInfo[").append(i).append("]:\n");
                this.mColorTypeInfos[i].dump(prefix + "\t", out);
            }
        }
    }

    static class ColorTypeInfo {
        int mColorType = 0;
        static final int kUploadData_Flag = 1;
        static final int kRenderable_Flag = 2;
        int mFlags = 0;
        short mReadSwizzle = (short)12816;
        short mWriteSwizzle = (short)12816;
        ExternalIOFormat[] mExternalIOFormats;

        ColorTypeInfo() {
        }

        public int externalFormat(int srcColorType, boolean write) {
            for (ExternalIOFormat ioFormat : this.mExternalIOFormats) {
                if (ioFormat.mColorType != srcColorType) continue;
                if (write) {
                    return ioFormat.mExternalTexImageFormat;
                }
                return ioFormat.mExternalReadFormat;
            }
            return 0;
        }

        public int externalType(int srcColorType) {
            for (ExternalIOFormat ioFormat : this.mExternalIOFormats) {
                if (ioFormat.mColorType != srcColorType) continue;
                return ioFormat.mExternalType;
            }
            return 0;
        }

        public String toString() {
            StringBuilder b = new StringBuilder("ColorTypeInfo:\n");
            this.dump("", b);
            return b.toString();
        }

        void dump(String prefix, StringBuilder out) {
            out.append(prefix).append("ColorType: ").append(ColorInfo.colorTypeToString(this.mColorType)).append('\n');
            out.append(prefix).append("Flags: 0x").append(Integer.toHexString(this.mFlags)).append('\n');
            out.append(prefix).append("ReadSwizzle: ").append(Swizzle.toString(this.mReadSwizzle)).append('\n');
            out.append(prefix).append("WriteSwizzle: ").append(Swizzle.toString(this.mWriteSwizzle)).append('\n');
            for (int i = 0; i < this.mExternalIOFormats.length; ++i) {
                out.append(prefix).append("ExternalIOFormat[").append(i).append("]:\n");
                this.mExternalIOFormats[i].dump(prefix + "\t", out);
            }
        }
    }

    static class ExternalIOFormat {
        int mColorType = 0;
        int mExternalType = 0;
        int mExternalTexImageFormat = 0;
        int mExternalReadFormat = 0;

        ExternalIOFormat() {
        }

        public String toString() {
            StringBuilder b = new StringBuilder("ExternalIOFormat:\n");
            this.dump("", b);
            return b.toString();
        }

        void dump(String prefix, StringBuilder out) {
            out.append(prefix).append("ColorType: ").append(ColorInfo.colorTypeToString(this.mColorType)).append('\n');
            out.append(prefix).append("ExternalType: 0x").append(Integer.toHexString(this.mExternalType)).append('\n');
            out.append(prefix).append("ExternalTexImageFormat: 0x").append(Integer.toHexString(this.mExternalTexImageFormat)).append('\n');
            out.append(prefix).append("ExternalReadFormat: 0x").append(Integer.toHexString(this.mExternalReadFormat)).append('\n');
        }
    }
}

