/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.opengl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Objects;
import javax.annotation.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.lwjgl.opengl.ARBGLSPIRV;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL13C;
import org.lwjgl.opengl.GL14C;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.opengl.GL31C;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.opengl.GL41C;
import org.lwjgl.opengl.GL42C;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.opengl.GL44C;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.opengl.GL46C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.NVTextureBarrier;
import org.lwjgl.system.MemoryStack;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;
import yslelf.cloudpick.render.compiler.GLSLVersion;
import yslelf.cloudpick.render.compiler.SPIRVVersion;
import yslelf.cloudpick.render.compiler.TargetApi;
import yslelf.cloudpick.render.engine.Caps;
import yslelf.cloudpick.render.engine.ContextOptions;
import yslelf.cloudpick.render.engine.ShaderCaps;
import yslelf.cloudpick.render.opengl.GLCaps;
import yslelf.cloudpick.render.opengl.GLInterface;
import yslelf.cloudpick.render.opengl.GLUtil;

public final class GLCaps_GL
extends GLCaps
implements GLInterface {
    private final boolean mShaderBinarySupport;
    private boolean mTextureBarrierNV;
    private boolean mSpecializeShaderARB;

    @VisibleForTesting
    public GLCaps_GL(ContextOptions options, Object capabilities) {
        super(options);
        int count;
        int glslVersion;
        GLCapabilities caps = (GLCapabilities)capabilities;
        if (!caps.OpenGL33) {
            throw new UnsupportedOperationException("OpenGL 3.3 is unavailable");
        }
        Logger logger = (Logger)Objects.requireNonNullElse(options.mLogger, NOPLogger.NOP_LOGGER);
        if (caps.OpenGL41 || !caps.GL_ARB_viewport_array) {
            // empty if block
        }
        if (caps.OpenGL44 || !caps.GL_ARB_clear_texture) {
            // empty if block
        }
        if (caps.OpenGL45 || caps.GL_ARB_texture_barrier) {
            this.mTextureBarrierSupport = true;
            this.mTextureBarrierNV = false;
        } else if (caps.GL_NV_texture_barrier) {
            this.mTextureBarrierSupport = true;
            this.mTextureBarrierNV = true;
            logger.info("Use NV_texture_barrier");
        } else {
            this.mTextureBarrierSupport = false;
        }
        this.mDebugSupport = caps.OpenGL43 || caps.GL_KHR_debug;
        this.mDrawElementsBaseVertexSupport = true;
        this.mBaseInstanceSupport = caps.OpenGL42 || caps.GL_ARB_base_instance;
        this.mCopyImageSupport = caps.OpenGL43 || caps.GL_ARB_copy_image;
        this.mTexStorageSupport = caps.OpenGL42 || caps.GL_ARB_texture_storage;
        this.mViewCompatibilityClassSupport = caps.OpenGL43 || caps.GL_ARB_internalformat_query2;
        this.mShaderBinarySupport = caps.OpenGL41 || caps.GL_ARB_ES2_compatibility;
        this.mProgramParameterSupport = this.mProgramBinarySupport = caps.OpenGL41 || caps.GL_ARB_get_program_binary;
        this.mVertexAttribBindingSupport = caps.OpenGL43 || caps.GL_ARB_vertex_attrib_binding;
        this.mBufferStorageSupport = caps.OpenGL44 || caps.GL_ARB_buffer_storage;
        this.mMaxColorAttachments = Math.min(Math.min(this.glGetInteger(34852), this.glGetInteger(36063)), 8);
        this.mMinUniformBufferOffsetAlignment = this.glGetInteger(35380);
        this.mMinStorageBufferOffsetAlignment = this.glGetInteger(37087);
        String versionString = this.glGetString(7938);
        String vendorString = this.glGetString(7936);
        this.mVendor = GLUtil.findVendor(vendorString);
        this.mDriver = GLUtil.findDriver(this.mVendor, vendorString, versionString);
        logger.info("Identified OpenGL vendor: {}", (Object)this.mVendor);
        logger.info("Identified OpenGL driver: {}", (Object)this.mDriver);
        this.mMaxFragmentUniformVectors = caps.OpenGL41 || caps.GL_ARB_ES2_compatibility ? this.glGetInteger(36349) : this.glGetInteger(35657) / 4;
        this.mMaxVertexAttributes = Math.min(32, this.glGetInteger(34921));
        if (this.mVertexAttribBindingSupport) {
            this.mMaxVertexBindings = Math.min(32, this.glGetInteger(33498));
        }
        if (caps.OpenGL43 || caps.GL_ARB_invalidate_subdata) {
            this.mInvalidateBufferType = 2;
            this.mInvalidateFramebufferSupport = true;
        } else {
            this.mInvalidateBufferType = 1;
            this.mInvalidateFramebufferSupport = false;
        }
        boolean bl = this.mDSASupport = caps.OpenGL45 || caps.GL_ARB_direct_state_access && this.mInvalidateBufferType == 2;
        if (this.mDSASupport && this.mVendor == GLUtil.GLVendor.INTEL) {
            this.mDSASupport = false;
            logger.info("Intel GPU detected, disabling DSA");
        }
        this.mTransferPixelsToRowBytesSupport = true;
        this.mMustSyncGpuDuringDiscard = false;
        this.mMaxLabelLength = this.mDebugSupport ? this.glGetInteger(33512) : 0;
        ShaderCaps shaderCaps = this.mShaderCaps;
        shaderCaps.mTargetApi = caps.OpenGL45 ? TargetApi.OPENGL_4_5 : (caps.OpenGL43 ? TargetApi.OPENGL_4_3 : TargetApi.OPENGL_3_3);
        if (caps.OpenGL46) {
            glslVersion = 460;
            logger.info("Using OpenGL 4.6 and GLSL 4.50");
        } else if (caps.OpenGL45) {
            glslVersion = 450;
            logger.info("Using OpenGL 4.5 and GLSL 4.50");
        } else if (caps.OpenGL44) {
            glslVersion = 440;
            logger.info("Using OpenGL 4.4 and GLSL 4.40");
        } else if (caps.OpenGL43) {
            glslVersion = 430;
            logger.info("Using OpenGL 4.3 and GLSL 4.30");
        } else if (caps.OpenGL42) {
            glslVersion = 420;
            logger.info("Using OpenGL 4.2 and GLSL 4.20");
        } else if (caps.OpenGL41) {
            glslVersion = 410;
            logger.info("Using OpenGL 4.1 and GLSL 4.00");
        } else if (caps.OpenGL40) {
            glslVersion = 400;
            logger.info("Using OpenGL 4.0 and GLSL 4.00");
        } else {
            glslVersion = 330;
            logger.info("Using OpenGL 3.3 and GLSL 3.30");
        }
        this.mGLSLVersion = glslVersion;
        shaderCaps.mGLSLVersion = glslVersion >= 450 ? GLSLVersion.GLSL_450 : (glslVersion == 440 ? GLSLVersion.GLSL_440 : (glslVersion == 430 ? GLSLVersion.GLSL_430 : (glslVersion == 420 ? GLSLVersion.GLSL_420 : (glslVersion >= 400 ? GLSLVersion.GLSL_400 : GLSLVersion.GLSL_330))));
        this.initGLSL(caps, shaderCaps.mGLSLVersion);
        shaderCaps.mDualSourceBlendingSupport = true;
        if (caps.GL_NV_conservative_raster) {
            this.mConservativeRasterSupport = true;
            logger.info("Use NV_conservative_raster");
        }
        shaderCaps.mMaxFragmentSamplers = Math.min(32, this.glGetInteger(34930));
        if (caps.GL_NV_blend_equation_advanced_coherent) {
            this.mBlendEquationSupport = Caps.BlendEquationSupport.ADVANCED_COHERENT;
            shaderCaps.mAdvBlendEqInteraction = 1;
            logger.info("Use NV_blend_equation_advanced_coherent");
        } else if (caps.GL_KHR_blend_equation_advanced_coherent) {
            this.mBlendEquationSupport = Caps.BlendEquationSupport.ADVANCED_COHERENT;
            this.mShaderCaps.mAdvBlendEqInteraction = 2;
            logger.info("Use KHR_blend_equation_advanced_coherent");
        } else if (caps.GL_NV_blend_equation_advanced) {
            this.mBlendEquationSupport = Caps.BlendEquationSupport.ADVANCED;
            this.mShaderCaps.mAdvBlendEqInteraction = 1;
            logger.info("Use NV_blend_equation_advanced");
        } else if (caps.GL_KHR_blend_equation_advanced) {
            this.mBlendEquationSupport = Caps.BlendEquationSupport.ADVANCED;
            this.mShaderCaps.mAdvBlendEqInteraction = 2;
            logger.info("Use KHR_blend_equation_advanced");
        }
        if (caps.OpenGL46 || caps.GL_ARB_texture_filter_anisotropic) {
            this.mAnisotropySupport = true;
        } else if (caps.GL_EXT_texture_filter_anisotropic) {
            this.mAnisotropySupport = true;
            logger.info("Use EXT_texture_filter_anisotropic");
        } else {
            this.mAnisotropySupport = false;
        }
        if (this.mAnisotropySupport) {
            this.mMaxTextureMaxAnisotropy = GL11C.glGetFloat((int)34047);
        }
        this.mMaxTextureSize = this.glGetInteger(3379);
        this.mMaxPreferredRenderTargetSize = this.mMaxRenderTargetSize = this.glGetInteger(34024);
        this.mGpuTracingSupport = caps.GL_EXT_debug_marker;
        if (this.mGpuTracingSupport) {
            logger.info("Use EXT_debug_marker");
        }
        this.mDynamicStateArrayGeometryProcessorTextureSupport = true;
        if (this.mProgramBinarySupport) {
            count = this.glGetInteger(34814);
            if (count > 0) {
                this.mProgramBinaryFormats = new int[count];
                GL11C.glGetIntegerv((int)34815, (int[])this.mProgramBinaryFormats);
            } else {
                this.mProgramBinarySupport = false;
            }
        }
        if (this.mShaderBinarySupport && (caps.OpenGL46 || caps.GL_ARB_gl_spirv) && (count = GL11C.glGetInteger((int)36345)) > 0) {
            int[] shaderBinaryFormats = new int[count];
            GL11C.glGetIntegerv((int)36344, (int[])shaderBinaryFormats);
            for (int format : shaderBinaryFormats) {
                if (format != 38225) continue;
                this.mSPIRVSupport = true;
                this.mSpecializeShaderARB = !caps.OpenGL46;
                break;
            }
        }
        if (this.mSPIRVSupport) {
            shaderCaps.mSPIRVVersion = SPIRVVersion.SPIRV_1_0;
        }
        this.initFormatTable(caps);
        assert (this.validateFormatTable());
        this.applyDriverWorkaround();
        this.finishInitialization(options);
    }

    private void initGLSL(GLCapabilities caps, GLSLVersion version) {
        ShaderCaps shaderCaps = this.mShaderCaps;
        shaderCaps.mPreferFlatInterpolation = true;
        shaderCaps.mNoPerspectiveInterpolationSupport = true;
        shaderCaps.mVertexIDSupport = true;
        shaderCaps.mInfinitySupport = true;
        shaderCaps.mNonConstantArrayIndexSupport = true;
        shaderCaps.mBitManipulationSupport = version.isAtLeast(GLSLVersion.GLSL_400);
        shaderCaps.mFMASupport = version.isAtLeast(GLSLVersion.GLSL_400);
        shaderCaps.mTextureQueryLod = version.isAtLeast(GLSLVersion.GLSL_400);
        shaderCaps.mUseUniformBinding = caps.OpenGL42;
        shaderCaps.mUseVaryingLocation = caps.OpenGL44;
        shaderCaps.mUseBlockMemberOffset = caps.OpenGL44;
        shaderCaps.mUsePrecisionModifiers = false;
    }

    void initFormatTable(GLCapabilities caps) {
        GLCaps.FormatInfo info;
        super.initFormatTable(this.mTexStorageSupport, caps.GL_EXT_texture_compression_s3tc);
        int nonMSAARenderFlags = 2;
        int msaaRenderFlags = 6;
        if (caps.OpenGL42 || caps.GL_ARB_ES2_compatibility) {
            info = this.getFormatInfo(36194);
            info.mFlags |= 0x11;
            info.mFlags |= 6;
        }
        info = this.getFormatInfo(32849);
        info.mFlags = (caps.OpenGL43 || caps.GL_ARB_internalformat_query2) && GL42C.glGetInternalformati((int)36161, (int)32849, (int)33391) == 1 ? (info.mFlags |= 6) : (info.mFlags |= 2);
        if (caps.OpenGL43 || caps.GL_ARB_ES3_compatibility) {
            info = this.getFormatInfo(37492);
            info.mFlags |= 1;
        }
        for (GLCaps.FormatInfo info2 : this.mFormatTable) {
            if (this.mCopyImageSupport && this.mViewCompatibilityClassSupport && info2.mInternalFormatForTexture != 0) {
                info2.mViewCompatibilityClass = GL42C.glGetInternalformati((int)3553, (int)info2.mInternalFormatForTexture, (int)33462);
            }
            if ((info2.mFlags & 4) != 0) {
                int count;
                assert ((info2.mFlags & 2) != 0);
                if (caps.OpenGL42 || caps.GL_ARB_internalformat_query) {
                    int glFormat = info2.mInternalFormatForRenderbuffer;
                    count = GL42C.glGetInternalformati((int)36161, (int)glFormat, (int)37760);
                    if (count <= 0) continue;
                    try (MemoryStack stack = MemoryStack.stackPush();){
                        IntBuffer temp = stack.mallocInt(count);
                        GL42C.glGetInternalformativ((int)36161, (int)glFormat, (int)32937, (IntBuffer)temp);
                        if (temp.get(count - 1) == 1) assert (--count == 0 || temp.get(count - 1) > 1);
                        info2.mColorSampleCounts = new int[count + 1];
                        info2.mColorSampleCounts[0] = 1;
                        for (int j = 0; j < count; ++j) {
                            info2.mColorSampleCounts[j + 1] = temp.get(count - j - 1);
                        }
                        continue;
                    }
                }
                int maxSampleCnt = Math.max(1, GL11C.glGetInteger((int)36183));
                for (count = 5; count > 0 && 1 << count - 1 > maxSampleCnt; --count) {
                }
                if (count <= 0) continue;
                info2.mColorSampleCounts = new int[count];
                for (int i = 0; i < count; ++i) {
                    info2.mColorSampleCounts[i] = 1 << i;
                }
                continue;
            }
            if ((info2.mFlags & 2) == 0) continue;
            info2.mColorSampleCounts = new int[1];
            info2.mColorSampleCounts[0] = 1;
        }
    }

    @Override
    public boolean isGLES() {
        return false;
    }

    @Override
    public void glEnable(int cap) {
        GL11C.glEnable((int)cap);
    }

    @Override
    public void glDisable(int cap) {
        GL11C.glDisable((int)cap);
    }

    @Override
    public void glFrontFace(int mode) {
        GL11C.glFrontFace((int)mode);
    }

    @Override
    public void glLineWidth(float width) {
        GL11C.glLineWidth((float)width);
    }

    @Override
    public int glGenTextures() {
        return GL11C.glGenTextures();
    }

    @Override
    public void glTexParameteri(int target, int pname, int param) {
        GL11C.glTexParameteri((int)target, (int)pname, (int)param);
    }

    @Override
    public void glTexParameteriv(int target, int pname, IntBuffer params) {
        GL11C.glTexParameteriv((int)target, (int)pname, (IntBuffer)params);
    }

    @Override
    public void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, long pixels) {
        GL11C.nglTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (long)pixels);
    }

    @Override
    public void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, long pixels) {
        GL11C.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (long)pixels);
    }

    @Override
    public void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        GL11C.glCopyTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)x, (int)y, (int)width, (int)height);
    }

    @Override
    public void glDeleteTextures(int texture) {
        GL11C.glDeleteTextures((int)texture);
    }

    @Override
    public void glBindTexture(int target, int texture) {
        GL11C.glBindTexture((int)target, (int)texture);
    }

    @Override
    public void glPixelStorei(int pname, int param) {
        GL11C.glPixelStorei((int)pname, (int)param);
    }

    @Override
    public void glBlendFunc(int sfactor, int dfactor) {
        GL11C.glBlendFunc((int)sfactor, (int)dfactor);
    }

    @Override
    public void glColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        GL11C.glColorMask((boolean)red, (boolean)green, (boolean)blue, (boolean)alpha);
    }

    @Override
    public void glDepthFunc(int func) {
        GL11C.glDepthFunc((int)func);
    }

    @Override
    public void glDepthMask(boolean flag) {
        GL11C.glDepthMask((boolean)flag);
    }

    @Override
    public void glStencilOp(int sfail, int dpfail, int dppass) {
        GL11C.glStencilOp((int)sfail, (int)dpfail, (int)dppass);
    }

    @Override
    public void glStencilFunc(int func, int ref, int mask) {
        GL11C.glStencilFunc((int)func, (int)ref, (int)mask);
    }

    @Override
    public void glStencilMask(int mask) {
        GL11C.glStencilMask((int)mask);
    }

    @Override
    public void glDrawArrays(int mode, int first, int count) {
        GL11C.glDrawArrays((int)mode, (int)first, (int)count);
    }

    @Override
    public void glDrawElements(int mode, int count, int type, long indices) {
        GL11C.nglDrawElements((int)mode, (int)count, (int)type, (long)indices);
    }

    @Override
    public void glFlush() {
        GL11C.glFlush();
    }

    @Override
    public void glFinish() {
        GL11C.glFinish();
    }

    @Override
    public int glGetError() {
        return GL11C.glGetError();
    }

    @Override
    @Nullable
    public String glGetString(int name) {
        return GL11C.glGetString((int)name);
    }

    @Override
    public int glGetInteger(int pname) {
        return GL11C.glGetInteger((int)pname);
    }

    @Override
    public void glScissor(int x, int y, int width, int height) {
        GL11C.glScissor((int)x, (int)y, (int)width, (int)height);
    }

    @Override
    public void glViewport(int x, int y, int width, int height) {
        GL11C.glViewport((int)x, (int)y, (int)width, (int)height);
    }

    @Override
    public void glActiveTexture(int texture) {
        GL13C.glActiveTexture((int)texture);
    }

    @Override
    public void glBlendEquation(int mode) {
        GL14C.glBlendEquation((int)mode);
    }

    @Override
    public int glGenBuffers() {
        return GL15C.glGenBuffers();
    }

    @Override
    public void glDeleteBuffers(int buffer) {
        GL15C.glDeleteBuffers((int)buffer);
    }

    @Override
    public void glBindBuffer(int target, int buffer) {
        GL15C.glBindBuffer((int)target, (int)buffer);
    }

    @Override
    public void glBufferData(int target, long size, long data, int usage) {
        GL15C.nglBufferData((int)target, (long)size, (long)data, (int)usage);
    }

    @Override
    public void glBufferSubData(int target, long offset, long size, long data) {
        GL15C.nglBufferSubData((int)target, (long)offset, (long)size, (long)data);
    }

    @Override
    public boolean glUnmapBuffer(int target) {
        return GL15C.glUnmapBuffer((int)target);
    }

    @Override
    public void glDrawBuffers(int[] bufs) {
        GL20C.glDrawBuffers((int[])bufs);
    }

    @Override
    public void glStencilOpSeparate(int face, int sfail, int dpfail, int dppass) {
        GL20C.glStencilOpSeparate((int)face, (int)sfail, (int)dpfail, (int)dppass);
    }

    @Override
    public void glStencilFuncSeparate(int face, int func, int ref, int mask) {
        GL20C.glStencilFuncSeparate((int)face, (int)func, (int)ref, (int)mask);
    }

    @Override
    public void glStencilMaskSeparate(int face, int mask) {
        GL20C.glStencilMaskSeparate((int)face, (int)mask);
    }

    @Override
    public int glCreateProgram() {
        return GL20C.glCreateProgram();
    }

    @Override
    public void glDeleteProgram(int program) {
        GL20C.glDeleteProgram((int)program);
    }

    @Override
    public int glCreateShader(int type) {
        return GL20C.glCreateShader((int)type);
    }

    @Override
    public void glDeleteShader(int shader) {
        GL20C.glDeleteShader((int)shader);
    }

    @Override
    public void glAttachShader(int program, int shader) {
        GL20C.glAttachShader((int)program, (int)shader);
    }

    @Override
    public void glDetachShader(int program, int shader) {
        GL20C.glDetachShader((int)program, (int)shader);
    }

    @Override
    public void glShaderSource(int shader, int count, long strings, long length) {
        GL20C.nglShaderSource((int)shader, (int)count, (long)strings, (long)length);
    }

    @Override
    public void glCompileShader(int shader) {
        GL20C.glCompileShader((int)shader);
    }

    @Override
    public void glLinkProgram(int program) {
        GL20C.glLinkProgram((int)program);
    }

    @Override
    public void glUseProgram(int program) {
        GL20C.glUseProgram((int)program);
    }

    @Override
    public int glGetShaderi(int shader, int pname) {
        return GL20C.glGetShaderi((int)shader, (int)pname);
    }

    @Override
    public int glGetProgrami(int program, int pname) {
        return GL20C.glGetProgrami((int)program, (int)pname);
    }

    @Override
    public String glGetShaderInfoLog(int shader) {
        return GL20C.glGetShaderInfoLog((int)shader);
    }

    @Override
    public String glGetProgramInfoLog(int program) {
        return GL20C.glGetProgramInfoLog((int)program);
    }

    @Override
    public int glGetUniformLocation(int program, CharSequence name) {
        return GL20C.glGetUniformLocation((int)program, (CharSequence)name);
    }

    @Override
    public void glUniform1i(int location, int v0) {
        GL20C.glUniform1i((int)location, (int)v0);
    }

    @Override
    public void glEnableVertexAttribArray(int index) {
        GL20C.glEnableVertexAttribArray((int)index);
    }

    @Override
    public void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, long pointer) {
        GL20C.glVertexAttribPointer((int)index, (int)size, (int)type, (boolean)normalized, (int)stride, (long)pointer);
    }

    @Override
    public void glVertexAttribIPointer(int index, int size, int type, int stride, long pointer) {
        GL30C.glVertexAttribIPointer((int)index, (int)size, (int)type, (int)stride, (long)pointer);
    }

    @Override
    public int glGenVertexArrays() {
        return GL30C.glGenVertexArrays();
    }

    @Override
    public void glDeleteVertexArrays(int array) {
        GL30C.glDeleteVertexArrays((int)array);
    }

    @Override
    public void glBindVertexArray(int array) {
        GL30C.glBindVertexArray((int)array);
    }

    @Override
    public int glGenFramebuffers() {
        return GL30C.glGenFramebuffers();
    }

    @Override
    public void glDeleteFramebuffers(int framebuffer) {
        GL30C.glDeleteFramebuffers((int)framebuffer);
    }

    @Override
    public void glBindFramebuffer(int target, int framebuffer) {
        GL30C.glBindFramebuffer((int)target, (int)framebuffer);
    }

    @Override
    public int glCheckFramebufferStatus(int target) {
        return GL30C.glCheckFramebufferStatus((int)target);
    }

    @Override
    public void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level) {
        GL30C.glFramebufferTexture2D((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
    }

    @Override
    public void glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer) {
        GL30C.glFramebufferRenderbuffer((int)target, (int)attachment, (int)renderbuffertarget, (int)renderbuffer);
    }

    @Override
    public void glBlitFramebuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        GL30C.glBlitFramebuffer((int)srcX0, (int)srcY0, (int)srcX1, (int)srcY1, (int)dstX0, (int)dstY0, (int)dstX1, (int)dstY1, (int)mask, (int)filter);
    }

    @Override
    public void glClearBufferiv(int buffer, int drawbuffer, IntBuffer value) {
        GL30C.glClearBufferiv((int)buffer, (int)drawbuffer, (IntBuffer)value);
    }

    @Override
    public void glClearBufferfv(int buffer, int drawbuffer, FloatBuffer value) {
        GL30C.glClearBufferfv((int)buffer, (int)drawbuffer, (FloatBuffer)value);
    }

    @Override
    public void glClearBufferfi(int buffer, int drawbuffer, float depth, int stencil) {
        GL30C.glClearBufferfi((int)buffer, (int)drawbuffer, (float)depth, (int)stencil);
    }

    @Override
    public void glBindBufferBase(int target, int index, int buffer) {
        GL30C.glBindBufferBase((int)target, (int)index, (int)buffer);
    }

    @Override
    public void glBindBufferRange(int target, int index, int buffer, long offset, long size) {
        GL30C.glBindBufferRange((int)target, (int)index, (int)buffer, (long)offset, (long)size);
    }

    @Override
    public int glGenRenderbuffers() {
        return GL30C.glGenRenderbuffers();
    }

    @Override
    public void glDeleteRenderbuffers(int renderbuffer) {
        GL30C.glDeleteRenderbuffers((int)renderbuffer);
    }

    @Override
    public void glBindRenderbuffer(int target, int renderbuffer) {
        GL30C.glBindRenderbuffer((int)target, (int)renderbuffer);
    }

    @Override
    public void glRenderbufferStorage(int target, int internalformat, int width, int height) {
        GL30C.glRenderbufferStorage((int)target, (int)internalformat, (int)width, (int)height);
    }

    @Override
    public void glRenderbufferStorageMultisample(int target, int samples, int internalformat, int width, int height) {
        GL30C.glRenderbufferStorageMultisample((int)target, (int)samples, (int)internalformat, (int)width, (int)height);
    }

    @Override
    public long glMapBufferRange(int target, long offset, long length, int access) {
        return GL30C.nglMapBufferRange((int)target, (long)offset, (long)length, (int)access);
    }

    @Override
    public void glDrawArraysInstanced(int mode, int first, int count, int instancecount) {
        GL31C.glDrawArraysInstanced((int)mode, (int)first, (int)count, (int)instancecount);
    }

    @Override
    public void glDrawElementsInstanced(int mode, int count, int type, long indices, int instancecount) {
        GL31C.glDrawElementsInstanced((int)mode, (int)count, (int)type, (long)indices, (int)instancecount);
    }

    @Override
    public void glCopyBufferSubData(int readTarget, int writeTarget, long readOffset, long writeOffset, long size) {
        GL31C.glCopyBufferSubData((int)readTarget, (int)writeTarget, (long)readOffset, (long)writeOffset, (long)size);
    }

    @Override
    public int glGetUniformBlockIndex(int program, CharSequence uniformBlockName) {
        return GL31C.glGetUniformBlockIndex((int)program, (CharSequence)uniformBlockName);
    }

    @Override
    public void glUniformBlockBinding(int program, int uniformBlockIndex, int uniformBlockBinding) {
        GL31C.glUniformBlockBinding((int)program, (int)uniformBlockIndex, (int)uniformBlockBinding);
    }

    @Override
    public long glFenceSync(int condition, int flags) {
        return GL32C.glFenceSync((int)condition, (int)flags);
    }

    @Override
    public void glDeleteSync(long sync) {
        GL32C.nglDeleteSync((long)sync);
    }

    @Override
    public int glClientWaitSync(long sync, int flags, long timeout) {
        return GL32C.nglClientWaitSync((long)sync, (int)flags, (long)timeout);
    }

    @Override
    public int glGenSamplers() {
        return GL33C.glGenSamplers();
    }

    @Override
    public void glDeleteSamplers(int sampler) {
        GL33C.glDeleteSamplers((int)sampler);
    }

    @Override
    public void glBindSampler(int unit, int sampler) {
        GL33C.glBindSampler((int)unit, (int)sampler);
    }

    @Override
    public void glSamplerParameteri(int sampler, int pname, int param) {
        GL33C.glSamplerParameteri((int)sampler, (int)pname, (int)param);
    }

    @Override
    public void glSamplerParameterf(int sampler, int pname, float param) {
        GL33C.glSamplerParameterf((int)sampler, (int)pname, (float)param);
    }

    @Override
    public void glVertexAttribDivisor(int index, int divisor) {
        GL33C.glVertexAttribDivisor((int)index, (int)divisor);
    }

    @Override
    public void glDrawElementsBaseVertex(int mode, int count, int type, long indices, int basevertex) {
        GL32C.nglDrawElementsBaseVertex((int)mode, (int)count, (int)type, (long)indices, (int)basevertex);
    }

    @Override
    public void glDrawElementsInstancedBaseVertex(int mode, int count, int type, long indices, int instancecount, int basevertex) {
        GL32C.nglDrawElementsInstancedBaseVertex((int)mode, (int)count, (int)type, (long)indices, (int)instancecount, (int)basevertex);
    }

    @Override
    public void glShaderBinary(IntBuffer shaders, int binaryformat, ByteBuffer binary) {
        assert (this.mShaderBinarySupport);
        GL41C.glShaderBinary((IntBuffer)shaders, (int)binaryformat, (ByteBuffer)binary);
    }

    @Override
    public void glDrawArraysInstancedBaseInstance(int mode, int first, int count, int instancecount, int baseinstance) {
        assert (this.mBaseInstanceSupport);
        GL42C.glDrawArraysInstancedBaseInstance((int)mode, (int)first, (int)count, (int)instancecount, (int)baseinstance);
    }

    @Override
    public void glDrawElementsInstancedBaseVertexBaseInstance(int mode, int count, int type, long indices, int instancecount, int basevertex, int baseinstance) {
        assert (this.mBaseInstanceSupport);
        GL42C.nglDrawElementsInstancedBaseVertexBaseInstance((int)mode, (int)count, (int)type, (long)indices, (int)instancecount, (int)basevertex, (int)baseinstance);
    }

    @Override
    public void glTexStorage2D(int target, int levels, int internalformat, int width, int height) {
        assert (this.mTexStorageSupport);
        GL42C.glTexStorage2D((int)target, (int)levels, (int)internalformat, (int)width, (int)height);
    }

    @Override
    public void glInvalidateBufferSubData(int buffer, long offset, long length) {
        assert (this.mInvalidateBufferType == 2);
        GL43C.glInvalidateBufferSubData((int)buffer, (long)offset, (long)length);
    }

    @Override
    public void glInvalidateFramebuffer(int target, IntBuffer attachments) {
        assert (this.mInvalidateFramebufferSupport);
        GL43C.glInvalidateFramebuffer((int)target, (IntBuffer)attachments);
    }

    @Override
    public void glCopyImageSubData(int srcName, int srcTarget, int srcLevel, int srcX, int srcY, int srcZ, int dstName, int dstTarget, int dstLevel, int dstX, int dstY, int dstZ, int srcWidth, int srcHeight, int srcDepth) {
        assert (this.mCopyImageSupport);
        GL43C.glCopyImageSubData((int)srcName, (int)srcTarget, (int)srcLevel, (int)srcX, (int)srcY, (int)srcZ, (int)dstName, (int)dstTarget, (int)dstLevel, (int)dstX, (int)dstY, (int)dstZ, (int)srcWidth, (int)srcHeight, (int)srcDepth);
    }

    @Override
    public void glObjectLabel(int identifier, int name, int length, long label) {
        assert (this.mDebugSupport);
        GL43C.nglObjectLabel((int)identifier, (int)name, (int)length, (long)label);
    }

    @Override
    public void glObjectLabel(int identifier, int name, CharSequence label) {
        assert (this.mDebugSupport);
        GL43C.glObjectLabel((int)identifier, (int)name, (CharSequence)label);
    }

    @Override
    public void glBindVertexBuffer(int bindingindex, int buffer, long offset, int stride) {
        assert (this.mVertexAttribBindingSupport);
        GL43C.glBindVertexBuffer((int)bindingindex, (int)buffer, (long)offset, (int)stride);
    }

    @Override
    public void glVertexAttribFormat(int attribindex, int size, int type, boolean normalized, int relativeoffset) {
        assert (this.mVertexAttribBindingSupport);
        GL43C.glVertexAttribFormat((int)attribindex, (int)size, (int)type, (boolean)normalized, (int)relativeoffset);
    }

    @Override
    public void glVertexAttribIFormat(int attribindex, int size, int type, int relativeoffset) {
        assert (this.mVertexAttribBindingSupport);
        GL43C.glVertexAttribIFormat((int)attribindex, (int)size, (int)type, (int)relativeoffset);
    }

    @Override
    public void glVertexAttribBinding(int attribindex, int bindingindex) {
        assert (this.mVertexAttribBindingSupport);
        GL43C.glVertexAttribBinding((int)attribindex, (int)bindingindex);
    }

    @Override
    public void glVertexBindingDivisor(int bindingindex, int divisor) {
        assert (this.mVertexAttribBindingSupport);
        GL43C.glVertexBindingDivisor((int)bindingindex, (int)divisor);
    }

    @Override
    public void glBufferStorage(int target, long size, long data, int flags) {
        assert (this.mBufferStorageSupport);
        GL44C.nglBufferStorage((int)target, (long)size, (long)data, (int)flags);
    }

    @Override
    public void glTextureBarrier() {
        assert (this.mTextureBarrierSupport);
        if (this.mTextureBarrierNV) {
            NVTextureBarrier.glTextureBarrierNV();
        } else {
            GL45C.glTextureBarrier();
        }
    }

    @Override
    public int glCreateBuffers() {
        assert (this.mDSASupport);
        return GL45C.glCreateBuffers();
    }

    @Override
    public void glNamedBufferData(int buffer, long size, long data, int usage) {
        assert (this.mDSASupport);
        GL45C.nglNamedBufferData((int)buffer, (long)size, (long)data, (int)usage);
    }

    @Override
    public void glNamedBufferSubData(int buffer, long offset, long size, long data) {
        assert (this.mDSASupport);
        GL45C.nglNamedBufferSubData((int)buffer, (long)offset, (long)size, (long)data);
    }

    @Override
    public long glMapNamedBufferRange(int buffer, long offset, long length, int access) {
        assert (this.mDSASupport);
        return GL45C.nglMapNamedBufferRange((int)buffer, (long)offset, (long)length, (int)access);
    }

    @Override
    public boolean glUnmapNamedBuffer(int buffer) {
        assert (this.mDSASupport);
        return GL45C.glUnmapNamedBuffer((int)buffer);
    }

    @Override
    public void glNamedBufferStorage(int buffer, long size, long data, int flags) {
        assert (this.mDSASupport);
        GL45C.nglNamedBufferStorage((int)buffer, (long)size, (long)data, (int)flags);
    }

    @Override
    public void glCopyNamedBufferSubData(int readBuffer, int writeBuffer, long readOffset, long writeOffset, long size) {
        assert (this.mDSASupport);
        GL45C.glCopyNamedBufferSubData((int)readBuffer, (int)writeBuffer, (long)readOffset, (long)writeOffset, (long)size);
    }

    @Override
    public int glCreateTextures(int target) {
        assert (this.mDSASupport);
        return GL45C.glCreateTextures((int)target);
    }

    @Override
    public void glTextureParameteri(int texture, int pname, int param) {
        assert (this.mDSASupport);
        GL45C.glTextureParameteri((int)texture, (int)pname, (int)param);
    }

    @Override
    public void glTextureParameteriv(int texture, int pname, IntBuffer params) {
        assert (this.mDSASupport);
        GL45C.glTextureParameteriv((int)texture, (int)pname, (IntBuffer)params);
    }

    @Override
    public void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, long pixels) {
        assert (this.mDSASupport);
        GL45C.glTextureSubImage2D((int)texture, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (long)pixels);
    }

    @Override
    public void glTextureStorage2D(int texture, int levels, int internalformat, int width, int height) {
        assert (this.mDSASupport);
        GL45C.glTextureStorage2D((int)texture, (int)levels, (int)internalformat, (int)width, (int)height);
    }

    @Override
    public int glCreateVertexArrays() {
        assert (this.mDSASupport);
        return GL45C.glCreateVertexArrays();
    }

    @Override
    public void glEnableVertexArrayAttrib(int vaobj, int index) {
        assert (this.mDSASupport);
        GL45C.glEnableVertexArrayAttrib((int)vaobj, (int)index);
    }

    @Override
    public void glVertexArrayAttribFormat(int vaobj, int attribindex, int size, int type, boolean normalized, int relativeoffset) {
        assert (this.mDSASupport);
        GL45C.glVertexArrayAttribFormat((int)vaobj, (int)attribindex, (int)size, (int)type, (boolean)normalized, (int)relativeoffset);
    }

    @Override
    public void glVertexArrayAttribIFormat(int vaobj, int attribindex, int size, int type, int relativeoffset) {
        assert (this.mDSASupport);
        GL45C.glVertexArrayAttribIFormat((int)vaobj, (int)attribindex, (int)size, (int)type, (int)relativeoffset);
    }

    @Override
    public void glVertexArrayAttribBinding(int vaobj, int attribindex, int bindingindex) {
        assert (this.mDSASupport);
        GL45C.glVertexArrayAttribBinding((int)vaobj, (int)attribindex, (int)bindingindex);
    }

    @Override
    public void glVertexArrayBindingDivisor(int vaobj, int bindingindex, int divisor) {
        assert (this.mDSASupport);
        GL45C.glVertexArrayBindingDivisor((int)vaobj, (int)bindingindex, (int)divisor);
    }

    @Override
    public void glBindTextureUnit(int unit, int texture) {
        assert (this.mDSASupport);
        GL45C.glBindTextureUnit((int)unit, (int)texture);
    }

    @Override
    public void glSpecializeShader(int shader, CharSequence pEntryPoint, IntBuffer pConstantIndex, IntBuffer pConstantValue) {
        assert (this.mSPIRVSupport);
        if (this.mSpecializeShaderARB) {
            ARBGLSPIRV.glSpecializeShaderARB((int)shader, (CharSequence)pEntryPoint, (IntBuffer)pConstantIndex, (IntBuffer)pConstantValue);
        } else {
            GL46C.glSpecializeShader((int)shader, (CharSequence)pEntryPoint, (IntBuffer)pConstantIndex, (IntBuffer)pConstantValue);
        }
    }
}

