/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.opengl;

import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import java.util.ArrayDeque;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.lwjgl.opengl.GL45C;
import yslelf.cloudpick.render.core.ColorInfo;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.core.Rect2i;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.BackendFormat;
import yslelf.cloudpick.render.engine.BackendImage;
import yslelf.cloudpick.render.engine.BackendRenderTarget;
import yslelf.cloudpick.render.engine.Context;
import yslelf.cloudpick.render.engine.ContextOptions;
import yslelf.cloudpick.render.engine.Device;
import yslelf.cloudpick.render.engine.FlushInfo;
import yslelf.cloudpick.render.engine.FramebufferCache;
import yslelf.cloudpick.render.engine.FramebufferDesc;
import yslelf.cloudpick.render.engine.GpuRenderTarget;
import yslelf.cloudpick.render.engine.Image;
import yslelf.cloudpick.render.engine.ImageProxyView;
import yslelf.cloudpick.render.engine.OpsRenderPass;
import yslelf.cloudpick.render.engine.SurfaceProxy;
import yslelf.cloudpick.render.engine.VertexInputLayout;
import yslelf.cloudpick.render.opengl.GLCaps;
import yslelf.cloudpick.render.opengl.GLCaps_GL;
import yslelf.cloudpick.render.opengl.GLCaps_GLES;
import yslelf.cloudpick.render.opengl.GLFramebuffer;
import yslelf.cloudpick.render.opengl.GLFramebufferInfo;
import yslelf.cloudpick.render.opengl.GLImage;
import yslelf.cloudpick.render.opengl.GLInterface;
import yslelf.cloudpick.render.opengl.GLOpsRenderPass;
import yslelf.cloudpick.render.opengl.GLRenderTarget;
import yslelf.cloudpick.render.opengl.GLResourceProvider;
import yslelf.cloudpick.render.opengl.GLTexture;
import yslelf.cloudpick.render.opengl.GLTextureMutableState;
import yslelf.cloudpick.render.opengl.GLVertexArray;

public final class GLDevice
extends Device {
    public static final int DEFAULT_FRAMEBUFFER = 0;
    public static final int DEFAULT_VERTEX_ARRAY = 0;
    public static final int DEFAULT_TEXTURE = 0;
    private final GLCaps mCaps;
    private final GLInterface mGLInterface;
    private GLOpsRenderPass mCachedOpsRenderPass;
    private final ArrayDeque<FlushInfo.FinishedCallback> mFinishedCallbacks = new ArrayDeque();
    private final LongArrayFIFOQueue mFinishedFences = new LongArrayFIFOQueue();
    private int mCopySrcFramebuffer = 0;
    private int mCopyDstFramebuffer = 0;
    private boolean mNeedsFlush;
    private final ConcurrentLinkedQueue<Consumer<GLDevice>> mRenderCalls = new ConcurrentLinkedQueue();
    private final FramebufferCache mFramebufferCache = new FramebufferCache();
    private final IdentityHashMap<VertexInputLayout, @SharedPtr GLVertexArray> mVertexArrayCache = new IdentityHashMap();

    private GLDevice(ContextOptions options, GLCaps caps, GLInterface glInterface) {
        super(0, options, caps);
        this.mCaps = caps;
        this.mGLInterface = glInterface;
    }

    @Nullable
    public static GLDevice make(ContextOptions options, Object capabilities) {
        try {
            GLCaps glInterface;
            GLCaps caps;
            switch (capabilities.getClass().getName()) {
                case "org.lwjgl.opengl.GLCapabilities": {
                    GLCaps_GL impl;
                    caps = impl = new GLCaps_GL(options, capabilities);
                    glInterface = impl;
                    break;
                }
                case "org.lwjgl.opengles.GLESCapabilities": {
                    GLCaps_GLES impl = new GLCaps_GLES(options, capabilities);
                    caps = impl;
                    glInterface = impl;
                    break;
                }
                default: {
                    options.mLogger.error("Failed to create GLDevice: invalid capabilities");
                    return null;
                }
            }
            return new GLDevice(options, caps, (GLInterface)((Object)glInterface));
        }
        catch (Exception e) {
            options.mLogger.error("Failed to create GLDevice", (Throwable)e);
            return null;
        }
    }

    public void executeRenderCall(Consumer<GLDevice> renderCall) {
        if (this.isOnExecutingThread()) {
            renderCall.accept(this);
        } else {
            this.recordRenderCall(renderCall);
        }
    }

    public void recordRenderCall(Consumer<GLDevice> renderCall) {
        this.mRenderCalls.add(renderCall);
    }

    public void flushRenderCalls() {
        Consumer<GLDevice> r;
        ConcurrentLinkedQueue<Consumer<GLDevice>> queue = this.mRenderCalls;
        while ((r = queue.poll()) != null) {
            r.accept(this);
        }
    }

    @Override
    public GLCaps getCaps() {
        return this.mCaps;
    }

    public GLInterface getGL() {
        return this.mGLInterface;
    }

    @Override
    public void disconnect(boolean cleanup) {
        super.disconnect(cleanup);
        if (cleanup) {
            // empty if block
        }
        this.callAllFinishedCallbacks(cleanup);
        this.mVertexArrayCache.values().forEach(RefCnt::unref);
        this.mVertexArrayCache.clear();
        this.flushRenderCalls();
        this.mFramebufferCache.close();
    }

    @Override
    public GLResourceProvider makeResourceProvider(Context context, long maxResourceBudget) {
        return new GLResourceProvider(this, context, maxResourceBudget);
    }

    @Override
    protected void onResetContext(int resetBits) {
        if ((resetBits & 2) != 0) {
            this.mGLInterface.glPixelStorei(3330, 0);
        }
    }

    public void clearErrors() {
        while (this.getError() != 0) {
        }
    }

    public int getError() {
        int error = this.getGL().glGetError();
        if (error == 1285) {
            this.mOutOfMemoryEncountered = true;
        } else if (error == 1287) {
            this.mDeviceIsLost = true;
        }
        return error;
    }

    @Override
    protected void freeGpuResources() {
        super.freeGpuResources();
        this.mFramebufferCache.purgeAllFramebuffers();
        this.purgeStaleVertexArrays();
    }

    @Override
    protected void purgeResourcesNotUsedSince(long timeMillis) {
        super.purgeResourcesNotUsedSince(timeMillis);
        this.mFramebufferCache.purgeFramebuffersNotUsedSince(timeMillis);
        this.purgeStaleVertexArrays();
    }

    public void purgeStaleResources() {
        this.mFramebufferCache.purgeStaleFramebuffers();
    }

    private void purgeStaleVertexArrays() {
        Iterator<Map.Entry<VertexInputLayout, GLVertexArray>> it = this.mVertexArrayCache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<VertexInputLayout, GLVertexArray> e = it.next();
            if (!e.getValue().unique()) continue;
            e.getValue().unref();
            it.remove();
        }
    }

    @Nullable
    @SharedPtr
    public GLFramebuffer findOrCreateFramebuffer(@Nonnull FramebufferDesc framebufferDesc) {
        FramebufferCache framebufferCache = this.mFramebufferCache;
        @SharedPtr GLFramebuffer existing = (GLFramebuffer)framebufferCache.findFramebuffer(framebufferDesc);
        if (existing != null) {
            return existing;
        }
        @SharedPtr GLFramebuffer framebuffer = GLFramebuffer.make(this, framebufferDesc);
        if (framebuffer == null) {
            return null;
        }
        framebufferCache.insertFramebuffer(framebufferDesc, framebuffer);
        return framebuffer;
    }

    @Nullable
    @SharedPtr
    public GLVertexArray findOrCreateVertexArray(@Nonnull VertexInputLayout inputLayout, String label) {
        GLVertexArray existing = this.mVertexArrayCache.get(inputLayout);
        if (existing != null) {
            return RefCnt.create(existing);
        }
        @SharedPtr GLVertexArray vertexArray = GLVertexArray.make(this, inputLayout, label);
        if (vertexArray != null) {
            this.mVertexArrayCache.put(inputLayout, vertexArray);
            return RefCnt.create(vertexArray);
        }
        return null;
    }

    @Override
    @Nullable
    protected GpuRenderTarget onCreateRenderTarget(int width, int height, int sampleCount, int numColorTargets, @Nullable Image[] colorTargets, @Nullable Image[] resolveTargets, @Nullable int[] mipLevels, @Nullable Image depthStencilTarget, int surfaceFlags) {
        return null;
    }

    @Override
    @Nullable
    protected GLRenderTarget onWrapRenderableBackendTexture(BackendImage texture, int sampleCount, boolean ownership) {
        if (texture.isProtected()) {
            return null;
        }
        return null;
    }

    @Override
    protected GpuRenderTarget onWrapGLDefaultFramebuffer(int width, int height, int sampleCount, int depthBits, int stencilBits, BackendFormat format) {
        int actualSamplerCount = this.mCaps.getRenderTargetSampleCount(sampleCount, format.getGLFormat());
        return GLRenderTarget.makeWrapped(null, width, height, format, actualSamplerCount, 0, depthBits, stencilBits, false);
    }

    @Override
    @Nullable
    public GLRenderTarget onWrapBackendRenderTarget(BackendRenderTarget backendRenderTarget) {
        GLFramebufferInfo info = new GLFramebufferInfo();
        if (!backendRenderTarget.getGLFramebufferInfo(info)) {
            return null;
        }
        if (backendRenderTarget.isProtected()) {
            return null;
        }
        if (!this.mCaps.isFormatRenderable(info.mFormat, backendRenderTarget.getSampleCount())) {
            return null;
        }
        int actualSamplerCount = this.mCaps.getRenderTargetSampleCount(backendRenderTarget.getSampleCount(), info.mFormat);
        return GLRenderTarget.makeWrapped(null, backendRenderTarget.getWidth(), backendRenderTarget.getHeight(), backendRenderTarget.getBackendFormat(), actualSamplerCount, info.mFramebuffer, 0, backendRenderTarget.getStencilBits(), false);
    }

    public boolean writePixels(@RawPtr Image texture, int x, int y, int width, int height, int dstColorType, int srcColorType, int rowBytes, long pixels) {
        assert (texture != null);
        if (x < 0 || y < 0 || width <= 0 || height <= 0) {
            return false;
        }
        if (texture.isReadOnly() || texture.getSampleCount() > 1) {
            return false;
        }
        if (!texture.isSampledImage()) {
            return false;
        }
        assert (texture.getWidth() > 0 && texture.getHeight() > 0);
        if (x + width > texture.getWidth() || y + height > texture.getHeight()) {
            return false;
        }
        int bpp = ColorInfo.bytesPerPixel(srcColorType);
        int minRowBytes = width * bpp;
        if (rowBytes < minRowBytes) {
            return false;
        }
        if (rowBytes % bpp != 0) {
            return false;
        }
        if (pixels == 0L) {
            return true;
        }
        if (!this.onWritePixels(texture, x, y, width, height, dstColorType, srcColorType, rowBytes, pixels)) {
            return false;
        }
        if (texture.isMipmapped()) {
            texture.setMipmapsDirty(true);
        }
        this.mStats.incTextureUploads();
        return true;
    }

    private boolean onWritePixels(@RawPtr Image image, int x, int y, int width, int height, int dstColorType, int srcColorType, int rowBytes, long pixels) {
        int maxLevel;
        if (!image.isSampledImage() && !image.isStorageImage()) {
            return false;
        }
        GLTexture glTexture = (GLTexture)image;
        int glFormat = glTexture.getFormat();
        assert (this.mCaps.isFormatTexturable(glFormat));
        int target = glTexture.getTarget();
        if (target == 36161) {
            return false;
        }
        int srcFormat = this.mCaps.getPixelsExternalFormat(glFormat, dstColorType, srcColorType, true);
        if (srcFormat == 0) {
            return false;
        }
        int srcType = this.mCaps.getPixelsExternalType(glFormat, dstColorType, srcColorType);
        if (srcType == 0) {
            return false;
        }
        GLInterface gl = this.getGL();
        boolean dsa = this.mCaps.hasDSASupport();
        int handle = glTexture.getHandle();
        int boundTexture = 0;
        if (!dsa && handle != (boundTexture = gl.glGetInteger(32873))) {
            gl.glBindTexture(target, handle);
        }
        GLTextureMutableState mutableState = glTexture.getGLMutableState();
        if (mutableState.mBaseMipmapLevel != 0) {
            if (dsa) {
                gl.glTextureParameteri(handle, 33084, 0);
            } else {
                gl.glTexParameteri(target, 33084, 0);
            }
            mutableState.mBaseMipmapLevel = 0;
        }
        if (mutableState.mMaxMipmapLevel != (maxLevel = glTexture.getMipLevelCount() - 1)) {
            if (dsa) {
                gl.glTextureParameteri(handle, 33085, maxLevel);
            } else {
                gl.glTexParameteri(target, 33085, maxLevel);
            }
            mutableState.mMaxMipmapLevel = maxLevel;
        }
        assert (x >= 0 && y >= 0 && width > 0 && height > 0);
        assert (pixels != 0L);
        int bpp = ColorInfo.bytesPerPixel(srcColorType);
        int trimRowBytes = width * bpp;
        if (rowBytes != trimRowBytes) {
            int rowLength = rowBytes / bpp;
            gl.glPixelStorei(3314, rowLength);
        } else {
            gl.glPixelStorei(3314, 0);
        }
        gl.glPixelStorei(3315, 0);
        gl.glPixelStorei(3316, 0);
        gl.glPixelStorei(3317, 1);
        if (dsa) {
            gl.glTextureSubImage2D(handle, 0, x, y, width, height, srcFormat, srcType, pixels);
        } else {
            gl.glTexSubImage2D(target, 0, x, y, width, height, srcFormat, srcType, pixels);
        }
        if (!dsa && handle != boundTexture) {
            gl.glBindTexture(target, boundTexture);
        }
        return true;
    }

    public boolean generateMipmaps(@RawPtr Image image) {
        assert (image != null);
        assert (image.isMipmapped());
        if (!image.isMipmapsDirty()) {
            return true;
        }
        if (image.isReadOnly()) {
            return false;
        }
        if (this.onGenerateMipmaps(image)) {
            image.setMipmapsDirty(false);
            return true;
        }
        return false;
    }

    private boolean onGenerateMipmaps(@RawPtr Image image) {
        GLTexture glImage = (GLTexture)image;
        if (this.mCaps.hasDSASupport()) {
            GL45C.glGenerateTextureMipmap((int)glImage.getHandle());
        } else {
            int boundTexture;
            int handle = glImage.getHandle();
            if (handle != (boundTexture = GL45C.glGetInteger((int)32873))) {
                GL45C.glBindTexture((int)3553, (int)handle);
            }
            GL45C.glGenerateMipmap((int)3553);
            if (handle != boundTexture) {
                GL45C.glBindTexture((int)3553, (int)boundTexture);
            }
        }
        return true;
    }

    public boolean copyImage(@RawPtr GLImage src, int srcL, int srcT, int srcR, int srcB, @RawPtr GLImage dst, int dstX, int dstY, int level) {
        int srcWidth = srcR - srcL;
        int srcHeight = srcB - srcT;
        if (this.mCaps.hasCopyImageSupport() && this.mCaps.canCopyImage(src.getFormat(), 1, dst.getFormat(), 1)) {
            this.getGL().glCopyImageSubData(src.getHandle(), src.getTarget(), level, srcL, srcT, 0, dst.getHandle(), dst.getTarget(), level, dstX, dstY, 0, srcWidth, srcHeight, 1);
            return true;
        }
        if (src.getTarget() == 3553 && dst.getTarget() == 3553 && this.mCaps.canCopyTexSubImage(src.getFormat(), dst.getFormat())) {
            int boundTexture;
            int framebuffer = this.mCopySrcFramebuffer;
            if (framebuffer == 0) {
                this.mCopySrcFramebuffer = framebuffer = this.getGL().glGenFramebuffers();
            }
            if (framebuffer == 0) {
                return false;
            }
            int dstHandle = dst.getHandle();
            if (dstHandle != (boundTexture = this.getGL().glGetInteger(32873))) {
                this.getGL().glBindTexture(3553, dstHandle);
            }
            int boundFramebuffer = this.getGL().glGetInteger(36010);
            this.getGL().glBindFramebuffer(36008, framebuffer);
            this.getGL().glFramebufferTexture2D(36008, 36064, 3553, src.getHandle(), level);
            this.getGL().glCopyTexSubImage2D(3553, level, dstX, dstY, srcL, srcT, srcWidth, srcHeight);
            this.getGL().glFramebufferTexture2D(36008, 36064, 3553, 0, 0);
            this.getGL().glBindFramebuffer(36008, boundFramebuffer);
            if (dstHandle != boundTexture) {
                this.getGL().glBindTexture(3553, boundTexture);
            }
            return true;
        }
        return false;
    }

    public boolean copyImage(Image src, int srcX, int srcY, Image dst, int dstX, int dstY, int width, int height) {
        return this.copyImage(src, srcX, srcY, srcX + width, srcY + height, dst, dstX, dstY, dstX + width, dstY + height, 0);
    }

    public boolean copyImage(Image src, int srcL, int srcT, int srcR, int srcB, Image dst, int dstL, int dstT, int dstR, int dstB, int filter) {
        if (dst.isReadOnly()) {
            return false;
        }
        return this.onCopyImage(src, srcL, srcT, srcR, srcB, dst, dstL, dstT, dstR, dstB, filter);
    }

    private boolean onCopyImage(Image src, int srcL, int srcT, int srcR, int srcB, Image dst, int dstL, int dstT, int dstR, int dstB, int filter) {
        int srcWidth = srcR - srcL;
        int srcHeight = srcB - srcT;
        int dstWidth = dstR - dstL;
        int dstHeight = dstB - dstT;
        if (srcWidth == dstWidth && srcHeight == dstHeight) {
            return this.copyImage((GLImage)src, srcL, srcT, srcR, srcB, (GLImage)dst, dstL, dstT, 0);
        }
        return false;
    }

    @Override
    protected OpsRenderPass onGetOpsRenderPass(ImageProxyView writeView, Rect2i contentBounds, byte colorOps, byte stencilOps, float[] clearColor, Set<SurfaceProxy> sampledTextures, int pipelineFlags) {
        this.mStats.incRenderPasses();
        if (this.mCachedOpsRenderPass == null) {
            this.mCachedOpsRenderPass = new GLOpsRenderPass(this);
        }
        return null;
    }

    @Override
    protected void onResolveRenderTarget(GpuRenderTarget renderTarget, int resolveLeft, int resolveTop, int resolveRight, int resolveBottom) {
    }

    private void flush(boolean forceFlush) {
        if (this.mNeedsFlush || forceFlush) {
            this.mNeedsFlush = false;
        }
    }

    @Override
    public long insertFence() {
        return 0L;
    }

    @Override
    public boolean checkFence(long fence) {
        return true;
    }

    @Override
    public void deleteFence(long fence) {
    }

    @Override
    public void addFinishedCallback(FlushInfo.FinishedCallback callback) {
        this.mFinishedCallbacks.addLast(callback);
        this.mFinishedFences.enqueue(this.insertFence());
        assert (this.mFinishedCallbacks.size() == this.mFinishedFences.size());
    }

    @Override
    public void checkFinishedCallbacks() {
        while (!this.mFinishedCallbacks.isEmpty() && this.checkFence(this.mFinishedFences.firstLong())) {
            this.deleteFence(this.mFinishedFences.dequeueLong());
            this.mFinishedCallbacks.removeFirst().onFinished(true);
        }
        assert (this.mFinishedCallbacks.size() == this.mFinishedFences.size());
    }

    private void callAllFinishedCallbacks(boolean cleanup) {
        while (!this.mFinishedCallbacks.isEmpty()) {
            if (cleanup) {
                this.deleteFence(this.mFinishedFences.dequeueLong());
            }
            this.mFinishedCallbacks.removeFirst().onFinished(true);
        }
        if (!cleanup) {
            this.mFinishedFences.clear();
        } else assert (this.mFinishedFences.isEmpty());
    }

    @Override
    public void waitForQueue() {
    }
}

