/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.opengl;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.BlendInfo;
import yslelf.cloudpick.render.engine.DepthStencilSettings;
import yslelf.cloudpick.render.engine.GraphicsPipeline;
import yslelf.cloudpick.render.engine.ImageViewProxy;
import yslelf.cloudpick.render.engine.SharedResourceCache;
import yslelf.cloudpick.render.engine.trash.GraphicsPipelineDesc_Old;
import yslelf.cloudpick.render.opengl.GLBuffer;
import yslelf.cloudpick.render.opengl.GLCommandBuffer;
import yslelf.cloudpick.render.opengl.GLDevice;
import yslelf.cloudpick.render.opengl.GLGraphicsPipelineBuilder;
import yslelf.cloudpick.render.opengl.GLProgram;
import yslelf.cloudpick.render.opengl.GLTexture;
import yslelf.cloudpick.render.opengl.GLUniformDataManager;
import yslelf.cloudpick.render.opengl.GLVertexArray;

public final class GLGraphicsPipeline
extends GraphicsPipeline {
    @SharedPtr
    private GLProgram mProgram;
    @SharedPtr
    private GLVertexArray mVertexArray;
    private byte mPrimitiveType;
    private BlendInfo mBlendInfo;
    private DepthStencilSettings mDepthStencilSettings;
    private GLUniformDataManager mDataManager;
    private int mNumTextureSamplers;
    private CompletableFuture<GLGraphicsPipelineBuilder> mAsyncWork;

    GLGraphicsPipeline(GLDevice device, CompletableFuture<GLGraphicsPipelineBuilder> asyncWork) {
        super(device);
        this.mAsyncWork = asyncWork;
    }

    void init(@SharedPtr GLProgram program, @SharedPtr GLVertexArray vertexArray, byte primitiveType, BlendInfo blendInfo, DepthStencilSettings depthStencilSettings) {
        this.mProgram = program;
        this.mVertexArray = vertexArray;
        this.mPrimitiveType = primitiveType;
        this.mBlendInfo = blendInfo;
        this.mDepthStencilSettings = depthStencilSettings;
    }

    public void discard() {
        if (this.mAsyncWork != null) {
            this.mAsyncWork.cancel(true);
            this.mAsyncWork = null;
        }
        if (this.mProgram != null) {
            this.mProgram.discard();
            if (this.mVertexArray.unique()) {
                this.mVertexArray.discard();
            }
        }
    }

    @Override
    protected void deallocate() {
        if (this.mAsyncWork != null) {
            this.mAsyncWork.cancel(true);
            this.mAsyncWork = null;
        }
        this.mProgram = RefCnt.move(this.mProgram);
        this.mVertexArray = RefCnt.move(this.mVertexArray);
        this.mDataManager = RefCnt.move(this.mDataManager);
    }

    private void checkAsyncWork() {
        boolean success = this.mAsyncWork.join().finish(this);
        SharedResourceCache.Stats stats = this.getDevice().getSharedResourceCache().getStats();
        if (success) {
            stats.incNumCompilationSuccesses();
        } else {
            stats.incNumCompilationFailures();
        }
        this.mAsyncWork = null;
    }

    @Nullable
    public GLProgram getProgram() {
        if (this.mAsyncWork != null) {
            this.checkAsyncWork();
        }
        return this.mProgram;
    }

    @Nullable
    public GLVertexArray getVertexArray() {
        if (this.mAsyncWork != null) {
            this.checkAsyncWork();
        }
        return this.mVertexArray;
    }

    @Deprecated
    public boolean bindUniforms(GLCommandBuffer commandBuffer, GraphicsPipelineDesc_Old graphicsPipelineDesc, int width, int height) {
        this.mDataManager.setProjection(0, width, height, graphicsPipelineDesc.origin() == 1);
        return this.mDataManager.bindAndUploadUniforms(this.getDevice(), commandBuffer);
    }

    @Deprecated
    public boolean bindTextures(GLCommandBuffer commandBuffer, GraphicsPipelineDesc_Old graphicsPipelineDesc, ImageViewProxy[] geomTextures) {
        int unit = 0;
        int n2 = graphicsPipelineDesc.geomProc().numTextureSamplers();
        for (int i = 0; i < n2; ++i) {
            GLTexture gLTexture = (GLTexture)geomTextures[i].getImage();
        }
        assert (unit == this.mNumTextureSamplers);
        return true;
    }

    public byte getPrimitiveType() {
        return this.mPrimitiveType;
    }

    public BlendInfo getBlendInfo() {
        return this.mBlendInfo;
    }

    public DepthStencilSettings getDepthStencilSettings() {
        return this.mDepthStencilSettings;
    }

    public int getVertexBindingCount() {
        return this.mVertexArray.getBindingCount();
    }

    public int getVertexStride(int binding) {
        return this.mVertexArray.getStride(binding);
    }

    public int getVertexInputRate(int binding) {
        return this.mVertexArray.getInputRate(binding);
    }

    public void bindIndexBuffer(@Nonnull @RawPtr GLBuffer buffer) {
        if (this.mVertexArray != null) {
            this.mVertexArray.bindIndexBuffer(buffer);
        }
    }

    public void bindVertexBuffer(int binding, @Nonnull @RawPtr GLBuffer buffer, long offset) {
        if (this.mVertexArray != null) {
            this.mVertexArray.bindVertexBuffer(binding, buffer, offset);
        }
    }

    @Override
    protected GLDevice getDevice() {
        return (GLDevice)super.getDevice();
    }
}

