/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.opengl;

import javax.annotation.concurrent.Immutable;
import yslelf.cloudpick.render.engine.ImageDesc;
import yslelf.cloudpick.render.opengl.GLUtil;

@Immutable
public final class GLImageDesc
extends ImageDesc {
    public final int mTarget;
    public final int mFormat;

    public GLImageDesc(int target, int format, int width, int height, int depth, int arraySize, int mipLevelCount, int sampleCount, int flags) {
        super(switch (target) {
            case 3553 -> 1;
            case 35866 -> 2;
            case 32879 -> 5;
            case 34067 -> 3;
            case 36873 -> 4;
            default -> 0;
        }, width, height, depth, arraySize, mipLevelCount, sampleCount, flags);
        this.mTarget = target;
        this.mFormat = format;
    }

    @Override
    public int getBackend() {
        return 0;
    }

    @Override
    public int getGLFormat() {
        return this.mFormat;
    }

    @Override
    public int getChannelFlags() {
        return GLUtil.glFormatChannels(this.mFormat);
    }

    @Override
    public boolean isSRGB() {
        return GLUtil.glFormatIsSRGB(this.mFormat);
    }

    @Override
    public int getCompressionType() {
        return GLUtil.glFormatCompressionType(this.mFormat);
    }

    @Override
    public int getBytesPerBlock() {
        return GLUtil.glFormatBytesPerBlock(this.mFormat);
    }

    @Override
    public int getDepthBits() {
        return GLUtil.glFormatDepthBits(this.mFormat);
    }

    @Override
    public int getStencilBits() {
        return GLUtil.glFormatStencilBits(this.mFormat);
    }

    public int hashCode() {
        int result = this.mTarget;
        result = 31 * result + this.mFormat;
        result = 31 * result + this.mWidth;
        result = 31 * result + this.mHeight;
        result = 31 * result + this.mDepth;
        result = 31 * result + this.mArraySize;
        result = 31 * result + this.mMipLevelCount;
        result = 31 * result + this.mSampleCount;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof GLImageDesc) {
            GLImageDesc desc = (GLImageDesc)o;
            return this.mTarget == desc.mTarget && this.mFormat == desc.mFormat && this.mWidth == desc.mWidth && this.mHeight == desc.mHeight && this.mDepth == desc.mDepth && this.mArraySize == desc.mArraySize && this.mMipLevelCount == desc.mMipLevelCount && this.mSampleCount == desc.mSampleCount;
        }
        return false;
    }

    public String toString() {
        return "{target=" + this.mTarget + ", format=" + GLUtil.glFormatName(this.mFormat) + ", width=" + this.mWidth + ", height=" + this.mHeight + ", depth=" + this.mDepth + ", arraySize=" + this.mArraySize + ", mipLevelCount=" + this.mMipLevelCount + ", sampleCount=" + this.mSampleCount + "}";
    }
}

