/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.opengl;

import javax.annotation.Nonnull;
import yslelf.cloudpick.render.engine.ManagedResource;
import yslelf.cloudpick.render.opengl.GLDevice;

public final class GLProgram
extends ManagedResource {
    private int mProgram;

    public GLProgram(@Nonnull GLDevice device, int program) {
        super(device);
        assert (program != 0);
        this.mProgram = program;
    }

    @Override
    protected void deallocate() {
        ((GLDevice)this.getDevice()).executeRenderCall(dev -> {
            if (this.mProgram != 0) {
                dev.getGL().glDeleteProgram(this.mProgram);
            }
            this.discard();
        });
    }

    public void discard() {
        this.mProgram = 0;
    }

    public int getProgram() {
        return this.mProgram;
    }
}

