/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.opengl;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.BackendFormat;
import yslelf.cloudpick.render.engine.BackendRenderTarget;
import yslelf.cloudpick.render.engine.Context;
import yslelf.cloudpick.render.engine.GpuRenderTarget;
import yslelf.cloudpick.render.opengl.GLBackendRenderTarget;
import yslelf.cloudpick.render.opengl.GLDevice;
import yslelf.cloudpick.render.opengl.GLFramebufferInfo;
import yslelf.cloudpick.render.opengl.GLTexture;

public final class GLRenderTarget
extends GpuRenderTarget {
    @SharedPtr
    private GLTexture[] mColorAttachments;
    @SharedPtr
    private GLTexture[] mResolveAttachments;
    @SharedPtr
    private GLTexture mDepthStencilAttachment;
    private int mRenderFramebuffer;
    private int mResolveFramebuffer;
    private boolean mRebindStencilBuffer;
    private final boolean mOwnership;
    private BackendFormat mBackendFormat;
    private BackendRenderTarget mBackendRenderTarget;

    GLRenderTarget(Context context, int width, int height, int sampleCount, int renderFramebuffer, int resolveFramebuffer, int numColorTargets, GLTexture[] colorAttachments, GLTexture[] resolveAttachments, GLTexture depthStencilAttachment, int surfaceFlags) {
        super(context, width, height, sampleCount, numColorTargets);
        assert (sampleCount > 0);
        this.mRenderFramebuffer = renderFramebuffer;
        this.mResolveFramebuffer = resolveFramebuffer;
        this.mOwnership = true;
        this.mColorAttachments = colorAttachments;
        this.mResolveAttachments = resolveAttachments;
        this.mDepthStencilAttachment = depthStencilAttachment;
        GLTexture primaryAtt = (GLTexture)this.asImage();
        this.mSurfaceFlags |= surfaceFlags;
    }

    private GLRenderTarget(Context context, int width, int height, BackendFormat format, int sampleCount, int framebuffer, boolean ownership, @SharedPtr GLTexture depthStencilAttachment) {
        super(context, width, height, sampleCount, 1);
        assert (sampleCount > 0);
        assert (framebuffer != 0 || !ownership);
        this.mRenderFramebuffer = framebuffer;
        this.mResolveFramebuffer = 0;
        this.mBackendFormat = format;
        this.mOwnership = ownership;
        this.mDepthStencilAttachment = depthStencilAttachment;
        if (framebuffer == 0) {
            this.mSurfaceFlags |= 0x800;
        }
    }

    @Nonnull
    @SharedPtr
    public static GLRenderTarget makeWrapped(Context context, int width, int height, BackendFormat format, int sampleCount, int framebuffer, int depthBits, int stencilBits, boolean ownership) {
        assert (sampleCount > 0);
        assert (framebuffer != 0 || !ownership);
        GLTexture depthStencilAtt = null;
        if (depthBits > 0 || stencilBits > 0) {
            int depthStencilFormat = 0;
            if (stencilBits == 16) {
                depthStencilFormat = 36169;
            } else if (stencilBits == 8) {
                switch (depthBits) {
                    case 24: {
                        depthStencilFormat = 35056;
                        break;
                    }
                    case 32: {
                        depthStencilFormat = 36013;
                    }
                }
            } else if (stencilBits == 0) {
                switch (depthBits) {
                    case 16: {
                        depthStencilFormat = 33189;
                        break;
                    }
                    case 24: {
                        depthStencilFormat = 33190;
                        break;
                    }
                    case 32: {
                        depthStencilFormat = 36012;
                    }
                }
            }
        }
        return new GLRenderTarget(context, width, height, format, sampleCount, framebuffer, ownership, depthStencilAtt);
    }

    public int getRenderFramebuffer() {
        return this.mRenderFramebuffer;
    }

    public int getResolveFramebuffer() {
        return this.mResolveFramebuffer;
    }

    public void bindStencil() {
        if (!this.mRebindStencilBuffer) {
            return;
        }
        this.mRebindStencilBuffer = false;
    }

    @Override
    @Nonnull
    public BackendFormat getBackendFormat() {
        return this.mBackendFormat;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    @Nullable
    @RawPtr
    public GLTexture getColorAttachment() {
        return this.mColorAttachments != null ? this.mColorAttachments[0] : null;
    }

    @Override
    @Nullable
    @RawPtr
    public GLTexture getColorAttachment(int index) {
        return this.mColorAttachments != null ? this.mColorAttachments[index] : null;
    }

    @Nullable
    @RawPtr
    public GLTexture[] getColorAttachments() {
        return this.mColorAttachments;
    }

    @Override
    @Nullable
    @RawPtr
    public GLTexture getResolveAttachment() {
        return this.mResolveAttachments != null ? this.mResolveAttachments[0] : null;
    }

    @Override
    @Nullable
    @RawPtr
    public GLTexture getResolveAttachment(int index) {
        return this.mResolveAttachments != null ? this.mResolveAttachments[index] : null;
    }

    @Nullable
    @RawPtr
    public GLTexture[] getResolveAttachments() {
        return this.mResolveAttachments;
    }

    @Override
    @Nullable
    @RawPtr
    public GLTexture getDepthStencilAttachment() {
        return this.mDepthStencilAttachment;
    }

    @Override
    public int getDepthBits() {
        return this.mDepthStencilAttachment != null ? this.mDepthStencilAttachment.getDepthBits() : 0;
    }

    @Override
    public int getStencilBits() {
        return this.mDepthStencilAttachment != null ? this.mDepthStencilAttachment.getStencilBits() : 0;
    }

    @Override
    @Nonnull
    public BackendRenderTarget getBackendRenderTarget() {
        if (this.mBackendRenderTarget == null) {
            GLFramebufferInfo info = new GLFramebufferInfo();
            info.mFramebuffer = this.mRenderFramebuffer;
            this.mBackendRenderTarget = new GLBackendRenderTarget(this.getWidth(), this.getHeight(), this.getSampleCount(), this.getDepthBits(), this.getStencilBits(), info);
        }
        return this.mBackendRenderTarget;
    }

    @Override
    protected boolean canAttachStencil() {
        return this.mOwnership;
    }

    @Override
    protected void onRelease() {
        if (this.mOwnership) {
            if (this.mRenderFramebuffer != 0) {
                this.getDevice().getGL().glDeleteFramebuffers(this.mRenderFramebuffer);
            }
            if (this.mRenderFramebuffer != this.mResolveFramebuffer) {
                assert (this.mResolveFramebuffer != 0);
                this.getDevice().getGL().glDeleteFramebuffers(this.mResolveFramebuffer);
            }
        }
        this.clearAttachments();
        this.mRenderFramebuffer = 0;
        this.mResolveFramebuffer = 0;
    }

    private void clearAttachments() {
        int i;
        if (this.mColorAttachments != null) {
            for (i = 0; i < this.mColorAttachments.length; ++i) {
                this.mColorAttachments[i] = RefCnt.move(this.mColorAttachments[i]);
            }
        }
        if (this.mResolveAttachments != null) {
            for (i = 0; i < this.mResolveAttachments.length; ++i) {
                this.mResolveAttachments[i] = RefCnt.move(this.mResolveAttachments[i]);
            }
        }
        this.mDepthStencilAttachment = RefCnt.move(this.mDepthStencilAttachment);
    }

    @Override
    protected GLDevice getDevice() {
        return (GLDevice)super.getDevice();
    }

    public String toString() {
        return "GLFramebuffer{mRenderFramebuffer=" + this.mRenderFramebuffer + ", mResolveFramebuffer=" + this.mResolveFramebuffer + ", mColorAttachments=" + Arrays.toString(this.mColorAttachments) + ", mResolveAttachments=" + Arrays.toString(this.mResolveAttachments) + ", mDepthStencilAttachment=" + this.mDepthStencilAttachment + ", mSampleCount=" + this.getSampleCount() + ", mOwnership=" + this.mOwnership + ", mBackendFormat=" + this.mBackendFormat + "}";
    }
}

