/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.opengl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.BackendFormat;
import yslelf.cloudpick.render.engine.Context;
import yslelf.cloudpick.render.opengl.GLDevice;
import yslelf.cloudpick.render.opengl.GLImage;
import yslelf.cloudpick.render.opengl.GLImageDesc;
import yslelf.cloudpick.render.opengl.GLInterface;
import yslelf.cloudpick.render.opengl.GLUtil;

public final class GLRenderbuffer
extends GLImage {
    private int mRenderbuffer;
    private BackendFormat mBackendFormat;

    private GLRenderbuffer(Context context, GLImageDesc desc, int renderbuffer, boolean budgeted) {
        super(context, budgeted, false, desc, null);
        this.mRenderbuffer = renderbuffer;
        if (this.mRenderbuffer == 0) {
            this.getDevice().recordRenderCall(dev -> {
                if (this.isDestroyed()) {
                    return;
                }
                this.mRenderbuffer = GLRenderbuffer.internalCreateRenderbuffer(dev, this.getGLDesc());
                if (this.mRenderbuffer == 0) {
                    this.setNonCacheable();
                }
            });
        }
    }

    @Nullable
    @SharedPtr
    public static GLRenderbuffer makeStencil(GLDevice device, int width, int height, int sampleCount, int format) {
        assert (sampleCount > 0 && GLUtil.glFormatStencilBits(format) > 0);
        int renderbuffer = device.getGL().glGenRenderbuffers();
        if (renderbuffer == 0) {
            return null;
        }
        device.getGL().glBindRenderbuffer(36161, renderbuffer);
        if (device.getCaps().skipErrorChecks()) {
            if (sampleCount > 1) {
                device.getGL().glRenderbufferStorageMultisample(36161, sampleCount, format, width, height);
            } else {
                device.getGL().glRenderbufferStorage(36161, format, width, height);
            }
        } else {
            device.clearErrors();
            if (sampleCount > 1) {
                device.getGL().glRenderbufferStorageMultisample(36161, sampleCount, format, width, height);
            } else {
                device.getGL().glRenderbufferStorage(36161, format, width, height);
            }
            if (device.getError() != 0) {
                device.getGL().glDeleteRenderbuffers(renderbuffer);
                return null;
            }
        }
        return null;
    }

    @Nullable
    @SharedPtr
    public static GLRenderbuffer makeColor(GLDevice device, int width, int height, int sampleCount, int format) {
        assert (sampleCount > 1);
        int renderbuffer = device.getGL().glGenRenderbuffers();
        if (renderbuffer == 0) {
            return null;
        }
        device.getGL().glBindRenderbuffer(36161, renderbuffer);
        int internalFormat = device.getCaps().getRenderbufferInternalFormat(format);
        if (device.getCaps().skipErrorChecks()) {
            device.getGL().glRenderbufferStorageMultisample(36161, sampleCount, internalFormat, width, height);
        } else {
            device.clearErrors();
            device.getGL().glRenderbufferStorageMultisample(36161, sampleCount, internalFormat, width, height);
            if (device.getError() != 0) {
                device.getGL().glDeleteRenderbuffers(renderbuffer);
                return null;
            }
        }
        return null;
    }

    @Nonnull
    @SharedPtr
    public static GLRenderbuffer makeWrapped(GLDevice device, int width, int height, int sampleCount, int format, int renderbuffer) {
        assert (sampleCount > 0);
        return null;
    }

    @Nonnull
    @SharedPtr
    public static GLRenderbuffer makeWrappedRenderbuffer(Context context, int width, int height, int sampleCount, int format, int renderbuffer) {
        GLImageDesc desc = new GLImageDesc(36161, format, width, height, 1, 1, 1, sampleCount, 32);
        return new GLRenderbuffer(context, desc, renderbuffer, false);
    }

    public static GLRenderbuffer make(Context context, GLImageDesc desc, boolean budgeted) {
        int handle;
        GLDevice device = (GLDevice)context.getDevice();
        if (device.isOnExecutingThread()) {
            handle = GLRenderbuffer.internalCreateRenderbuffer(device, desc);
            if (handle == 0) {
                return null;
            }
        } else {
            handle = 0;
        }
        return new GLRenderbuffer(context, desc, handle, budgeted);
    }

    static int internalCreateRenderbuffer(GLDevice device, GLImageDesc desc) {
        int height;
        assert (desc.mTarget == 36161);
        int width = desc.getWidth();
        int handle = GLRenderbuffer.internalCreateRenderbuffer(device, width, height = desc.getHeight(), desc.getSampleCount(), desc.mFormat);
        if (handle != 0) {
            device.getStats().incImageCreates();
        }
        return handle;
    }

    static int internalCreateRenderbuffer(GLDevice device, int width, int height, int sampleCount, int internalFormat) {
        boolean checkError;
        GLInterface gl = device.getGL();
        int renderbuffer = gl.glGenRenderbuffers();
        if (renderbuffer == 0) {
            return 0;
        }
        gl.glBindRenderbuffer(36161, renderbuffer);
        boolean bl = checkError = !device.getCaps().skipErrorChecks();
        if (checkError) {
            device.clearErrors();
        }
        if (sampleCount > 1) {
            gl.glRenderbufferStorageMultisample(36161, sampleCount, internalFormat, width, height);
        } else {
            gl.glRenderbufferStorage(36161, internalFormat, width, height);
        }
        if (checkError && device.getError() != 0) {
            gl.glDeleteRenderbuffers(renderbuffer);
            return 0;
        }
        return renderbuffer;
    }

    @Nonnull
    public BackendFormat getBackendFormat() {
        return this.mBackendFormat;
    }

    @Override
    protected void onSetLabel(@Nullable String label) {
        this.getDevice().executeRenderCall(dev -> {
            if (dev.getCaps().hasDebugSupport()) {
                assert (this.mRenderbuffer != 0);
                if (label == null) {
                    dev.getGL().glObjectLabel(36161, this.mRenderbuffer, 0, 0L);
                } else {
                    Object subLabel = "Arc3D_RBO_" + label;
                    subLabel = ((String)subLabel).substring(0, Math.min(((String)subLabel).length(), dev.getCaps().maxLabelLength()));
                    dev.getGL().glObjectLabel(36161, this.mRenderbuffer, (CharSequence)subLabel);
                }
            }
        });
    }

    @Override
    protected void onRelease() {
        this.getDevice().executeRenderCall(dev -> {
            if (this.mRenderbuffer != 0) {
                dev.getGL().glDeleteRenderbuffers(this.mRenderbuffer);
            }
            this.mRenderbuffer = 0;
        });
        super.onRelease();
    }

    @Override
    public int getHandle() {
        return this.mRenderbuffer;
    }

    public String toString() {
        return "GLRenderbuffer{mRenderbuffer=" + this.mRenderbuffer + ", mMemorySize=" + this.getMemorySize() + "}";
    }
}

