/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.opengl;

import javax.annotation.Nullable;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.Context;
import yslelf.cloudpick.render.engine.ImageDesc;
import yslelf.cloudpick.render.engine.PipelineDesc;
import yslelf.cloudpick.render.engine.RenderPassDesc;
import yslelf.cloudpick.render.engine.ResourceProvider;
import yslelf.cloudpick.render.engine.Sampler;
import yslelf.cloudpick.render.engine.SamplerDesc;
import yslelf.cloudpick.render.opengl.GLBuffer;
import yslelf.cloudpick.render.opengl.GLDevice;
import yslelf.cloudpick.render.opengl.GLGraphicsPipeline;
import yslelf.cloudpick.render.opengl.GLGraphicsPipelineBuilder;
import yslelf.cloudpick.render.opengl.GLImage;
import yslelf.cloudpick.render.opengl.GLImageDesc;
import yslelf.cloudpick.render.opengl.GLRenderbuffer;
import yslelf.cloudpick.render.opengl.GLSampler;
import yslelf.cloudpick.render.opengl.GLTexture;

public final class GLResourceProvider
extends ResourceProvider {
    private final GLDevice mDevice;

    GLResourceProvider(GLDevice device, Context context, long maxResourceBudget) {
        super(device, context, maxResourceBudget);
        this.mDevice = device;
    }

    @Override
    @SharedPtr
    protected GLGraphicsPipeline createGraphicsPipeline(PipelineDesc pipelineDesc, RenderPassDesc renderPassDesc) {
        return GLGraphicsPipelineBuilder.createGraphicsPipeline(this.mDevice, pipelineDesc);
    }

    @Override
    @Nullable
    @SharedPtr
    protected GLImage onCreateNewImage(ImageDesc desc, boolean budgeted) {
        if (!(desc instanceof GLImageDesc)) {
            return null;
        }
        GLImageDesc glImageDesc = (GLImageDesc)desc;
        if (glImageDesc.mTarget == 36161) {
            return GLRenderbuffer.make(this.mContext, glImageDesc, budgeted);
        }
        return GLTexture.make(this.mContext, glImageDesc, budgeted);
    }

    @Override
    @Nullable
    @SharedPtr
    protected GLBuffer onCreateNewBuffer(long size, int usage) {
        return GLBuffer.make(this.mContext, size, usage);
    }

    @Override
    @Nullable
    @SharedPtr
    protected Sampler createSampler(SamplerDesc desc) {
        return GLSampler.create(this.mContext, desc);
    }
}

