/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.opengl;

import java.util.List;
import org.lwjgl.opengl.GL15C;
import yslelf.cloudpick.render.core.MathUtil;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SLDataType;
import yslelf.cloudpick.render.engine.UniformDataManager;
import yslelf.cloudpick.render.granite.shading.UniformHandler;
import yslelf.cloudpick.render.opengl.GLCommandBuffer;
import yslelf.cloudpick.render.opengl.GLDevice;
import yslelf.cloudpick.render.opengl.GLUniformBuffer;

public class GLUniformDataManager
extends UniformDataManager {
    private int mRTWidth;
    private int mRTHeight;
    private boolean mRTFlipY;
    private GLUniformBuffer mUniformBuffer;

    GLUniformDataManager(List<UniformHandler.UniformInfo> uniforms, int uniformSize) {
        super(uniforms.size(), uniformSize);
        int e = uniforms.size();
        for (int i = 0; i < e; ++i) {
            UniformHandler.UniformInfo uniformInfo = uniforms.get(i);
            assert ((uniformInfo.mOffset & 0xFFFFFF) == uniformInfo.mOffset);
            assert (MathUtil.isAlign4(uniformInfo.mOffset));
            assert (SLDataType.canBeUniformValue(uniformInfo.mVariable.getType()));
            this.mUniforms[i] = uniformInfo.mOffset | uniformInfo.mVariable.getType() << 24;
        }
    }

    @Override
    protected void deallocate() {
        super.deallocate();
        this.mUniformBuffer = RefCnt.move(this.mUniformBuffer);
    }

    public void setProjection(int u, int width, int height, boolean flipY) {
        if (width != this.mRTWidth || height != this.mRTHeight || flipY != this.mRTFlipY) {
            if (flipY) {
                this.set4f(u, 2.0f / (float)width, -1.0f, -2.0f / (float)height, 1.0f);
            } else {
                this.set4f(u, 2.0f / (float)width, -1.0f, 2.0f / (float)height, -1.0f);
            }
            this.mRTWidth = width;
            this.mRTHeight = height;
            this.mRTFlipY = flipY;
        }
    }

    public boolean bindAndUploadUniforms(GLDevice device, GLCommandBuffer commandBuffer) {
        if (!this.mUniformsDirty) {
            return true;
        }
        if (this.mUniformBuffer == null) {
            this.mUniformBuffer = GLUniformBuffer.make(device, this.mUniformSize, 0);
        }
        if (this.mUniformBuffer == null) {
            return false;
        }
        GL15C.nglBufferSubData((int)35345, (long)0L, (long)this.mUniformSize, (long)this.mUniformData);
        this.mUniformsDirty = false;
        return true;
    }
}

