/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.opengl;

import java.lang.ref.Reference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Formatter;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.slf4j.Logger;
import yslelf.cloudpick.render.engine.ContextOptions;
import yslelf.cloudpick.render.engine.ImmediateContext;
import yslelf.cloudpick.render.engine.SharedResourceCache;
import yslelf.cloudpick.render.opengl.GLDevice;
import yslelf.cloudpick.render.opengl.GLInterface;
import yslelf.cloudpick.render.opengl.GLQueueManager;

public final class GLUtil {
    public static final int LAST_COLOR_FORMAT_INDEX = 16;
    public static final int LAST_FORMAT_INDEX = 23;

    @Nullable
    @ApiStatus.Internal
    public static ImmediateContext makeOpenGL() {
        return GLUtil.makeOpenGL(new ContextOptions());
    }

    @Nullable
    @ApiStatus.Internal
    public static ImmediateContext makeOpenGL(@Nonnull ContextOptions options) {
        GLCapabilities capabilities;
        try {
            capabilities = Objects.requireNonNullElseGet(GL.getCapabilities(), GL::createCapabilities);
        }
        catch (Exception x) {
            try {
                capabilities = GL.createCapabilities();
            }
            catch (Exception e) {
                return null;
            }
        }
        return GLUtil.makeOpenGL(capabilities, options);
    }

    @Nullable
    public static ImmediateContext makeOpenGL(@Nonnull Object capabilities, @Nonnull ContextOptions options) {
        GLDevice device = GLDevice.make(options, capabilities);
        if (device == null) {
            return null;
        }
        GLQueueManager queueManager = new GLQueueManager(device);
        ImmediateContext context = new ImmediateContext(device, queueManager);
        if (context.init()) {
            return context;
        }
        context.unref();
        return null;
    }

    public static GLVendor findVendor(String vendorString) {
        Objects.requireNonNull(vendorString);
        if (vendorString.equals("NVIDIA Corporation")) {
            return GLVendor.NVIDIA;
        }
        if (vendorString.equals("ATI Technologies Inc.")) {
            return GLVendor.ATI;
        }
        if (vendorString.startsWith("Intel ") || vendorString.equals("Intel")) {
            return GLVendor.INTEL;
        }
        if (vendorString.equals("Qualcomm") || vendorString.equals("freedreno")) {
            return GLVendor.QUALCOMM;
        }
        return GLVendor.OTHER;
    }

    public static GLDriver findDriver(GLVendor vendor, String vendorString, String versionString) {
        Objects.requireNonNull(vendorString);
        if (vendorString.equals("freedreno")) {
            return GLDriver.FREEDRENO;
        }
        if (vendor == GLVendor.NVIDIA) {
            return GLDriver.NVIDIA;
        }
        Matcher matcher = Pattern.compile("\\d+\\.\\d+( \\(Core Profile\\))? Mesa \\d+\\.\\d+").matcher(versionString);
        if (matcher.find()) {
            return GLDriver.MESA;
        }
        if (vendor == GLVendor.ATI) {
            return GLDriver.AMD;
        }
        if (vendor == GLVendor.INTEL) {
            return GLDriver.INTEL;
        }
        return GLDriver.OTHER;
    }

    public static int glFormatToIndex(@NativeType(value="GLenum") int format) {
        return switch (format) {
            case 32856 -> 1;
            case 33321 -> 2;
            case 36194 -> 3;
            case 34842 -> 4;
            case 33325 -> 5;
            case 32849 -> 6;
            case 33323 -> 7;
            case 32857 -> 8;
            case 35907 -> 9;
            case 37492 -> 10;
            case 33776 -> 11;
            case 33777 -> 12;
            case 33322 -> 13;
            case 33324 -> 14;
            case 32859 -> 15;
            case 33327 -> 16;
            case 36168 -> 17;
            case 36169 -> 18;
            case 33189 -> 19;
            case 33190 -> 20;
            case 36012 -> 21;
            case 35056 -> 22;
            case 36013 -> 23;
            default -> 0;
        };
    }

    @NativeType(value="GLenum")
    public static int glIndexToFormat(int index) {
        return switch (index) {
            case 0 -> 0;
            case 1 -> 32856;
            case 2 -> 33321;
            case 3 -> 36194;
            case 4 -> 34842;
            case 5 -> 33325;
            case 6 -> 32849;
            case 7 -> 33323;
            case 8 -> 32857;
            case 9 -> 35907;
            case 10 -> 37492;
            case 11 -> 33776;
            case 12 -> 33777;
            case 13 -> 33322;
            case 14 -> 33324;
            case 15 -> 32859;
            case 16 -> 33327;
            case 17 -> 36168;
            case 18 -> 36169;
            case 19 -> 33189;
            case 20 -> 33190;
            case 21 -> 36012;
            case 22 -> 35056;
            case 23 -> 36013;
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError(index);
                }
                yield 0;
            }
        };
    }

    public static int glFormatChannels(@NativeType(value="GLenum") int format) {
        return switch (format) {
            case 32856, 32857, 32859, 33777, 34842, 35907 -> 15;
            case 33321, 33322, 33325 -> 1;
            case 32849, 33776, 36194, 37492 -> 7;
            case 33323, 33324, 33327 -> 3;
            default -> 0;
        };
    }

    public static boolean glFormatIsSupported(@NativeType(value="GLenum") int format) {
        return switch (format) {
            case 32849, 32856, 32857, 32859, 33189, 33190, 33321, 33322, 33323, 33324, 33325, 33327, 33776, 33777, 34842, 35056, 35907, 36012, 36013, 36168, 36169, 36194, 37492 -> true;
            default -> false;
        };
    }

    public static int glFormatCompressionType(@NativeType(value="GLenum") int format) {
        return switch (format) {
            case 37492 -> 1;
            case 33776 -> 2;
            case 33777 -> 3;
            default -> 0;
        };
    }

    public static int glFormatBytesPerBlock(@NativeType(value="GLenum") int format) {
        return switch (format) {
            case 32849, 32856, 32857, 33190, 33324, 33327, 35056, 35907, 36012 -> 4;
            case 33321, 36168 -> 1;
            case 33189, 33322, 33323, 33325, 36169, 36194 -> 2;
            case 32859, 33776, 33777, 34842, 36013, 37492 -> 8;
            default -> 0;
        };
    }

    public static int glFormatDepthBits(@NativeType(value="GLenum") int format) {
        return switch (format) {
            case 33189 -> 16;
            case 33190, 35056 -> 24;
            case 36012, 36013 -> 32;
            default -> 0;
        };
    }

    public static int glFormatStencilBits(@NativeType(value="GLenum") int format) {
        return switch (format) {
            case 35056, 36013, 36168 -> 8;
            case 36169 -> 16;
            default -> 0;
        };
    }

    public static boolean glFormatIsPackedDepthStencil(@NativeType(value="GLenum") int format) {
        return format == 35056 || format == 36013;
    }

    public static boolean glFormatIsSRGB(@NativeType(value="GLenum") int format) {
        return format == 35907;
    }

    public static boolean glFormatIsCompressed(@NativeType(value="GLenum") int format) {
        return switch (format) {
            case 33776, 33777, 37492 -> true;
            default -> false;
        };
    }

    public static String glFormatName(@NativeType(value="GLenum") int format) {
        return switch (format) {
            case 32856 -> "RGBA8";
            case 33321 -> "R8";
            case 36194 -> "RGB565";
            case 34842 -> "RGBA16F";
            case 33325 -> "R16F";
            case 32849 -> "RGB8";
            case 33323 -> "RG8";
            case 32857 -> "RGB10_A2";
            case 34836 -> "RGBA32F";
            case 35907 -> "SRGB8_ALPHA8";
            case 37492 -> "ETC2";
            case 33776 -> "RGB8_BC1";
            case 33777 -> "RGBA8_BC1";
            case 33322 -> "R16";
            case 33324 -> "RG16";
            case 32859 -> "RGBA16";
            case 33327 -> "RG16F";
            case 36168 -> "STENCIL_INDEX8";
            case 36169 -> "STENCIL_INDEX16";
            case 35056 -> "DEPTH24_STENCIL8";
            default -> APIUtil.apiUnknownToken((String)"GLenum", (int)format);
        };
    }

    @Nonnull
    public static String getDebugSource(int source) {
        return switch (source) {
            case 33350 -> "API";
            case 33351 -> "Window System";
            case 33352 -> "Shader Compiler";
            case 33353 -> "Third Party";
            case 33354 -> "Application";
            case 33355 -> "Other";
            default -> APIUtil.apiUnknownToken((int)source);
        };
    }

    @Nonnull
    public static String getDebugType(int type) {
        return switch (type) {
            case 33356 -> "Error";
            case 33357 -> "Deprecated Behavior";
            case 33358 -> "Undefined Behavior";
            case 33359 -> "Portability";
            case 33360 -> "Performance";
            case 33361 -> "Other";
            case 33384 -> "Marker";
            default -> APIUtil.apiUnknownToken((int)type);
        };
    }

    @Nonnull
    public static String getDebugSeverity(int severity) {
        return switch (severity) {
            case 37190 -> "High";
            case 37191 -> "Medium";
            case 37192 -> "Low";
            case 33387 -> "Notification";
            default -> APIUtil.apiUnknownToken((int)severity);
        };
    }

    @Nonnull
    public static String getSourceARB(int source) {
        return switch (source) {
            case 33350 -> "API";
            case 33351 -> "Window System";
            case 33352 -> "Shader Compiler";
            case 33353 -> "Third Party";
            case 33354 -> "Application";
            case 33355 -> "Other";
            default -> APIUtil.apiUnknownToken((int)source);
        };
    }

    @Nonnull
    public static String getTypeARB(int type) {
        return switch (type) {
            case 33356 -> "Error";
            case 33357 -> "Deprecated Behavior";
            case 33358 -> "Undefined Behavior";
            case 33359 -> "Portability";
            case 33360 -> "Performance";
            case 33361 -> "Other";
            default -> APIUtil.apiUnknownToken((int)type);
        };
    }

    @Nonnull
    public static String getSeverityARB(int severity) {
        return switch (severity) {
            case 37190 -> "High";
            case 37191 -> "Medium";
            case 37192 -> "Low";
            default -> APIUtil.apiUnknownToken((int)severity);
        };
    }

    @Nonnull
    public static String getCategoryAMD(int category) {
        return switch (category) {
            case 37193 -> "API Error";
            case 37194 -> "Window System";
            case 37195 -> "Deprecation";
            case 37196 -> "Undefined Behavior";
            case 37197 -> "Performance";
            case 37198 -> "Shader Compiler";
            case 37199 -> "Application";
            case 37200 -> "Other";
            default -> APIUtil.apiUnknownToken((int)category);
        };
    }

    @Nonnull
    public static String getSeverityAMD(int severity) {
        return switch (severity) {
            case 37190 -> "High";
            case 37191 -> "Medium";
            case 37192 -> "Low";
            default -> APIUtil.apiUnknownToken((int)severity);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="GLuint")
    public static int glCompileShader(GLDevice device, @NativeType(value="GLenum") int shaderType, @NativeType(value="GLchar const *") ByteBuffer glsl, SharedResourceCache.Stats stats) {
        GLInterface gl = device.getGL();
        int shader = gl.glCreateShader(shaderType);
        if (shader == 0) {
            return 0;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            long string = stack.npointer((Buffer)glsl);
            long length = stack.nint(glsl.remaining());
            gl.glShaderSource(shader, 1, string, length);
        }
        finally {
            Reference.reachabilityFence(glsl);
        }
        gl.glCompileShader(shader);
        stats.incShaderCompilations();
        if (gl.glGetShaderi(shader, 35713) == 0) {
            String log = gl.glGetShaderInfoLog(shader);
            gl.glDeleteShader(shader);
            GLUtil.handleCompileError(device.getLogger(), MemoryUtil.memUTF8((ByteBuffer)glsl), log);
            return 0;
        }
        return shader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="GLuint")
    public static int glSpecializeShader(GLDevice device, @NativeType(value="GLenum") int shaderType, @NativeType(value="uint32_t *") ByteBuffer spirv, String entryPoint, SharedResourceCache.Stats stats) {
        GLInterface gl = device.getGL();
        int shader = gl.glCreateShader(shaderType);
        if (shader == 0) {
            return 0;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer shaders = stack.ints(shader);
            gl.glShaderBinary(shaders, 38225, spirv);
            shaders.limit(0);
            gl.glSpecializeShader(shader, entryPoint, shaders, shaders);
        }
        finally {
            Reference.reachabilityFence(spirv);
        }
        stats.incShaderCompilations();
        if (gl.glGetShaderi(shader, 35713) == 0) {
            String log = gl.glGetShaderInfoLog(shader);
            gl.glDeleteShader(shader);
            device.getLogger().error("Shader specialization error: {}", (Object)log);
            return 0;
        }
        return shader;
    }

    public static void handleCompileError(Logger logger, String source, String errors) {
        if (!logger.isErrorEnabled()) {
            return;
        }
        Formatter f2 = new Formatter();
        f2.format("Shader compilation error%n", new Object[0]);
        f2.format("------------------------%n", new Object[0]);
        String[] lines = source.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            f2.format(Locale.ROOT, "%4d\t%s%n", i + 1, lines[i]);
        }
        f2.format(errors, new Object[0]);
        logger.error(f2.toString());
    }

    public static void handleLinkError(Logger logger, String[] headers, String[] sources, String errors) {
        if (!logger.isErrorEnabled()) {
            return;
        }
        Formatter f2 = new Formatter();
        f2.format("Program linking error%n", new Object[0]);
        f2.format("---------------------%n", new Object[0]);
        for (int i = 0; i < headers.length; ++i) {
            f2.format("%s%n", headers[i]);
            String[] lines = sources[i].split("\n");
            for (int j = 0; j < lines.length; ++j) {
                f2.format(Locale.ROOT, "%4d\t%s%n", j + 1, lines[j]);
            }
        }
        f2.format(errors, new Object[0]);
        logger.error(f2.toString());
    }

    public static int toGLMagFilter(int filter) {
        return switch (filter) {
            case 0 -> 9728;
            case 1 -> 9729;
            default -> throw new AssertionError(filter);
        };
    }

    public static int toGLMinFilter(int filter, int mipmapMode) {
        return switch (mipmapMode) {
            case 0 -> GLUtil.toGLMagFilter(filter);
            case 1 -> {
                switch (filter) {
                    case 0: {
                        yield 9984;
                    }
                    case 1: {
                        yield 9985;
                    }
                }
                throw new AssertionError(filter);
            }
            case 2 -> {
                switch (filter) {
                    case 0: {
                        yield 9986;
                    }
                    case 1: {
                        yield 9987;
                    }
                }
                throw new AssertionError(filter);
            }
            default -> throw new AssertionError(mipmapMode);
        };
    }

    public static int toGLWrapMode(int addressMode) {
        return switch (addressMode) {
            case 0 -> 10497;
            case 1 -> 33648;
            case 2 -> 33071;
            case 3 -> 33069;
            default -> throw new AssertionError(addressMode);
        };
    }

    public static int toGLBlendEquation(byte equation) {
        return switch (equation) {
            case 1 -> 32778;
            case 2 -> 32779;
            default -> 32774;
        };
    }

    public static int toGLBlendFactor(byte factor) {
        return switch (factor) {
            case 1 -> 1;
            case 2 -> 768;
            case 3 -> 769;
            case 4 -> 774;
            case 5 -> 775;
            case 6 -> 770;
            case 7 -> 771;
            case 8 -> 772;
            case 9 -> 773;
            case 10 -> 32769;
            case 11 -> 32770;
            case 12 -> 32771;
            case 13 -> 32772;
            case 14 -> 776;
            case 15 -> 35065;
            case 16 -> 35066;
            case 17 -> 34185;
            case 18 -> 35067;
            default -> 0;
        };
    }

    public static int toGLCompareFunc(byte compareOp) {
        return 0x200 | compareOp;
    }

    public static int toGLStencilOp(byte stencilOp) {
        return switch (stencilOp) {
            case 0 -> 7680;
            case 1 -> 0;
            case 2 -> 7681;
            case 3 -> 7682;
            case 4 -> 7683;
            case 5 -> 5386;
            case 6 -> 34055;
            case 7 -> 34056;
            default -> throw new AssertionError();
        };
    }

    public static int toGLPrimitiveType(byte primitiveType) {
        return switch (primitiveType) {
            case 0 -> 0;
            case 1 -> 1;
            case 2 -> 3;
            case 3 -> 4;
            case 4 -> 5;
            default -> throw new AssertionError();
        };
    }

    public static enum GLVendor {
        OTHER,
        NVIDIA,
        ATI,
        INTEL,
        QUALCOMM;

    }

    public static enum GLDriver {
        OTHER,
        NVIDIA,
        AMD,
        INTEL,
        FREEDRENO,
        MESA;

    }
}

