/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.opengl;

import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.core.UniqueID;
import yslelf.cloudpick.render.engine.ManagedResource;
import yslelf.cloudpick.render.engine.VertexInputLayout;
import yslelf.cloudpick.render.opengl.GLBuffer;
import yslelf.cloudpick.render.opengl.GLDevice;
import yslelf.cloudpick.render.opengl.GLInterface;

public final class GLVertexArray
extends ManagedResource {
    private int mVertexArray;
    private final int[] mStrides;
    private final int[] mInputRates;
    private final int[][] mAttributes;
    private UniqueID mBoundIndexBuffer;
    private final UniqueID[] mBoundBuffers;
    private final long[] mBoundOffsets;

    private GLVertexArray(GLDevice device, int vertexArray, int[] strides, int[] inputRates, int[][] attributes) {
        super(device);
        assert (vertexArray != 0);
        assert (inputRates == null || inputRates.length == strides.length);
        assert (attributes == null || attributes.length == strides.length);
        this.mVertexArray = vertexArray;
        this.mStrides = strides;
        this.mInputRates = inputRates;
        this.mAttributes = attributes;
        this.mBoundBuffers = new UniqueID[strides.length];
        this.mBoundOffsets = new long[strides.length];
    }

    @Nullable
    @SharedPtr
    public static GLVertexArray make(@Nonnull GLDevice device, @Nonnull VertexInputLayout inputLayout, String label) {
        GLInterface gl = device.getGL();
        boolean dsa = device.getCaps().hasDSASupport();
        boolean vertexAttribBindingSupport = device.getCaps().hasVertexAttribBindingSupport();
        int bindings = inputLayout.getBindingCount();
        if ((dsa || vertexAttribBindingSupport) && bindings > device.getCaps().maxVertexBindings()) {
            return null;
        }
        int vertexArray = dsa ? gl.glCreateVertexArrays() : gl.glGenVertexArrays();
        if (vertexArray == 0) {
            return null;
        }
        int boundVertexArray = 0;
        if (!dsa) {
            boundVertexArray = gl.glGetInteger(34229);
            gl.glBindVertexArray(vertexArray);
        }
        int index = 0;
        int[] strides = new int[bindings];
        int[] inputRates = device.getCaps().hasBaseInstanceSupport() ? null : new int[bindings];
        int[][] attributes = dsa || vertexAttribBindingSupport ? null : new int[bindings][];
        for (int binding = 0; binding < bindings; ++binding) {
            int inputRate = inputLayout.getInputRate(binding);
            if (dsa) {
                index = GLVertexArray.set_vertex_format_binding_group_dsa(gl, inputLayout.getAttributes(binding), vertexArray, index, binding, inputRate);
            } else if (vertexAttribBindingSupport) {
                index = GLVertexArray.set_vertex_format_binding_group(gl, inputLayout.getAttributes(binding), index, binding, inputRate);
            } else {
                int prevIndex = index;
                int[] attrs = new int[inputLayout.getLocationCount(binding)];
                index = GLVertexArray.set_vertex_format_legacy(gl, inputLayout.getAttributes(binding), index, inputRate, attrs);
                attributes[binding] = attrs;
                assert (prevIndex + attrs.length == index);
            }
            strides[binding] = inputLayout.getStride(binding);
            if (inputRates == null) continue;
            inputRates[binding] = inputRate;
        }
        if (!dsa) {
            gl.glBindVertexArray(boundVertexArray);
        }
        if (index > device.getCaps().maxVertexAttributes()) {
            gl.glDeleteVertexArrays(vertexArray);
            return null;
        }
        if (device.getCaps().hasDebugSupport() && label != null && !((String)label).isEmpty()) {
            label = "Arc3D_VAO_" + (String)label;
            label = ((String)label).substring(0, Math.min(((String)label).length(), device.getCaps().maxLabelLength()));
            gl.glObjectLabel(32884, vertexArray, (CharSequence)label);
        }
        return new GLVertexArray(device, vertexArray, strides, inputRates, attributes);
    }

    private static int set_vertex_format_legacy(GLInterface gl, @Nonnull Iterator<VertexInputLayout.Attribute> attribs, int index, int divisor, int[] attributes) {
        while (attribs.hasNext()) {
            VertexInputLayout.Attribute attrib = attribs.next();
            int locations = attrib.locations();
            int offset = attrib.offset();
            while (locations-- != 0) {
                gl.glEnableVertexAttribArray(index);
                gl.glVertexAttribDivisor(index, divisor);
                assert (offset >= 0 && offset <= 0xFFFFFF);
                attributes[index] = offset & 0xFFFFFF | (attrib.srcType() & 0xFF) << 24;
                ++index;
                offset += attrib.size();
            }
        }
        return index;
    }

    private static void set_attrib_format_legacy(GLInterface gl, int type, int index, int stride, long offset) {
        switch (type) {
            case 0: {
                gl.glVertexAttribPointer(index, 1, 5126, false, stride, offset);
                break;
            }
            case 1: {
                gl.glVertexAttribPointer(index, 2, 5126, false, stride, offset);
                break;
            }
            case 2: {
                gl.glVertexAttribPointer(index, 3, 5126, false, stride, offset);
                break;
            }
            case 3: {
                gl.glVertexAttribPointer(index, 4, 5126, false, stride, offset);
                break;
            }
            case 4: {
                gl.glVertexAttribPointer(index, 1, 5131, false, stride, offset);
                break;
            }
            case 5: {
                gl.glVertexAttribPointer(index, 2, 5131, false, stride, offset);
                break;
            }
            case 6: {
                gl.glVertexAttribPointer(index, 4, 5131, false, stride, offset);
                break;
            }
            case 7: {
                gl.glVertexAttribIPointer(index, 2, 5124, stride, offset);
                break;
            }
            case 8: {
                gl.glVertexAttribIPointer(index, 3, 5124, stride, offset);
                break;
            }
            case 9: {
                gl.glVertexAttribIPointer(index, 4, 5124, stride, offset);
                break;
            }
            case 10: {
                gl.glVertexAttribIPointer(index, 1, 5120, stride, offset);
                break;
            }
            case 11: {
                gl.glVertexAttribIPointer(index, 2, 5120, stride, offset);
                break;
            }
            case 12: {
                gl.glVertexAttribIPointer(index, 4, 5120, stride, offset);
                break;
            }
            case 13: {
                gl.glVertexAttribIPointer(index, 1, 5121, stride, offset);
                break;
            }
            case 14: {
                gl.glVertexAttribIPointer(index, 2, 5121, stride, offset);
                break;
            }
            case 15: {
                gl.glVertexAttribIPointer(index, 4, 5121, stride, offset);
                break;
            }
            case 16: {
                gl.glVertexAttribPointer(index, 1, 5121, true, stride, offset);
                break;
            }
            case 17: {
                gl.glVertexAttribPointer(index, 4, 5121, true, stride, offset);
                break;
            }
            case 18: {
                gl.glVertexAttribIPointer(index, 2, 5122, stride, offset);
                break;
            }
            case 19: {
                gl.glVertexAttribIPointer(index, 4, 5122, stride, offset);
                break;
            }
            case 20: {
                gl.glVertexAttribIPointer(index, 2, 5123, stride, offset);
                break;
            }
            case 21: {
                gl.glVertexAttribPointer(index, 2, 5123, true, stride, offset);
                break;
            }
            case 22: {
                gl.glVertexAttribIPointer(index, 1, 5124, stride, offset);
                break;
            }
            case 23: {
                gl.glVertexAttribIPointer(index, 1, 5125, stride, offset);
                break;
            }
            case 24: {
                gl.glVertexAttribPointer(index, 1, 5123, true, stride, offset);
                break;
            }
            case 25: {
                gl.glVertexAttribPointer(index, 4, 5123, true, stride, offset);
                break;
            }
            default: {
                throw new AssertionError(type);
            }
        }
    }

    private static int set_vertex_format_binding_group(GLInterface gl, @Nonnull Iterator<VertexInputLayout.Attribute> attribs, int index, int binding, int divisor) {
        while (attribs.hasNext()) {
            VertexInputLayout.Attribute attrib = attribs.next();
            int locations = attrib.locations();
            int offset = attrib.offset();
            while (locations-- != 0) {
                gl.glEnableVertexAttribArray(index);
                gl.glVertexAttribBinding(index, binding);
                GLVertexArray.set_attrib_format_binding_group(gl, attrib.srcType(), index, offset);
                ++index;
                offset += attrib.size();
            }
        }
        gl.glVertexBindingDivisor(binding, divisor);
        return index;
    }

    private static void set_attrib_format_binding_group(GLInterface gl, int type, int index, int offset) {
        switch (type) {
            case 0: {
                gl.glVertexAttribFormat(index, 1, 5126, false, offset);
                break;
            }
            case 1: {
                gl.glVertexAttribFormat(index, 2, 5126, false, offset);
                break;
            }
            case 2: {
                gl.glVertexAttribFormat(index, 3, 5126, false, offset);
                break;
            }
            case 3: {
                gl.glVertexAttribFormat(index, 4, 5126, false, offset);
                break;
            }
            case 4: {
                gl.glVertexAttribFormat(index, 1, 5131, false, offset);
                break;
            }
            case 5: {
                gl.glVertexAttribFormat(index, 2, 5131, false, offset);
                break;
            }
            case 6: {
                gl.glVertexAttribFormat(index, 4, 5131, false, offset);
                break;
            }
            case 7: {
                gl.glVertexAttribIFormat(index, 2, 5124, offset);
                break;
            }
            case 8: {
                gl.glVertexAttribIFormat(index, 3, 5124, offset);
                break;
            }
            case 9: {
                gl.glVertexAttribIFormat(index, 4, 5124, offset);
                break;
            }
            case 10: {
                gl.glVertexAttribIFormat(index, 1, 5120, offset);
                break;
            }
            case 11: {
                gl.glVertexAttribIFormat(index, 2, 5120, offset);
                break;
            }
            case 12: {
                gl.glVertexAttribIFormat(index, 4, 5120, offset);
                break;
            }
            case 13: {
                gl.glVertexAttribIFormat(index, 1, 5121, offset);
                break;
            }
            case 14: {
                gl.glVertexAttribIFormat(index, 2, 5121, offset);
                break;
            }
            case 15: {
                gl.glVertexAttribIFormat(index, 4, 5121, offset);
                break;
            }
            case 16: {
                gl.glVertexAttribFormat(index, 1, 5121, true, offset);
                break;
            }
            case 17: {
                gl.glVertexAttribFormat(index, 4, 5121, true, offset);
                break;
            }
            case 18: {
                gl.glVertexAttribIFormat(index, 2, 5122, offset);
                break;
            }
            case 19: {
                gl.glVertexAttribIFormat(index, 4, 5122, offset);
                break;
            }
            case 20: {
                gl.glVertexAttribIFormat(index, 2, 5123, offset);
                break;
            }
            case 21: {
                gl.glVertexAttribFormat(index, 2, 5123, true, offset);
                break;
            }
            case 22: {
                gl.glVertexAttribIFormat(index, 1, 5124, offset);
                break;
            }
            case 23: {
                gl.glVertexAttribIFormat(index, 1, 5125, offset);
                break;
            }
            case 24: {
                gl.glVertexAttribFormat(index, 1, 5123, true, offset);
                break;
            }
            case 25: {
                gl.glVertexAttribFormat(index, 4, 5123, true, offset);
                break;
            }
            default: {
                throw new AssertionError(type);
            }
        }
    }

    private static int set_vertex_format_binding_group_dsa(GLInterface gl, @Nonnull Iterator<VertexInputLayout.Attribute> attribs, int array, int index, int binding, int divisor) {
        while (attribs.hasNext()) {
            VertexInputLayout.Attribute attrib = attribs.next();
            int locations = attrib.locations();
            int offset = attrib.offset();
            while (locations-- != 0) {
                gl.glEnableVertexArrayAttrib(array, index);
                gl.glVertexArrayAttribBinding(array, index, binding);
                GLVertexArray.set_attrib_format_binding_group_dsa(gl, attrib.srcType(), array, index, offset);
                ++index;
                offset += attrib.size();
            }
        }
        gl.glVertexArrayBindingDivisor(array, binding, divisor);
        return index;
    }

    private static void set_attrib_format_binding_group_dsa(GLInterface gl, int type, int array, int index, int offset) {
        switch (type) {
            case 0: {
                gl.glVertexArrayAttribFormat(array, index, 1, 5126, false, offset);
                break;
            }
            case 1: {
                gl.glVertexArrayAttribFormat(array, index, 2, 5126, false, offset);
                break;
            }
            case 2: {
                gl.glVertexArrayAttribFormat(array, index, 3, 5126, false, offset);
                break;
            }
            case 3: {
                gl.glVertexArrayAttribFormat(array, index, 4, 5126, false, offset);
                break;
            }
            case 4: {
                gl.glVertexArrayAttribFormat(array, index, 1, 5131, false, offset);
                break;
            }
            case 5: {
                gl.glVertexArrayAttribFormat(array, index, 2, 5131, false, offset);
                break;
            }
            case 6: {
                gl.glVertexArrayAttribFormat(array, index, 4, 5131, false, offset);
                break;
            }
            case 7: {
                gl.glVertexArrayAttribIFormat(array, index, 2, 5124, offset);
                break;
            }
            case 8: {
                gl.glVertexArrayAttribIFormat(array, index, 3, 5124, offset);
                break;
            }
            case 9: {
                gl.glVertexArrayAttribIFormat(array, index, 4, 5124, offset);
                break;
            }
            case 10: {
                gl.glVertexArrayAttribIFormat(array, index, 1, 5120, offset);
                break;
            }
            case 11: {
                gl.glVertexArrayAttribIFormat(array, index, 2, 5120, offset);
                break;
            }
            case 12: {
                gl.glVertexArrayAttribIFormat(array, index, 4, 5120, offset);
                break;
            }
            case 13: {
                gl.glVertexArrayAttribIFormat(array, index, 1, 5121, offset);
                break;
            }
            case 14: {
                gl.glVertexArrayAttribIFormat(array, index, 2, 5121, offset);
                break;
            }
            case 15: {
                gl.glVertexArrayAttribIFormat(array, index, 4, 5121, offset);
                break;
            }
            case 16: {
                gl.glVertexArrayAttribFormat(array, index, 1, 5121, true, offset);
                break;
            }
            case 17: {
                gl.glVertexArrayAttribFormat(array, index, 4, 5121, true, offset);
                break;
            }
            case 18: {
                gl.glVertexArrayAttribIFormat(array, index, 2, 5122, offset);
                break;
            }
            case 19: {
                gl.glVertexArrayAttribIFormat(array, index, 4, 5122, offset);
                break;
            }
            case 20: {
                gl.glVertexArrayAttribIFormat(array, index, 2, 5123, offset);
                break;
            }
            case 21: {
                gl.glVertexArrayAttribFormat(array, index, 2, 5123, true, offset);
                break;
            }
            case 22: {
                gl.glVertexArrayAttribIFormat(array, index, 1, 5124, offset);
                break;
            }
            case 23: {
                gl.glVertexArrayAttribIFormat(array, index, 1, 5125, offset);
                break;
            }
            case 24: {
                gl.glVertexArrayAttribFormat(array, index, 1, 5123, true, offset);
                break;
            }
            case 25: {
                gl.glVertexArrayAttribFormat(array, index, 4, 5123, true, offset);
                break;
            }
            default: {
                throw new AssertionError(type);
            }
        }
    }

    @Override
    protected void deallocate() {
        this.getDevice().executeRenderCall(dev -> {
            if (this.mVertexArray != 0) {
                dev.getGL().glDeleteVertexArrays(this.mVertexArray);
            }
            this.discard();
        });
    }

    public void discard() {
        this.mVertexArray = 0;
    }

    public int getHandle() {
        return this.mVertexArray;
    }

    public int getBindingCount() {
        return this.mStrides.length;
    }

    public int getStride(int binding) {
        return this.mStrides[binding];
    }

    public int getInputRate(int binding) {
        return this.mInputRates[binding];
    }

    public void bindIndexBuffer(@Nonnull @RawPtr GLBuffer buffer) {
        if (this.mVertexArray == 0) {
            return;
        }
        if (this.mBoundIndexBuffer != buffer.getUniqueID()) {
            this.getDevice().getGL().glBindBuffer(34963, buffer.getHandle());
            this.mBoundIndexBuffer = buffer.getUniqueID();
        }
    }

    public void bindVertexBuffer(int binding, @Nonnull @RawPtr GLBuffer buffer, long offset) {
        if (this.mVertexArray == 0) {
            return;
        }
        if (this.mBoundBuffers[binding] != buffer.getUniqueID() || this.mBoundOffsets[binding] != offset) {
            int stride = this.mStrides[binding];
            assert (stride > 0);
            if (this.mAttributes == null) {
                this.getDevice().getGL().glBindVertexBuffer(binding, buffer.getHandle(), offset, stride);
            } else {
                this.getDevice().getGL().glBindBuffer(34962, buffer.getHandle());
                int index = 0;
                for (int i = 0; i < binding; ++i) {
                    index += this.mAttributes[i].length;
                }
                for (int info : this.mAttributes[binding]) {
                    GLVertexArray.set_attrib_format_legacy(this.getDevice().getGL(), info >> 24, index, stride, offset + (long)(info & 0xFFFFFF));
                    ++index;
                }
            }
            this.mBoundBuffers[binding] = buffer.getUniqueID();
            this.mBoundOffsets[binding] = offset;
        }
    }

    @Override
    protected GLDevice getDevice() {
        return (GLDevice)super.getDevice();
    }
}

