/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.vulkan;

import javax.annotation.Nonnull;
import yslelf.cloudpick.render.engine.BackendFormat;
import yslelf.cloudpick.render.engine.BackendImage;
import yslelf.cloudpick.render.vulkan.VkBackendFormat;
import yslelf.cloudpick.render.vulkan.VulkanAllocation;
import yslelf.cloudpick.render.vulkan.VulkanImageDesc;
import yslelf.cloudpick.render.vulkan.VulkanImageMutableState;

public final class VulkanBackendImage
extends BackendImage {
    private static final int DEFAULT_USAGE_FLAGS = 23;
    private long mImage;
    public int mLevelCount = 0;
    public long mMemoryHandle = -1L;
    private VulkanAllocation mAlloc;
    private final VulkanImageDesc mInfo;
    final VulkanImageMutableState mState;
    private final BackendFormat mBackendFormat;

    public VulkanBackendImage(int width, int height, VulkanImageDesc desc) {
        this(width, height, desc, null, VkBackendFormat.make(desc.mFormat));
    }

    VulkanBackendImage(int width, int height, VulkanImageDesc desc, VulkanImageMutableState state, BackendFormat backendFormat) {
        super(desc, state);
        this.mInfo = desc;
        this.mState = state;
        this.mBackendFormat = backendFormat;
    }

    @Override
    public int getBackend() {
        return 1;
    }

    @Override
    public boolean isExternal() {
        return this.mBackendFormat.isExternal();
    }

    @Override
    public void setVkImageLayout(int layout) {
        this.mState.setImageLayout(layout);
    }

    @Override
    public void setVkQueueFamilyIndex(int queueFamilyIndex) {
        this.mState.setQueueFamilyIndex(queueFamilyIndex);
    }

    @Override
    @Nonnull
    public BackendFormat getBackendFormat() {
        return this.mBackendFormat;
    }

    @Override
    public boolean isProtected() {
        return this.mInfo.isProtected();
    }

    @Override
    public boolean isSameImage(BackendImage image) {
        if (image instanceof VulkanBackendImage) {
            VulkanBackendImage t2 = (VulkanBackendImage)image;
            return this.mImage == t2.mImage;
        }
        return false;
    }
}

