/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.vulkan;

import java.nio.LongBuffer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VK10;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkImageCreateInfo;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.engine.Context;
import yslelf.cloudpick.render.engine.DataUtils;
import yslelf.cloudpick.render.engine.IResourceKey;
import yslelf.cloudpick.render.engine.Image;
import yslelf.cloudpick.render.vulkan.VKUtil;
import yslelf.cloudpick.render.vulkan.VulkanAllocation;
import yslelf.cloudpick.render.vulkan.VulkanDevice;
import yslelf.cloudpick.render.vulkan.VulkanImageDesc;
import yslelf.cloudpick.render.vulkan.VulkanImageMutableState;
import yslelf.cloudpick.render.vulkan.VulkanMemoryAllocator;

public final class VulkanImage
extends Image {
    private final long mImage;
    private final VulkanAllocation mMemoryAlloc;

    public VulkanImage(Context context, VulkanImageDesc desc, VulkanImageMutableState mutableState, long image, VulkanAllocation memoryAlloc, boolean budgeted, boolean wrapped) {
        super(context, budgeted, wrapped, desc, mutableState);
        this.mImage = image;
        this.mMemoryAlloc = memoryAlloc;
    }

    @Nullable
    public static CreatedImageInfo create(VulkanDevice device, VulkanImageDesc desc) {
        boolean isLinear = desc.mImageTiling == 1;
        int initialLayout = isLinear ? 8 : 0;
        int vkSamples = VKUtil.toVkSampleCount(desc.getSampleCount());
        if (vkSamples == 0) {
            device.getLogger().error("Failed to create VulkanImage: unsupported number of samples {}", (Object)desc.getSampleCount());
            return null;
        }
        assert (!isLinear || vkSamples == 1);
        try (MemoryStack stack = MemoryStack.stackPush();){
            VkImageCreateInfo pCreateInfo = VkImageCreateInfo.malloc((MemoryStack)stack).sType$Default().pNext(0L).flags(desc.mVkFlags).imageType(desc.mVkImageType).format(desc.mFormat);
            pCreateInfo.extent().set(desc.getWidth(), desc.getHeight(), desc.getDepth());
            int layers = desc.getImageType() == 3 || desc.getImageType() == 4 ? 6 : 1;
            pCreateInfo.mipLevels(desc.getMipLevelCount()).arrayLayers(desc.getArraySize() * layers).samples(vkSamples).tiling(desc.mImageTiling).usage(desc.mImageUsageFlags).sharingMode(desc.mSharingMode).queueFamilyIndexCount(0).pQueueFamilyIndices(null).initialLayout(initialLayout);
            LongBuffer pImage = stack.mallocLong(1);
            int result = VK10.vkCreateImage((VkDevice)device.vkDevice(), (VkImageCreateInfo)pCreateInfo, null, (LongBuffer)pImage);
            device.checkResult(result);
            if (result != 0) {
                device.getLogger().error("Failed to create VulkanImage: {}", (Object)VKUtil.getResultMessage(result));
                CreatedImageInfo createdImageInfo = null;
                return createdImageInfo;
            }
            VulkanMemoryAllocator allocator = device.getMemoryAllocator();
            VulkanAllocation allocInfo = new VulkanAllocation();
            boolean useLazyAllocation = (desc.mImageUsageFlags & 0x40) != 0;
            int allocFlags = 0;
            long size = DataUtils.computeSize(desc);
            if (!useLazyAllocation && (desc.isRenderable() || size >= 0xC00000L)) {
                allocFlags |= 1;
            }
            if (useLazyAllocation) {
                allocFlags |= 4;
            }
            if (!allocator.allocateImageMemory(device, pImage.get(0), allocFlags, allocInfo)) {
                VK10.vkDestroyImage((VkDevice)device.vkDevice(), (long)pImage.get(0), null);
                device.getLogger().error("Failed to create VulkanImage: cannot allocate {} bytes from device", (Object)size);
                CreatedImageInfo createdImageInfo = null;
                return createdImageInfo;
            }
            if (useLazyAllocation && (allocInfo.mMemoryFlags & 4) == 0) {
                allocator.freeMemory(allocInfo);
                VK10.vkDestroyImage((VkDevice)device.vkDevice(), (long)pImage.get(0), null);
                device.getLogger().error("Failed to create VulkanImage: cannot allocate lazy memory when requested");
                CreatedImageInfo createdImageInfo = null;
                return createdImageInfo;
            }
            result = VK10.vkBindImageMemory((VkDevice)device.vkDevice(), (long)pImage.get(0), (long)allocInfo.mMemory, (long)allocInfo.mOffset);
            device.checkResult(result);
            if (result != 0) {
                allocator.freeMemory(allocInfo);
                VK10.vkDestroyImage((VkDevice)device.vkDevice(), (long)pImage.get(0), null);
                device.getLogger().error("Failed to bind image memory: {}", (Object)VKUtil.getResultMessage(result));
                CreatedImageInfo createdImageInfo = null;
                return createdImageInfo;
            }
            CreatedImageInfo createdImageInfo = new CreatedImageInfo(pImage.get(0), allocInfo, new VulkanImageMutableState(initialLayout, -1));
            return createdImageInfo;
        }
    }

    @Nullable
    @SharedPtr
    public static VulkanImage make(@Nonnull Context context, @Nonnull VulkanImageDesc desc, boolean budgeted) {
        VulkanDevice device = (VulkanDevice)context.getDevice();
        CreatedImageInfo imageInfo = VulkanImage.create(device, desc);
        if (imageInfo == null) {
            return null;
        }
        return new VulkanImage(context, desc, imageInfo.mutableState, imageInfo.image, imageInfo.memoryAlloc, budgeted, false);
    }

    @NativeType(value="VkImage")
    public long vkImage() {
        return this.mImage;
    }

    @Override
    protected void onRelease() {
        if (!this.isWrapped()) {
            VulkanDevice device = (VulkanDevice)this.getDevice();
            device.getMemoryAllocator().freeMemory(this.mMemoryAlloc);
            VK10.vkDestroyImage((VkDevice)device.vkDevice(), (long)this.mImage, null);
        }
    }

    public String toString() {
        return "VulkanImage{mDesc=" + this.getDesc() + ", mImage=0x" + Long.toHexString(this.mImage) + ", mMemoryAlloc=" + this.mMemoryAlloc + ", mDestroyed=" + this.isDestroyed() + ", mLabel=" + this.getLabel() + ", mMemorySize=" + this.getMemorySize() + "}";
    }

    public record CreatedImageInfo(long image, VulkanAllocation memoryAlloc, VulkanImageMutableState mutableState) {
    }

    public static final class ResourceKey
    implements IResourceKey {
        private final VulkanImageDesc mDesc;

        public ResourceKey(VulkanImageDesc desc) {
            this.mDesc = desc;
        }

        @Override
        public IResourceKey copy() {
            return new ResourceKey(this.mDesc);
        }

        @Override
        public int hashCode() {
            return this.mDesc.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceKey that = (ResourceKey)o;
            return this.mDesc.equals(that.mDesc);
        }
    }
}

