/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.vulkan;

import java.nio.LongBuffer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VK10;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkImageViewCreateInfo;
import yslelf.cloudpick.render.engine.ManagedResource;
import yslelf.cloudpick.render.engine.Swizzle;
import yslelf.cloudpick.render.vulkan.VKUtil;
import yslelf.cloudpick.render.vulkan.VulkanDevice;

public final class VulkanImageView
extends ManagedResource {
    private final long mImageView;
    private final int mBaseMipLevel;
    private final int mLevelCount;
    private final int mBaseArrayLayer;
    private final int mLayerCount;

    VulkanImageView(VulkanDevice device, long imageView, int baseMipLevel, int levelCount, int baseArrayLayer, int layerCount) {
        super(device);
        this.mImageView = imageView;
        this.mBaseMipLevel = baseMipLevel;
        this.mLevelCount = levelCount;
        this.mBaseArrayLayer = baseArrayLayer;
        this.mLayerCount = layerCount;
    }

    private static int get_aspect_mask(int format) {
        return switch (format) {
            case 127 -> 4;
            case 124, 125, 126 -> 2;
            case 128, 129, 130 -> 6;
            default -> 1;
        };
    }

    private static int get_view_type(int imageType) {
        return switch (imageType) {
            case 1 -> 1;
            case 2 -> 5;
            case 3 -> 3;
            case 4 -> 6;
            case 5 -> 2;
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError(imageType);
                }
                yield 0;
            }
        };
    }

    private static int get_swizzle(int index) {
        return switch (index) {
            case 0 -> 3;
            case 1 -> 4;
            case 2 -> 5;
            case 3 -> 6;
            case 4 -> 1;
            case 5 -> 2;
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError(index);
                }
                yield 0;
            }
        };
    }

    @Nullable
    public static VulkanImageView makeTexture(@Nonnull VulkanDevice device, long image, int imageType, @NativeType(value="VkFormat") int format, short swizzle, int mipLevelCount, int layerCount) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            VkImageViewCreateInfo pCreateInfo = VkImageViewCreateInfo.malloc((MemoryStack)stack).sType$Default().pNext(0L).flags(0).image(image).viewType(VulkanImageView.get_view_type(imageType)).format(format);
            if (swizzle != 12816) {
                pCreateInfo.components().set(VulkanImageView.get_swizzle(Swizzle.getR(swizzle)), VulkanImageView.get_swizzle(Swizzle.getG(swizzle)), VulkanImageView.get_swizzle(Swizzle.getB(swizzle)), VulkanImageView.get_swizzle(Swizzle.getA(swizzle)));
            } else {
                pCreateInfo.components().set(0, 0, 0, 0);
            }
            pCreateInfo.subresourceRange().aspectMask(VulkanImageView.get_aspect_mask(format)).baseMipLevel(0).levelCount(mipLevelCount).baseArrayLayer(0).layerCount(layerCount);
            LongBuffer pView = stack.mallocLong(1);
            int result = VK10.vkCreateImageView((VkDevice)device.vkDevice(), (VkImageViewCreateInfo)pCreateInfo, null, (LongBuffer)pView);
            device.checkResult(result);
            if (result != 0) {
                device.getLogger().error("Failed to create shader resource view: {}", (Object)VKUtil.getResultMessage(result));
                VulkanImageView vulkanImageView = null;
                return vulkanImageView;
            }
            VulkanImageView vulkanImageView = new VulkanImageView(device, pView.get(0), 0, mipLevelCount, 0, layerCount);
            return vulkanImageView;
        }
    }

    @Nullable
    public static VulkanImageView makeAttachment(@Nonnull VulkanDevice device, long image, int imageType, @NativeType(value="VkFormat") int format, int mipLevel, int arraySlice) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            VkImageViewCreateInfo pCreateInfo = VkImageViewCreateInfo.malloc((MemoryStack)stack).sType$Default().pNext(0L).flags(0).image(image).viewType(VulkanImageView.get_view_type(imageType)).format(format);
            pCreateInfo.components().set(0, 0, 0, 0);
            pCreateInfo.subresourceRange().aspectMask(VulkanImageView.get_aspect_mask(format)).baseMipLevel(mipLevel).levelCount(1).baseArrayLayer(arraySlice).layerCount(1);
            LongBuffer pView = stack.mallocLong(1);
            int result = VK10.vkCreateImageView((VkDevice)device.vkDevice(), (VkImageViewCreateInfo)pCreateInfo, null, (LongBuffer)pView);
            device.checkResult(result);
            if (result != 0) {
                device.getLogger().error("Failed to create render target view: {}", (Object)VKUtil.getResultMessage(result));
                VulkanImageView vulkanImageView = null;
                return vulkanImageView;
            }
            VulkanImageView vulkanImageView = new VulkanImageView(device, pView.get(0), mipLevel, 1, arraySlice, 1);
            return vulkanImageView;
        }
    }

    @NativeType(value="VkImageView")
    public long vkImageView() {
        return this.mImageView;
    }

    public int getBaseMipLevel() {
        return this.mBaseMipLevel;
    }

    public int getLevelCount() {
        return this.mLevelCount;
    }

    public int getBaseArrayLayer() {
        return this.mBaseArrayLayer;
    }

    public int getLayerCount() {
        return this.mLayerCount;
    }

    @Override
    protected void deallocate() {
        VulkanDevice device = (VulkanDevice)this.getDevice();
        VK10.vkDestroyImageView((VkDevice)device.vkDevice(), (long)this.mImageView, null);
    }
}

